/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml.pullparser;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import junit.framework.TestCase;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xerial.util.xml.XMLException;
import org.xerial.util.xml.pullparser.DOMBuilder;
import org.xmlpull.v1.XmlPullParserException;

public class DOMBuilderTest
extends TestCase {
    DOMBuilder _builder;
    String _xmlSample = "sample/booklist.xml";
    Reader _xmlReader;
    HashMap<String, Tag> _tagMap;

    protected void setUp() throws Exception {
        super.setUp();
        this._builder = new DOMBuilder();
        this._xmlReader = new FileReader(this._xmlSample);
        this._tagMap = new HashMap();
        Tag[] tagArray = Tag.values();
        int n = 0;
        int n2 = tagArray.length;
        while (n < n2) {
            Tag tag = tagArray[n];
            this._tagMap.put(tag.name(), tag);
            ++n;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this._xmlReader.close();
    }

    public void testParseReader() throws IOException {
        try {
            Element element = this._builder.parse(this._xmlReader);
            DOMBuilderTest.assertEquals((String)"booklist", (String)element.getTagName());
            NodeList bookNodes = element.getElementsByTagName("book");
            DOMBuilderTest.assertEquals((int)2, (int)bookNodes.getLength());
            Element book1 = (Element)bookNodes.item(0);
            DOMBuilderTest.assertNotNull((Object)book1);
            String isbn = book1.getAttribute("isbn");
            DOMBuilderTest.assertNotNull((Object)isbn);
            DOMBuilderTest.assertEquals((String)"1558607544", (String)isbn);
        }
        catch (XMLException e) {
            DOMBuilderTest.fail((String)e.getMessage());
        }
        catch (XmlPullParserException e) {
            DOMBuilderTest.fail((String)e.getMessage());
        }
    }

    public void testParseXmlPullParser() {
    }

    public void testCreateQName() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Tag {
        author,
        title,
        year;

    }
}

