package lib.io;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * Zip `ŃA[JCuTvłB
 * {t@CAfBNgɖΉ
 */
public class ZipCompresser {

    /**
     * ɂȂfBNgt@C
     */
    private File baseFile;

    /**
     * N_ɂȂfBNgit@Cj̐΃pX
     */
    private String baseFilePath;

    /**
     * RXgN^
     * @param base N_ɂȂfBNgA̓t@C
     */
    public ZipCompresser(File base) {
        super();
        this.baseFile = base;
        this.baseFilePath = base.getAbsolutePath();
    }

    /**
     * baseFile k܂B
     */
    public void archive() {
        // o͐t@C
        File zipfile =
                new File(this.baseFile.getParent(), this.baseFile.getName()
                        + ".xlsx");
        ZipOutputStream zos = null;
        try {
            // o͐ OutputStream 𐶐
            zos = new ZipOutputStream(new FileOutputStream(zipfile));
            archive(zos, this.baseFile);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } finally {
            try {
                zos.close();
            } catch (IOException e) {
            }
        }
    }

    /**
     * file  zos ɏo͂܂B
     * @param zos zipt@Co̓Xg[
     * @param file ͌t@C
     */
    private void archive(ZipOutputStream zos, File file) {

        if (file.isDirectory()) {
            // fBNg͊܂܂t@CċNĂяoB
            File[] files = file.listFiles();
            for (File f : files) {
                archive(zos, f);
            }
        } else {
            BufferedInputStream fis = null;
            try {
                // ̓Xg[
                fis = new BufferedInputStream(new FileInputStream(file));

                // Entry ̂擾B
                String entryName =
                        file.getAbsolutePath().replace(this.baseFilePath, "")
                                .substring(1);

                // o͐ Entry ݒ肷B
                zos.putNextEntry(new ZipEntry(entryName));

                // ̓t@Cǂݍݏo̓Xg[ɏł
                int ava = 0;
                while ((ava = fis.available()) > 0) {
                    byte[] bs = new byte[ava];
                    fis.read(bs);
                    zos.write(bs);
                }

                // 񂾂 Entry  close B
                zos.closeEntry();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                try {
                    fis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
