package lib.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtendFile extends File{
    private static final long serialVersionUID = 1L;

    /**
     * コンストラクタ
     * @param filePath
     */
    public ExtendFile(String filePath) {
        super(filePath);
    }

    /**
     * ファイルコピー処理.
     * Windowsのコマンドを使用しファイルをコピーする。
     * @param fromPath
     * @param toPath
     * @return
     */
    public static String  dirCopyDos (String fromPath,String toPath) {
        String[] cmdList = {"cmd","/C","copy","/B","/Y","",""};
        cmdList[5] = fromPath;
        cmdList[6] = toPath;
        return commander(cmdList);
    }

    /**
     * ディレクトリコピー処理.
     * Windowsのコマンドを使用しディレクトリをコピーする。
     * @param fromPath
     * @param toPath
     * @return
     */
    public static String  dirXCopy (String fromPath,String toPath) {
        String[] cmdList = {"xcopy","/E","/Y","",""};
        cmdList[3] = fromPath;
        cmdList[4] = toPath;
        return commander(cmdList);
    }

    /**
     * ファイルのコピー処理.
     * @param fromPath
     * @param toPath
     */
    public void fileCopyJava (String fromPath, String toPath) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(fromPath);
            fos = new FileOutputStream(toPath);
            byte[] b = new byte[1024];
            while(true) {
                int i = fis.read(b);
                if(i < 0) {
                    break;
                }
                fos.write(b, 0, i);
            }

            fos.close();
            fis.close();
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * ZIPファイルを展開する
     * @param fromPath 対象ZIPファイルパス
     * @param toPath 展開先のフォルダ
     * @return
     */
    public ArrayList<String> unzip (String fromPath,String toPath)
            throws IOException{

        ArrayList<String> fileList = new ArrayList<String>();
        FileOutputStream fos = null;
        String outFilePath = null;
        if(toPath.charAt(toPath.length() - 1) != '/') {
            toPath += "/";
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(fromPath));
        for(ZipEntry ze = zis.getNextEntry();ze != null;ze = zis.getNextEntry()) {
            fileList.add(ze.getName());
            outFilePath = toPath + ze.getName();
            File file = new File(outFilePath);
            File parent = new File(file.getParent());
            if(!parent.exists()) {
                makeDir(file.getParent());
            }
            fos = new FileOutputStream(outFilePath);

            byte[] b = new byte[1024];
            int size = 0;
            while((size = zis.read(b)) >= 0) {
                fos.write(b,0,size);
            }
            zis.closeEntry();
            fos.close();
        }
        return fileList;
    }

    /**
     * ディレクトリ作成メソッド
     * 指定したディレクトリを何階層までも作成する
     * @param dirPath
     */
    public void makeDir(String dirPath) {
        File file = new File(dirPath);
        String[] dirs = file.getPath().split("\\\\");
        String mkDir = "";
        for(String dirName:dirs) {
            mkDir += dirName + "/";
            file = new File(mkDir);
            if(!file.exists()) {
                file.mkdir();
            }
        }
    }

    /**
     * DOSコマンドを実行する.
     * @param cmdList
     * @return 実行し画面に出力された文字列
     */
    public static String commander(String[] cmdList) {
        InputStream stdIn = null;
        InputStream errIn = null;
        Process p;
        ProcessBuilder pb = new ProcessBuilder(cmdList);
        char[] charList = new char[10000];
        try {
            int i = 0;
            int getInt;
            p = pb.start();
            stdIn = p.getInputStream();
            errIn = p.getErrorStream();
            while((getInt = stdIn.read()) >= 0) {
                charList[i] = (char)getInt;
                i++;
            }
            stdIn.close();
            while((i = errIn.read()) >= 0) {
                System.out.print((char)getInt);
            }
            errIn.close();
            try{
                p.waitFor();
            } catch(InterruptedException ie) {
                ie.printStackTrace();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        //System.out.println(rc);
        return new String(charList);
    }

    /**
     * ディレクトリ検索.
     * ディレクトリの検索を再帰的に行い詳細をfileListに追加する
     * @param fileList ファイル情報リスト
     * @param path 検索対象パス
     */
    public void dirSearch(String path, ArrayList<File> fileList) {
        File rootDir = new File(path);

        boolean isDir = rootDir.isDirectory();
        boolean isFile = rootDir.isFile();

        // ディレクトリなら再帰呼び出しを実行
        if(isDir) {
            String[] dirList = rootDir.list();
            // ディレクトリに対して拒否された可能性
            if(dirList == null) {
                System.out.println("\"" + path + "\" はアクセスを拒否された可能性あり" );
            } else {
                for(int i = 0;i < dirList.length;i++ ) {
                    dirSearch(path + "/" + dirList[i], fileList);
                }
            }
        // ファイルならリストに追加し呼び出し元に戻る
        } else if(isFile) {
            fileList.add(rootDir);
            System.out.println(path);
        }
    }

    /**
     * テキストファイル書き込み
     * テキストファイルへの書き込みを文字コード指定し、一度に行う
     *
     * @param str
     * @param filePath
     * @param encoding
     */
    public static void FileWrite(String str, String filePath, String encoding) {
        FileOutputStream fos = null;
        OutputStreamWriter ops = null;
        BufferedWriter bw = null;
        try {
            // テキスト書き込み準備
            fos = new FileOutputStream(filePath);
            ops = new OutputStreamWriter(fos, encoding);
            bw = new BufferedWriter(ops);

            bw.write(str.toString());

        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                bw.close();
                ops.close();
                fos.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getDosAbsolutePath() {
        String path1 = getAbsolutePath();
        return path1.replaceAll("\\.\\\\", "");
    }

    public static String getDosAbsolutePath(String path) {
        String user_dir = System.getProperty("user.dir") + "\\";
        String a_path = path.replaceAll("\\/", "\\\\");
        return a_path.replace(".\\", user_dir);
    }
}
