package lib.xlsx.bookDefine;

import lib.xlsx.innerDataDefine.SharedString;

public class Cell {
	public static final int TYPE_UNDEFINE = 0;
	public static final int TYPE_STRING = 1;
	public static final int TYPE_INTEGER = 2;

	/** Z̕ێf[^̃^Cv */
	private int cellType;
	/** f[^^Cv̏ꍇ̕ێĂl */
	private String stringValue;
	/** f[^^Cv̏ꍇ̕ێĂl */
	private Integer intValue;

	/**
	 * RXgN^
	 */
	public Cell() {
		cellType = TYPE_UNDEFINE;
		stringValue = null;
		intValue = null;
	}
	public int getCellType() {
		return cellType;
	}

	public void setString(String value) {
		stringValue = value;
		intValue = null;
		if(value == null || "".equals(value)) {
			cellType = TYPE_UNDEFINE;
			stringValue = null;
		} else {
			cellType = TYPE_STRING;
			SharedString.addText(value);
		}
	}
	public void setInteger(Integer value) {
		intValue = value;
		stringValue = String.valueOf(value);
		cellType = TYPE_INTEGER;
	}
	
	public String getString() {
		return stringValue;
	}
	public int getInteger() {
		return intValue;
	}
	
	public String toString() {
		if (cellType == TYPE_UNDEFINE) {
			return "[Empty]";
		}
		else if(cellType == TYPE_STRING) {
			return "string:\"" + stringValue + "\"";
		}
		else if(cellType == TYPE_INTEGER) {
			return "int:" + String.valueOf(intValue);
		}
		return "";
	}

}
