<?php

class Xoonips_BeanFactory {
	public static function getBean($c, $dirname = null, $trustDirname = null) {
		static $beans = array();

		if(!self::chkUserBean() && $dirname == XCUBE_CORE_USER_MODULE_NAME){
			$className = 'User_' . $c . '_NG';
			$trustDirname = $dirname;
			$require = XOOPS_TRUST_PATH . '/libs/xoonips/class/core/' . $c . 'NG.class.php';

			require_once $require;

			$beans[$className] = new $className($dirname, $trustDirname);

			return $beans[$className];

		} else {
			if (!is_null($dirname) && is_null($trustDirname)) {
				$module_handler =& xoops_gethandler('module');
				$module =& $module_handler->getByDirname($dirname);
				if (is_object($module)) {
					$dirname = strtolower($module->getVar('dirname'));
					$trustDirname = $module->getVar('trust_dirname');
				} else {
					$trustDirname = $dirname;
				}
			}
		}

		$className = ucfirst($trustDirname) . '_' . $c;
		if (!isset($beans[$className])) {
			require_once XOOPS_TRUST_PATH . "/modules/$trustDirname/class/bean/$c.class.php";
			$beans[$className] = new $className($dirname, $trustDirname);
		}
		return $beans[$className];
	}

    /**
     * chkUserBean
     *
     * @return  bool
    **/
	public function chkUserBean() {
		$bean_user = XOOPS_TRUST_PATH.'/modules/user/class/bean';
		if (is_dir($bean_user)) {
			return true;
		}
		return false;
	}

    /**
     * chkXleprogress
     *
     * @return  bool
    **/
	public function chkXleprogress() {
		$xle = 'xleprogress';
		$chk_dir = XOOPS_TRUST_PATH.'/modules/' . $xle;
		if (is_dir($chk_dir)) {
			$module_handler =& xoops_gethandler('module');
			$module =& $module_handler->getByDirname($xle);
			if (strtolower($module->getVar('dirname') == $xle)) {
				return true;
			}
		}
		return false;
	}

}
?>
