<?php

require_once 'Utils.class.php';

class Xoonips_Kana2Roma {
	/**
	 * convert Japanese Kana to Roma-ji
	 *
	 * @access public
	 * @param string $str input string
	 * @return string converted string
	 */
	public function kana2Roma($str) {
		$ret = mb_convert_kana($str, 'AKC');
		$ret = Xoonips_Utils::decodeUtf8($ret, 'ASCII', 'h');
		$kana = array(
			'&#12452;&#12455;',
			'&#12454;&#12449;', '&#12454;&#12451;', '&#12454;&#12455;', '&#12454;&#12457;',						// u
			'&#12461;&#12515;', '&#12461;&#12451;', '&#12461;&#12517;', '&#12461;&#12455;', '&#12461;&#12519;',	// ki
			'&#12463;&#12449;', '&#12463;&#12451;', '&#12463;&#12453;', '&#12463;&#12455;', '&#12463;&#12457;',	// ku
			'&#12463;&#12515;', '&#12463;&#12517;', '&#12463;&#12519;',
			'&#12462;&#12515;', '&#12462;&#12451;', '&#12462;&#12517;', '&#12462;&#12455;', '&#12462;&#12519;',	// gi
			'&#12464;&#12449;', '&#12464;&#12451;', '&#12464;&#12453;', '&#12464;&#12455;', '&#12464;&#12457;',	// gu
			'&#12471;&#12515;', '&#12471;&#12451;', '&#12471;&#12517;', '&#12471;&#12455;', '&#12471;&#12519;',	// shi
			'&#12473;&#12449;', '&#12473;&#12451;', '&#12473;&#12453;', '&#12473;&#12455;', '&#12473;&#12457;',	// su
			'&#12472;&#12515;', '&#12472;&#12451;', '&#12472;&#12517;', '&#12472;&#12455;', '&#12472;&#12519;',	// ji
			'&#12481;&#12515;', '&#12481;&#12451;', '&#12481;&#12517;', '&#12481;&#12455;', '&#12481;&#12519;',	// chi
			'&#12484;&#12449;', '&#12484;&#12451;', '&#12484;&#12455;', '&#12484;&#12457;',						// tsu
			'&#12486;&#12515;', '&#12486;&#12451;', '&#12486;&#12517;', '&#12486;&#12455;', '&#12486;&#12519;',	// te
			'&#12488;&#12449;', '&#12488;&#12451;', '&#12488;&#12453;', '&#12488;&#12455;', '&#12488;&#12457;',	// to
			'&#12482;&#12515;', '&#12482;&#12451;', '&#12482;&#12517;', '&#12482;&#12455;', '&#12482;&#12519;',	// ji
			'&#12487;&#12515;', '&#12487;&#12451;', '&#12487;&#12517;', '&#12487;&#12455;', '&#12487;&#12519;',	// de
			'&#12489;&#12449;', '&#12489;&#12451;', '&#12489;&#12453;', '&#12489;&#12455;', '&#12489;&#12457;',	// do
			'&#12491;&#12515;', '&#12491;&#12451;', '&#12491;&#12517;', '&#12491;&#12455;', '&#12491;&#12519;',	// ni
			'&#12498;&#12515;', '&#12498;&#12451;', '&#12498;&#12517;', '&#12498;&#12455;', '&#12498;&#12519;',	// hi
			'&#12501;&#12449;', '&#12501;&#12451;', '&#12501;&#12453;', '&#12501;&#12455;', '&#12501;&#12457;',	// fu
			'&#12501;&#12515;',
			'&#12499;&#12515;', '&#12499;&#12451;', '&#12499;&#12517;', '&#12499;&#12455;', '&#12499;&#12519;',	// bi
			'&#12500;&#12515;', '&#12500;&#12451;', '&#12500;&#12517;', '&#12500;&#12455;', '&#12500;&#12519;',	// pi
			'&#12511;&#12515;', '&#12511;&#12451;', '&#12511;&#12517;', '&#12511;&#12455;', '&#12511;&#12519;',	// mi
			'&#12522;&#12515;', '&#12522;&#12451;', '&#12522;&#12517;', '&#12522;&#12455;', '&#12522;&#12519;',	// ri
			'&#12450;', '&#12452;', '&#12454;', '&#12456;', '&#12458;',	// a
			'&#12459;', '&#12461;', '&#12463;', '&#12465;', '&#12467;',	// ka
			'&#12460;', '&#12462;', '&#12464;', '&#12466;', '&#12468;',	// ga
			'&#12469;', '&#12471;', '&#12473;', '&#12475;', '&#12477;',	// sa
			'&#12470;', '&#12472;', '&#12474;', '&#12476;', '&#12478;',	// za
			'&#12479;', '&#12481;', '&#12484;', '&#12486;', '&#12488;',	// ta
			'&#12480;', '&#12482;', '&#12485;', '&#12487;', '&#12489;',	// da
			'&#12490;', '&#12491;', '&#12492;', '&#12493;', '&#12494;',	// na
			'&#12495;', '&#12498;', '&#12501;', '&#12504;', '&#12507;',	// ha
			'&#12496;', '&#12499;', '&#12502;', '&#12505;', '&#12508;',	// ba
			'&#12497;', '&#12500;', '&#12503;', '&#12506;', '&#12509;',	// pa
			'&#12510;', '&#12511;', '&#12512;', '&#12513;', '&#12514;',	// ma
			'&#12516;', '&#12518;', '&#12520;',							// ya
			'&#12521;', '&#12522;', '&#12523;', '&#12524;', '&#12525;',	// ra
			'&#12527;', '&#12528;', '&#12529;', '&#12530;',				// wa
			'&#12449;', '&#12451;', '&#12453;', '&#12455;', '&#12457;',	// la
			'&#12515;', '&#12517;', '&#12519;',							// lya
			'&#12526;', '&#12533;', '&#12534;',							// lwa
			'&#12290;', '&#12289;', '&#12540;', '&#65374;', '&#8217;', '&#8221;', '&#12288;');						
		$roma = array('ye',
			'wha', 'whi', 'whe', 'who',
			'kya', 'kyi', 'kyu', 'kye', 'kyo',
			'qwa', 'qyi', 'qwu', 'qye', 'qwo', 'qya', 'qyu', 'qyo',
			'gya', 'gyi', 'gyu', 'gye', 'gyo',
			'gwa', 'gwi', 'gwu', 'gwe', 'gwo',
			'sha', 'syi', 'shu', 'she', 'sho',
			'swa', 'swi', 'swu', 'swe', 'swo',
			'ja', 'jyi', 'ju', 'je', 'jo',
			'cha', 'cyi', 'chu', 'che', 'cho',
			'tsa', 'tsi', 'tse', 'tso',
			'tha', 'thi', 'thu', 'the', 'tho',
			'twa', 'twi', 'twu', 'twe', 'two',
			'ja', 'jyi', 'ju', 'je', 'jo',
			'dha', 'dhi', 'dhu', 'dhe', 'dho',
			'dwa', 'dwi', 'dwu', 'dwe', 'dwo',
			'nya', 'nyi', 'nyu', 'nye', 'nyo',
			'hya', 'hyi', 'hyu', 'hye', 'hyo',
			'fwa', 'fyi', 'fwu', 'fye', 'fwo', 'fya',
			'bya', 'byi', 'byu', 'bye', 'byo',
			'pya', 'pyi', 'pyu', 'pye', 'pyo',
			'mya', 'myi', 'myu', 'mye', 'myo',
			'rya', 'ryi', 'ryu', 'rye', 'ryo',
			'a', 'i', 'u', 'e', 'o',
			'ka', 'ki', 'ku', 'ke', 'ko',
			'ga', 'gi', 'gu', 'ge', 'go',
			'sa', 'shi', 'su', 'se', 'so',
			'za', 'ji', 'zu', 'ze', 'zo',
			'ta', 'chi', 'tsu', 'te', 'to',
			'da', 'ji', 'zu', 'de', 'do',
			'na', 'ni', 'nu', 'ne', 'no',
			'ha', 'hi', 'fu', 'he', 'ho',
			'ba', 'bi', 'bu', 'be', 'bo',
			'pa', 'pi', 'pu', 'pe', 'po',
			'ma', 'mi', 'mu', 'me', 'mo',
			'ya', 'yu', 'yo',
			'ra', 'ri', 'ru', 're', 'ro',
			'wa', 'WI', 'WE', 'wo',
			'la', 'li', 'lu', 'le', 'lo',
			'lya', 'lyu', 'lyo',
			'lwa', 'lka', 'lke',
			'.', ',', '', '~', '"', '\'', ' ');
		$kana_hatsuon = array(
			'&#12531;a', '&#12531;i', '&#12531;u', '&#12531;e', '&#12531;o', '&#12531;y',
			'&#12531;b', '&#12531;p', '&#12531;m', '&#12531;');
		$roma_hatsuon = array(
			'n\'a', 'n\'i', 'n\'u', 'n\'e', 'n\'o', 'n\'y',
			'mb', 'mp', 'mm', 'n');
		$kana_sokuon = array(
			'&#12483;chi', '&#12483;cha', '&#12483;chu', '&#12483;cho',
			'&#12483;k', '&#12483;g', '&#12483;s', '&#12483;z', '&#12483;t',
			'&#12483;d', '&#12483;h', '&#12483;b', '&#12483;p', '&#12483;m',
			'&#12483;y', '&#12483;r', '&#12483;w', '&#12483;q', '&#12483;j',
			'&#12483;f', '&#12483;l', '&#12483;');
		$roma_sokuon = array(
			'tchi', 'tcha', 'tchu', 'tcho',
			'kk', 'gg', 'ss', 'zz', 'tt',
			'dd', 'hh', 'bb', 'pp', 'mm',
			'yy', 'rr', 'ww', 'qq', 'jj',
			'ff', 'll', 'ltsu');
		$kana_choon = array('oo', 'ou', 'o-');
		$roma_choon = array('o-', 'o-', 'o'); 
		$ret = str_replace($kana, $roma, $ret);
		$ret = str_replace($kana_hatsuon, $roma_hatsuon, $ret);
		$ret = str_replace($kana_sokuon, $roma_sokuon, $ret);
		$ret = str_replace($kana_choon, $roma_choon, $ret);

		mb_ereg_search_init($ret, '^[a-z]|. +[a-z]');
		$len = strlen($ret);
		for ($i = 0; $i < $len; $i = mb_ereg_search_getpos()) {
			mb_ereg_search_setpos($i);
			$regs = mb_ereg_search_regs();
			if ($regs === false) {
				break;
			}
			$pos = mb_ereg_search_getpos() - 1;
			$ret[$pos] = strtoupper($ret[$pos]);
		}
		$ret = mb_decode_numericentity($ret, array(0x0, 0x10000, 0, 0xfffff), 'UTF-8');
		$ret = mb_convert_kana($ret, 'a');
		return $ret;
	}
}
?>
