<?php

require_once dirname(dirname(__FILE__)) . '/Enum.class.php';

abstract class Xoonips_WorkflowBase {
	protected $notification = false;
	protected $log = false;
	protected $dirname;
	protected $trustDirname;
	
	abstract protected function doCertify($id, &$result, $comment);
	abstract protected function doRefuse($id, &$result, $comment);
	abstract protected function getDetailView($id);

	public function Xoonips_WorkflowBase($dirname, $trustDirname) {
		global $xoopsDB;
		require_once XOOPS_TRUST_PATH . '/modules/'. $trustDirname . '/class/core/Notification.class.php';
		$className = ucfirst($trustDirname) . '_Notification';	
		$this->notification = new $className($xoopsDB, $dirname, $trustDirname);
		if ($dirname != XCUBE_CORE_USER_MODULE_NAME) {
			$this->log = Xoonips_BeanFactory::getBean('EventLogBean', $dirname, $trustDirname);
		}
		$this->dirname = $dirname;
		$this->trustDirname = $trustDirname;
		Xoonips_Utils::loadMessage($this->dirname);
	}

	public function getTargetGroupId($id) {
		return null;
	}
}
?>
