<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH.'/modules/legacy/admin/class/ModuleInstaller.class.php';

/**
 * Rest_Installer
 **/
class Rest_Installer extends Legacy_ModuleInstaller {

  public function __construct() {
    parent::Legacy_ModuleInstaller();
  }
    
  function _installModule(){  
    $moduleHandler =& xoops_gethandler('module');
    if (!$moduleHandler->insert($this->_mXoopsModule)) {
      $this->mLog->addError('*Could not install module information*');
      return false;
    }

    $gpermHandler =& xoops_gethandler('groupperm');
    //
    // Add a permission which administrators can manage.
    //
    if ($this->_mXoopsModule->getInfo('hasAdmin')) {
      $adminPerm =& $this->_createPermission(XOOPS_GROUP_ADMIN);
      $adminPerm->setVar('gperm_name', 'module_admin');

      if (!$gpermHandler->insert($adminPerm)) {
        $this->mLog->addError(_AD_LEGACY_ERROR_COULD_NOT_SET_ADMIN_PERMISSION);
      }
    }

    //
    // Add a permission which administrators can manage. 
    // (Special for Legacy System Module)
    //
    if ($this->_mXoopsModule->getVar('dirname') == 'system') {
      $root =& XCube_Root::getSingleton();
      $root->mLanguageManager->loadModuleAdminMessageCatalog('system');
      require_once XOOPS_ROOT_PATH.'/modules/system/constants.php';
      $fileHandler = opendir(XOOPS_ROOT_PATH.'/modules/system/admin');
      while ($file = readdir($fileHandler)) {
        $infoFile = XOOPS_ROOT_PATH.'/modules/system/admin/'.$file.'/xoops_version.php';
        if (file_exists($infoFile)) {
          require_once $infoFile;
          if (!empty($modversion['category'])) {
            $sysAdminPerm  =& $this->_createPermission(XOOPS_GROUP_ADMIN);
            $adminPerm->setVar('gperm_itemid', $modversion['category']);
            $adminPerm->setVar('gperm_name', 'system_admin');
            if (!$gpermHandler->insert($adminPerm)) {
              $this->mLog->addError(_AD_LEGACY_ERROR_COULD_NOT_SET_SYSTEM_PERMISSION);
            }
            unset($sysAdminPerm);
          }
          unset($modversion);
        }
      }
    }

    $read_any = $this->_mXoopsModule->getInfo('read_any');
    if ($read_any) {
      $memberHandler =& xoops_gethandler('member');
      $groupObjects =& $memberHandler->getGroups();
      //
      // Add a permission all group members and guest can read.
      //
      foreach ($groupObjects as $group) {
        $readPerm =& $this->_createPermission($group->getVar('groupid'));
        $readPerm->setVar('gperm_name', 'module_read');

        if (!$gpermHandler->insert($readPerm)) {
          $this->mLog->addError(_AD_LEGACY_ERROR_COULD_NOT_SET_READ_PERMISSION);
        }
      }
    } 
  }
}
