<?php

/**
 * This is Utility Class
 * 
 */
require_once '../../mainfile.php';

/**
 * rescode => message
 * 
 * @param int $code
 * @return string Sucess:Any string Fail:null
 */
function get_code_msg($code) {
  $errarray = array(
    200 => 'OK',
    206 => 'Partial Content',
    207 => 'Multi-Status',
    304 => 'Not Modified',
    400 => 'BAD Request',
    401 => 'Unauthorized',
    403 => 'Forbidden',
    404 => 'Not Found',
    500 => 'Internal Server Error'
  );
  if (!array_key_exists($code, $errarray))
    return null;
  return $errarray[$code];
}

/**
 * Respose Code Return to browser
 * 
 * @param int $code   response code
 * @param array $addition OPTION. if you have additional header.
 * @param boolean $contxml true:Content-Type: application/xml false:
 */
function res_code($code, $addition = null, $contxml = false) {
  $msg = get_code_msg($code);
  if (is_null($msg))
    return false;
  header('HTTP/1.1 '.$code.' '.$msg);
  if ($contxml == true) {
    header('Content-Type: application/xml;charset="UTF-8"');
  }
  if (!is_null($addition)) {
    foreach ($addition as $value) {
      header($value);
    }
  } 
  return true;
}
