<?php

require_once dirname(dirname(__FILE__)) . '/class/core/User.class.php';
require_once dirname(dirname(__FILE__)) . '/class/core/ActionBase.class.php';

class User_EditUserAction extends User_ActionBase {			
	private function getBreadcrumbs(){
		return array(
			array(
					'name' => _MD_USER_LANG_USERSEARCH,
					'url' => XOOPS_URL . '/modules/user/index.php?action=userSearch'
				),
			array(
				'name' => _MD_USER_LANG_USERLIST
			),
			array(
				'name' => _MD_USER_LANG_EDITUSER
			)
		);	
	}
	/**
	 * 
	 * initialization view
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */	
	protected function doInit(&$request, &$response) {
		$user = User_User::getInstance();
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$uid = $request->getParameter('uid');
		if (is_null($uid)) {
			global $xoopsUser;
			$uid = $xoopsUser->getVar('uid');
		}
		
		if (!isset($_SESSION['xoopsUserId']) || $uid != $_SESSION['xoopsUserId']) {
			$response->setSystemError(_MD_USER_ITEM_FORBIDDEN);
			return false;
		}
		
		$viewData = array();
		//set ticket
		$token_ticket = $this->createToken('edit_user');
		$viewData['token_ticket'] = $token_ticket;
		$viewData['userEditView'] = $user->getEditView($uid);
		$viewData['uid'] = $uid;
		$viewData['xoops_breadcrumbs'] = $this->getBreadcrumbs();
		$response->setViewData($viewData);
		$response->setForward('success');
		return true;
	}
	
	/**
	 * 
	 * do edit
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doEdit(&$request, &$response) {
		$user = User_User::getInstance();
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$userType = 'user';
		$uid = $_POST['uid'];
		$errors = new Xoonips_Errors();
		$viewData = array();
		$user->setDataFromPost($_POST);
		
		//check ticket
		if (!$this->validateToken('edit_user')) {
			$response->setSystemError('Ticket error');
	        return false;
	    }
		
		$user->editCheck($errors, $uid);
		//if input error
		if (count($errors->getErrors()) != 0) {
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['userEditView'] = $user->getEditViewWithData($uid);
			$viewData['uid'] = $uid;
			$token_ticket = $this->createToken('edit_user');
			$viewData['token_ticket'] = $token_ticket;
			$response->setForward('inputError');
		} else {
			// start transaction
			$this->startTransaction();
			if (!$user->doEdit($uid)) {
				$response->setSystemError('update error!');
				return false;
			}
			$viewData['url'] = "userinfo.php?uid=$uid";
			$viewData['redirect_msg'] = _MD_USER_MSG_DBUPDATED;
			$response->setForward('edit_success');
			
		}
		$response->setViewData($viewData);
		return true;
	}
	
	/**
	 * 
	 * add item group
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doAddItemGroup(&$request, &$response) {
		$user = User_User::getInstance();
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$targetItemId = $_POST['targetItemId'];
		$user->setDataFromPost($_POST);
		$user->addItemGroup($targetItemId);
		$uid = $_POST['uid'];
		$viewData = array();
		$viewData['userEditView'] = $user->getEditViewWithData($uid);
		$viewData['uid'] = $uid;
		$token_ticket = $this->createToken('edit_user');
		$viewData['token_ticket'] = $token_ticket;
		$viewData['xoops_breadcrumbs'] = $this->getBreadcrumbs();
		$response->setViewData($viewData);
		$response->setForward('success');
		return true;
	}

	/**
	 * 
	 * delete item group
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doDelItemGroup(&$request, &$response) {
		$user = User_User::getInstance();
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$targetItemId = $_POST['targetItemId'];
		$user->setDataFromPost($_POST);
		$user->delItemGroup($targetItemId);
		$uid = $_POST['uid'];
		$viewData = array();
		$viewData['userEditView'] = $user->getEditViewWithData($uid);
		$viewData['uid'] = $uid;
		$token_ticket = $this->createToken('edit_user');
		$viewData['token_ticket'] = $token_ticket;
		$viewData['xoops_breadcrumbs'] = $this->getBreadcrumbs();

		$response->setViewData($viewData);
		$response->setForward('success');
		return true;
	}
}
?>
