<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . "/class/AbstractEditAction.class.php";
require_once USER_TRUST_PATH . "/admin/forms/UserAdminEditForm.class.php";
require_once USER_TRUST_PATH . "/class/core/User.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/Errors.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/Utils.class.php";
require_once XOOPS_ROOT_PATH . '/class/token.php';

class User_UserEditAction extends User_AbstractEditAction
{
	function _getId()
	{
		return xoops_getrequest('uid');
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm = new User_UserAdminEditForm();
		$this->mActionForm->prepare();
	}

	function _setupObject()
	{
		
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		Xoonips_Utils::loadMessage(XCUBE_CORE_USER_MODULE_NAME);
		$user = User_User::getInstance();
		$user->setId($this->_getId());
		$displayView = '';
		$uid = '';
		if (!isset($_GET['uid'])){
			$displayView = $user->getRegistryViewForModerator();
			$token_ticket = $this->createToken('user_register');
		}else{
			$uid = $_GET['uid'];
			$displayView = $user->getEditViewForModerator($uid);
			$token_ticket = $this->createToken('user_edit');
			$render->setAttribute('uid', $uid);
		}
		$render->setTemplateName($this->dirname . '_edit.html');
		$render->setAttribute('displayView', $displayView);
		$render->setAttribute('dirname', $this->dirname);
		//set ticket
		$render->setAttribute('ticket', $token_ticket);
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{	
		return USER_FRAME_VIEW_INPUT;
	}

	function execute(&$controller, &$xoopsUser)
	{	
		if (xoops_getrequest('_form_control_cancel') != null) {
			return USER_FRAME_VIEW_CANCEL;
		}		
		$user = User_User::getInstance();
		$user->setId($this->_getId());
		$errors = new Xoonips_Errors();
		$render = $controller->mRoot->mContext->mModule->getRenderTarget();
		$user->setDataFromPost($_POST);		
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		$certify_user = $myxoopsConfigUser['certify_user'] ;
		$is_certify_auto = ($certify_user == 'auto');
		// regisrty
		if (!isset($_POST['uid'])){
			if (!$this->validateToken('user_register')) {
		        return USER_FRAME_VIEW_ERROR;
		    }
			$token_ticket = $this->createToken('user_register');
			// add or delete occurrence
			if (isset($_GET['op'])){
				$targetItemId = $_POST['targetItemId'];
				if ($_GET['op'] == 'addItemGroup' && !empty($targetItemId)){
					$user->addItemGroup($targetItemId);
					$this->setErrorRender($render, $user, null, null, $token_ticket, true);
					return USER_FRAME_VIEW_SUCCESS;
				}
				if ($_GET['op'] == 'delItemGroup' && !empty($targetItemId)){
					$user->delItemGroup($targetItemId);
					$this->setErrorRender($render, $user, null, null, $token_ticket, true);
					return USER_FRAME_VIEW_SUCCESS;
				}
			}
			// do registry
			$user->inputCheck($errors);
			// input error
			if (count($errors->getErrors()) != 0){
				$this->setErrorRender($render, $user, $errors, null, $token_ticket, true);
				return USER_FRAME_VIEW_SUCCESS;
			}
			
			$errorMsg = '';
		    if ($user->doRegistryForModerator($errorMsg)) {
		    	if ($errorMsg != '') {
		    		$render->setAttribute('errorMsg', $errorMsg);
		    		return USER_FRAME_VIEW_ERROR;
		    	}
		    	$render->setAttribute('edit', true);
		    	return USER_FRAME_VIEW_SUCCESS;
		    // registry failed
		    } else {
				return USER_FRAME_VIEW_ERROR;
		    }
		    
		}
		// edit
		if (isset($_POST['uid'])){
			$uid = $_POST['uid'];
			if ( ! $this->validateToken( 'user_edit' ) ) {
		        return USER_FRAME_VIEW_ERROR;
		    }
			$token_ticket = $this->createToken('user_edit');
			// add or delete occurrence
			if (isset($_GET['op'])){
				$targetItemId = $_POST['targetItemId'];
				if ($_GET['op'] == 'addItemGroup' && !empty($targetItemId)){
					$user->addItemGroup($targetItemId);
					$this->setErrorRender($render, $user, null, $uid, $token_ticket, false);
					return USER_FRAME_VIEW_SUCCESS;
				}
				if ($_GET['op'] == 'delItemGroup' && !empty($targetItemId)){
					$targetItemId = $_POST['targetItemId'];
					if (empty($targetItemId)){
						return USER_FRAME_VIEW_ERROR;
					}
					$user->delItemGroup($targetItemId);
					$this->setErrorRender($render, $user, null, $uid, $token_ticket, false);
					return USER_FRAME_VIEW_SUCCESS;
				}
			}
			// do edit
			$user->editCheck($errors, $uid);
			// input error
			if (count($errors->getErrors()) != 0){
				$this->setErrorRender($render, $user, $errors, $uid, $token_ticket, false);
				return USER_FRAME_VIEW_SUCCESS;
			}
			if ($user->doEditForModerator($errors, $uid)){
				if (count($errors->getErrors()) != 0){
					$this->setErrorRender($render, $user, $errors, $uid, $token_ticket, false);
					return USER_FRAME_VIEW_SUCCESS;
				}
		    	$render->setAttribute('edit', true);
		    	return USER_FRAME_VIEW_SUCCESS;
		    }else{
				return USER_FRAME_VIEW_ERROR;
		    }
			
		}
	}

	function setErrorRender(&$render, $user, $errors, $uid, $token_ticket, $isRegistry) {
		if ($isRegistry) {
			$displayView = $user->getRegistryViewWithDataForModerator();
		} else {
			$displayView = $user->getEditViewWithDataForModerator();
		}
		$render->setTemplateName($this->dirname . '_edit.html');
		$render->setAttribute('displayView', $displayView);
		if (!is_null($errors)) {
			$render->setAttribute('error', $errors->getView($this->dirname));
		}
		$render->setAttribute('uid', $uid);
		$render->setAttribute('ticket', $token_ticket);
		$render->setAttribute('dirname', $this->dirname);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		if ($render->getAttribute('edit')){
			$controller->executeForward('./index.php?action=UserList');
		}
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		if (!$render->getAttribute('errorMsg')){
			$controller->executeRedirect('index.php', 1, _MD_USER_ERROR_DBUPDATE_FAILED);
		}else{
			$controller->executeRedirect('index.php', 1, $render->getAttribute('errorMsg'));
		}
		
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward('./index.php?action=UserList');
	}
	
    function createToken($name)
    {         
        $token =& XoopsMultiTokenHandler::quickCreate($name);
        return $token->getHtml();
    }
    
    function validateToken($name)
    {       
        return XoopsMultiTokenHandler::quickValidate($name);        
    }
}
?>
