<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . "/class/AbstractViewAction.class.php";
require_once USER_TRUST_PATH . "/admin/forms/UserRecountForm.class.php";
require_once USER_TRUST_PATH . "/class/core/User.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/BeanFactory.class.php";
require_once XOOPS_ROOT_PATH . '/class/token.php';

class User_UserViewAction extends User_AbstractViewAction
{
	var $mActionForm = null;

	/**
	 * @var XCube_Delegate
	 */
	var $mGetUserPosts = null;
	
	function User_UserViewAction()
	{
		parent::User_AbstractViewAction();
		$this->mGetUserPosts = new XCube_Delegate();
		$this->mGetUserPosts->register('User_UserViewAction.GetUserPosts');
	}
	
	function prepare(&$controller, &$xoopsUser, $moduleConfig)
	{
		parent::prepare($controller, $xoopsUser, $moduleConfig);
		$this->mActionForm = new User_RecountForm();
		$this->mActionForm->prepare();
	}
	
	function _getId()
	{
		return xoops_getrequest('uid');
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users');
		return $handler;
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		if (is_object($this->mObject)) {
			$this->mActionForm->load($this->mObject);
		}
		
		$ret = parent::getDefaultView($controller, $xoopsUser);
		
		//
		// Because this class implemented 'execute()', convet the status here.
		//
		if ($ret == USER_FRAME_VIEW_SUCCESS) {
			return USER_FRAME_VIEW_INDEX;
		}
		else {
			return $ret;
		}
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		if ($this->mObject == null) {
			return USER_FRAME_VIEW_ERROR;
		}
		
		if (!$this->validateToken('user_view')) {
		        return USER_FRAME_VIEW_ERROR;
		}
		    
		// Do 'recount'
		$posts = 0;
		$this->mGetUserPosts->call(new XCube_Ref($posts), $this->mObject);
		XCube_DelegateUtils::call('Module.User.GetUserPosts', new XCube_Ref($posts), $this->mObject);
		$this->mObject->set('posts', $posts);
				
		$handler =& xoops_getmodulehandler('users');
		return $handler->insert($this->mObject) ? USER_FRAME_VIEW_SUCCESS
		                                        : USER_FRAME_VIEW_ERROR;
	}
	
	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$user = User_User::getInstance();
		$user->setId($this->_getId());		
		$token_ticket = $this->createToken('user_view');
		$render->setTemplateName($this->dirname . '_view.html');
		$render->setAttribute('userView', $user->getDetailViewForModerator($this->_getId()));
		$render->setAttribute('object', $this->mObject);
		$render->setAttribute('uid', $this->_getId());
		$render->setAttribute('dirname', $this->dirname);
		//set ticket
		$render->setAttribute('ticket', $token_ticket);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=UserView&uid=" . $this->mObject->get('uid'), 1, _AD_USER_MESSAGE_RECOUNT_SUCCESS);
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=UserList", 1, _AD_USER_ERROR_CONTENT_IS_NOT_FOUND);
	}
	
    function createToken($name)
    {         
        $token =& XoopsMultiTokenHandler::quickCreate($name);
        return $token->getHtml();
    }
    
    function validateToken($name)
    {       
        return XoopsMultiTokenHandler::quickValidate($name);        
    }
}

?>
