<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

/**
 * @brief operate user_field_group table
 *
 */
class User_FieldGroupBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function User_FieldGroupBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('field_group', true);

		$this->grouplinktable = $this->prefix($this->modulePrefix('field_group_field_detail_link'));
	}

	/**
	 * insert new user field group
	 *
	 * @param  $info: user field group info
	 * @return boolean  true:success,false:failed
	 */
	public function insert($info, &$insertId) {
		$sql = "INSERT INTO $this->table (released, preselect, name, xml, weight, occurrence, update_id)";
		$sql .= ' VALUES (' . Xoonips_Utils::convertSQLNum($info['released']) . ','
			. Xoonips_Utils::convertSQLNum($info['preselect']) . ','
			. Xoonips_Utils::convertSQLStr($info['name']) . ','
			. Xoonips_Utils::convertSQLStr($info['xml']) . ','
			. Xoonips_Utils::convertSQLNum($info['weight']) . ','
			. Xoonips_Utils::convertSQLNum($info['occurrence']) . ','
			. Xoonips_Utils::convertSQLNum($info['update_id']). ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$insertId = $this->getInsertId();
		return true;
	}

	/**
	 * do copy by obj
	 *
	 * @param  $groupObj, $map
	 * @return boolean true:success,false:failed
	 */
	public function copyByObj($groupObj, &$map, $update, $import) {

		// insert copy
		foreach ($groupObj as $group) {

			$group['released'] = $import ? $group['released'] : 0;
			$group['update_id'] = $update ? $group['group_id'] : NULL;

			$insertId = null;
			if (!$this->insert($group, $insertId)) return false;

			$map['group'][$group['group_id']] = $insertId;
		}
		return true;
	}

	/**
	 * insert group link
	 *
	 * @param  $info: default detail info
	 * @return boolean  true:success,false:failed
	 */
	public function insertLink($info, &$insertId) {
		$sql = "INSERT INTO $this->grouplinktable (group_id, user_detail_id, weight, edit, edit_weight, released)"
			. ' VALUES (' . Xoonips_Utils::convertSQLNum($info['group_id']) . ','
			. Xoonips_Utils::convertSQLNum($info['user_detail_id']) . ','
			. Xoonips_Utils::convertSQLNum($info['weight']) . ','
			. Xoonips_Utils::convertSQLNum($info['edit']) . ','
			. Xoonips_Utils::convertSQLNum($info['edit_weight']) . ','
			. Xoonips_Utils::convertSQLNum($info['released']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$insertId = $this->getInsertId();
		return true;
	}

	/**
	 *
	 * get group detail by id
	 *
	 * @param int groupId, int detailId
	 * @return  array ret
	 */
	public function getGroupDetailById($groupId, $detailId) {
		$ret = array();
		$sql = 'SELECT * FROM ' . $this->grouplinktable
		. " WHERE group_id=$groupId AND user_detail_id=$detailId";
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret = $row;
		}
		return $ret;
	}

}
?>
