<?php

require_once XOOPS_TRUST_PATH .'/libs/xoonips/class/core/FieldGroup.class.php';
require_once 'UserField.class.php';
require_once XOOPS_TRUST_PATH .'/libs/xoonips/class/core/ViewTypeFactory.class.php';
require_once XOOPS_TRUST_PATH .'/libs/xoonips/class/core/DataTypeFactory.class.php';

class User_UserFieldManager {
	private $fieldGroups = array();
	private $newFieldGroups = array();
	private $fields = array();
	private $newFields = array();
	private $dirname;
	private $trustDirname;
 	private $xoopsTpl;

    private static $display_instance;
    private static $nondisplay_instance;

    private function User_UserFieldManager($nondisplay) {
    	global $xoopsModule;
		$this->dirname = XCUBE_CORE_USER_MODULE_NAME;
		$module_handler = & xoops_gethandler('module');
		$module = & $module_handler->getByDirname($this->dirname);
		if (is_object($module)) {
			$this->trustDirname = $module->getVar('trust_dirname');
		} else {
			require XOOPS_ROOT_PATH . '/modules/' . $this->dirname . '/mytrustdirname.php';
			$this->trustDirname = $mytrustdirname;
		}
		global $xoopsTpl;
		$this->xoopsTpl = $xoopsTpl;
		$this->loadFieldGroups();
		$this->loadFields($nondisplay);
	}

	public static function getInstance($nondisplay = false) {
		if (!$nondisplay) {
			if (!isset(self::$display_instance)) {
				$c = __CLASS__;
				self::$display_instance = new $c($nondisplay);
			}
			return self::$display_instance;
		} else {
			if (!isset(self::$nondisplay_instance)) {
				$c = __CLASS__;
				self::$nondisplay_instance = new $c($nondisplay);
			}
			return self::$nondisplay_instance;
		}
	}

	public function getDirname() {
		return $this->dirname;
	}

	public function getTrustDirname() {
		return $this->trustDirname;
	}

	public function getXoopsTpl() {
		return $this->xoopsTpl;
	}

	public function setFieldGroups($fieldGroups) {
		$this->fieldGroups = $fieldGroups;
	}

	public function loadFieldGroups() {
		global $xoopsDB;

		$sql = 'select * from ' . $xoopsDB->prefix('user_field_group') .
		' where released=1 order by weight, group_id';

		$sqlResult = $xoopsDB->query($sql);

		while ($row = $xoopsDB->fetchArray($sqlResult)) {
			$fieldGroup = new Xoonips_FieldGroup($row['group_id']);
			$fieldGroup->setName($row['name']);
			$fieldGroup->setXmlTag($row['xml']);
			if ($row['occurrence'] == 1) {
				$fieldGroup->setOccurrence(true);
			} else {
				$fieldGroup->setOccurrence(false);
			}
			$fieldGroup->setDirname($this->dirname);
			$fieldGroup->setTrustDirname($this->trustDirname);
			$fieldGroup->setXoopsTpl($this->xoopsTpl);
			$fieldGroup->setTemplate();
			$this->fieldGroups[$row['group_id']] = $fieldGroup;
		}
	}

	public function loadFields($nondisplay) {

		global $xoopsDB;

		$sql = 'select l.group_id,'
		. 'd.user_detail_id, d.preselect, d.released, d.table_name, d.column_name,'
		. 'd.weight, d.name, d.xml, d.view_type_id, d.data_type_id, d.data_length,'
		. 'd.data_decimal_places, d.default_value, d.list, d.essential, d.list_display,'
		. 'd.list_sort_key, d.list_width, d.detail_display, d.registry_user, d.edit_user,'
		. 'd.target_user, d.scope_search, d.nondisplay, d.update_id'
		. ' from ' . $xoopsDB->prefix($this->dirname . '_field_detail') . ' as d'
		. ' left join ' . $xoopsDB->prefix($this->dirname . '_field_group_field_detail_link')
		. ' as l on d.user_detail_id=l.user_detail_id'
		. ' where d.released=1';
		if (!$nondisplay) {
			$sql .= ' and d.nondisplay=0 order by l.group_id,l.weight';
		} else {
			$sql .= ' order by l.group_id,l.weight';
		}

		$sqlResult = $xoopsDB->query($sql);
		$fieldGroupFlg = false;
		$fieldGroupId = '';
		$fieldsKey = 0;

		while ($row = $xoopsDB->fetchArray($sqlResult)) {
			$id = $row['user_detail_id'];
			$name = $row['name'];
			$groupId = $row['group_id'];
			$xmlTag = $row['xml'];
			$tableName = $row['table_name'];
			$columnName = $row['column_name'];
			$scopeSearch = $row['scope_search'];
			$viewType = Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType($row['view_type_id']);
			$dataType = Xoonips_DataTypeFactory::getInstance($this->dirname, $this->trustDirname)->getDataType($row['data_type_id']);
			$len = $row['data_length'];
			$default = $row['default_value'];
			$essential = $row['essential'];
			$list = $row['list'];
			$listDisplay = $row['list_display'];
			$listSortKey = $row['list_sort_key'];
			$listWidth = $row['list_width'];
			$detailDisplay = $row['detail_display'];
			$registryUser = $row['registry_user'];
			$editUser = $row['edit_user'];
			$targetUser = $row['target_user'];
			$field = new User_UserField();
			$field->setId($id);
			$field->setName($name);
			$field->setFieldGroupId($groupId);
			if ($field->getFieldGroupId() == $fieldGroupId){
				$fieldGroupFlg = true;
			}else{
				$fieldGroupFlg = false;
			}
			if (!$fieldGroupFlg){
				$fields = array();
				$fieldsKey = 1;
			}
			$fieldGroupId = $groupId;
			$field->setXmlTag($xmlTag);
			$field->setTableName($tableName);
			$field->setColumnName($columnName);
			$field->setScopeSearch($scopeSearch);
			$field->setViewType($viewType);
			$field->setDataType($dataType);
			$field->setLen($len);
			$field->setDefault($default);
			$field->setEssential($essential);
			$field->setListId($list);
			$field->setListDisplay($listDisplay);
			$field->setListSortKey($listSortKey);
			$field->setListWidth($listWidth);
			$field->setDetailDisplay($detailDisplay);
			$field->setRegistry($registryUser);
			$field->setEdit($editUser);
			$field->setSearch($targetUser);
			$field->setDirname($this->dirname);
			$field->setTrustDirname($this->trustDirname);
			$field->setXoopsTpl($this->xoopsTpl);
			$field->setTemplate();
			$fields[$fieldsKey] = $field;
			$this->fields[$id] = $field;

			if ($groupId > 0) {
				$this->fieldGroups[$groupId]->setFields($fields);
			}

			$fieldsKey++;
		}
	}

	public function getFields() {
		return $this->fields;
	}

	public function getFieldGroups() {
		return $this->fieldGroups;
	}

	public function getField($id) {
		return $this->fields[$id];
	}

	public function getFieldGroup($fieldGroupId) {
		return $this->fieldGroups[$fieldGroupId];
	}

	public function setNewFieldGroups($fieldGroups) {
		$this->newFieldGroups = $fieldGroups;
	}

	public function getNewFieldGroups() {
		return $this->newFieldGroups;
	}

	public function save($fieldGroups) {
		$this->updateNewFieldGroups($fieldGroups);
		$this->newFieldGroups = $fieldGroups;
	}

	public function release($fieldGroups) {
		$this->updateFieldGroups($fieldGroups);
		$this->deleteNewFieldGroups();
		$this->newFieldGroups = NULL;
	}

	private function deleteNewFieldGroups() {
	}

	private function updateFieldGroups($fieldGroups) {
	}

	private function updateNewFieldGroups($fieldGroups) {
	}
}
?>
