<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewType.class.php';

class User_ViewTypeLevel extends Xoonips_ViewType {

	public function setTemplate() {
		$this->template = $this->dirname . '_viewtype_level.html';
	}

	public function getInputView($field, $value, $groupLoopId) {
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		$certifyUser = $myxoopsConfigUser['certify_user'];
   		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'input');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('certifyUser', $certifyUser);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getEditView($field, $value, $groupLoopId) {
		$user = User_User::getInstance();
		$uid = $user->getId();
		$userBean = Xoonips_BeanFactory::getBean('UsersBean',$this->dirname,$this->trustDirname);
		$row = $userBean->getUserBasicInfo($uid);
		$activate = $row['activate'];
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'edit');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('list', $this->getLevelList());
		$this->getXoopsTpl()->assign('activate', $activate);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getEditViewWithDataForModerator($field, $value, $groupLoopId) {
		return $this->getEditView($field, $value, $groupLoopId);
	}
	
	public function getSearchInputView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'search');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('list', $this->getLevelList());
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getDisplayView($field, $value, $groupLoopId) {
	}
	
	public function getDetailDisplayView($field, $value, $display) {
		$user = User_User::getInstance();
		$uid = $user->getId();
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$row = $userBean->getUserBasicInfo($uid);
		$activate = $row['activate'];
		$this->getXoopsTpl()->assign('viewType', 'detail');
		$this->getXoopsTpl()->assign('value', $value);
		$this->getXoopsTpl()->assign('list', $this->getLevelList());
		$this->getXoopsTpl()->assign('activate', $activate);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	private function getLevelList() {
		$ret = array();		
		$ret[0] = _AD_USER_LANG_LEVEL_INACTIVE;
		$ret[1] = _AD_USER_LANG_LEVEL_PENDING;
		$ret[2] = _AD_USER_LANG_LEVEL_ACTIVE;
		$ret[5] = _AD_USER_LANG_LEVEL_ROOT;		
		return $ret;
	}
	
	public function doEdit($field, &$data, &$sqlStrings, $groupLoopId) {
		return true;
	}
	
	public function doSearch($field, &$data, &$sqlStrings, $groupLoopId, $scopeSearchFlg, $isExact) {
		$tableName = $field->getTableName();
		$columnName = $field->getColumnName();
		$value = $data[$this->getFieldName($field, $groupLoopId)];
		
	    if (isset($sqlStrings[$tableName])) {
			$tableData = &$sqlStrings[$tableName];
		} else {
			$tableData = array();
			$sqlStrings[$tableName] = &$tableData;
		}
		if ($value != '') {
			$value = trim($value);
			$tableData[] = 'level=' . $value;
		}
	}
	
	public function isDisplay($op) {
		if ($op == Xoonips_Enum::OP_TYPE_REGISTRY || $op == Xoonips_Enum::OP_TYPE_MANAGER_REGISTRY || $op == Xoonips_Enum::OP_TYPE_EDIT) {
			return false;
		}
		return true;
	}
}
?>
