<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewType.class.php';

define('XOOPS_DHTMLTAREA_DEFID_PREFIX', 'legacy_xoopsform_');
define('XOOPS_DHTMLTAREA_DEFAULT_COLS', '50');
define('XOOPS_DHTMLTAREA_DEFAULT_ROWS', '5');

class User_ViewTypeSignature extends Xoonips_ViewType {

	public function setTemplate() {
		$this->template = $this->dirname . '_viewtype_signature.html';
	}

	public function getInputView($field, $value, $groupLoopId) {
		$ret = '';
		if (!class_exists('xoopsformelement')) {
			require_once XOOPS_ROOT_PATH . '/class/xoopsformloader.php';
		}
		$form = null;
		$params['name'] = $this->getFieldName($field, $groupLoopId);
		$params['value'] = $value;
	    $root =& XCube_Root::getSingleton();
	    $textFilter =& $root->getTextFilter();
		if (isset($params['name'])) {

			// Fetch major elements from $params.
			$name = trim($params['name']);
			$class = isset($params['class']) ? trim($params['class']) : null;
			$cols = isset($params['cols']) ? intval($params['cols']) : XOOPS_DHTMLTAREA_DEFAULT_COLS;
			$rows = isset($params['rows']) ? intval($params['rows']) : XOOPS_DHTMLTAREA_DEFAULT_ROWS;
			$value = isset($params['value']) ? $textFilter->toEdit(trim($params['value'])) : null;
			$id = isset($params['id']) ? trim($params['id']) : XOOPS_DHTMLTAREA_DEFID_PREFIX . 'xoops';
	
			// Build the object for output.
			$form = new XoopsFormDhtmlTextArea($name, $name, $value, $rows, $cols);
			$form->setId($id);
			if ($class != null) {
				$form->setClass($class);
			}
			$ret = $form->render();
		}
    	
   		return $ret;
	}
	
	public function getDisplayView($field, $value, $groupLoopId) {
		$ret = '';
		$ts =& MyTextSanitizer::getInstance();
        $ret = $ts->_ToShowTarea($value);	
  		$fieldName = $this->getFieldName($field, $groupLoopId);
   		$this->getXoopsTpl()->assign('viewType', 'confirm');
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('showValue', $ret);
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getDetailDisplayView($field, $value, $display) {
		$ret = '';
		$ts =& MyTextSanitizer::getInstance();
        $ret = $ts->_ToShowTarea($value);
   		$this->getXoopsTpl()->assign('viewType', 'detail');
		$this->getXoopsTpl()->assign('showValue', $ret);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	public function isDisplayFieldName() {
		return false;
	}
}
