<?php

if (!defined('XOOPS_ROOT_PATH')) exit();
 
/***
 * @internal
 * This is static functions collection class for legacy pages access.
 */
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Request.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Response.class.php';

class User_LegacypageFunctions
{
	/***
	 * @internal
	 * The process for userinfo.php. This process doesn't execute anything
	 * directly. Forward to the controller of the user module.
	 */
	function userinfo()
	{
		//
		// Boot the action frame of the user module directly.
		//
		$root =& XCube_Root::getSingleton();
		$root->mController->executeHeader();
		
		$root->mController->setupModuleContext(XCUBE_CORE_USER_MODULE_NAME);
		$root->mLanguageManager->loadModuleMessageCatalog(XCUBE_CORE_USER_MODULE_NAME);
		
		require_once USER_TRUST_PATH . "/class/ActionFrame.class.php";

		$moduleRunner = new User_ActionFrame(false);
		$moduleRunner->setActionName("UserInfo");

		$root->mController->mExecute->add(array(&$moduleRunner, 'execute'));

		$root->mController->execute();
		
		$root->mController->executeView();
	}
	
	/***
	 * @internal
	 * The process for edituser.php. This process doesn't execute anything
	 * directly. Forward to the controller of the user module.
	 */
	function edituser()
	{		
		$root =& XCube_Root::getSingleton();		
		$root->mController->setupModuleContext(XCUBE_CORE_USER_MODULE_NAME);
		$root->mLanguageManager->loadModuleMessageCatalog(XCUBE_CORE_USER_MODULE_NAME);
		//Xoonips_Utils::denyGuestAccess();
		$actionMap = array();
		$request = new Xoonips_Request();
		$response = new Xoonips_Response();
		$op = $request->getParameter('op');
		if ($op == null) {
			$op = 'init';
		}		
		// check request
		if (!in_array($op, array('init', 'edit', 'addItemGroup', 'delItemGroup'))) {
		    die('illegal reuest');
		}		
		// set action map
		$actionMap = array();
		$actionMap['edit_success'] = 'redirect_header';
		$actionMap['success'] = 'user_edituser.html';
		$actionMap['inputError'] = 'user_edituser.html';
		
		include XOOPS_ROOT_PATH . '/header.php';
		require_once USER_TRUST_PATH . '/actions/EditUserAction.class.php';
		//do action
		$action = new User_EditUserAction(XCUBE_CORE_USER_MODULE_NAME);
		$action->doAction($request, $response);
		// forward
		$response->forward($actionMap);		
		include XOOPS_ROOT_PATH . '/footer.php';
	}
	
	/***
	 * @internal
	 * The process for register.php. This process doesn't execute anything
	 * directly. Forward to the controller of the user module.
	 */
	function register()
	{		
		$root =& XCube_Root::getSingleton();		
		$root->mController->setupModuleContext(XCUBE_CORE_USER_MODULE_NAME);
		$root->mLanguageManager->loadModuleMessageCatalog(XCUBE_CORE_USER_MODULE_NAME);
		global $xoopsUser;
		if (is_object($xoopsUser)) {
			// if user already logged in then redirect to top page
			header('Location: ' . XOOPS_URL . '/');
			exit();
		}
		
		$request = new Xoonips_Request();
		$response = new Xoonips_Response();
		$op = $request->getParameter('op');
		if ($op == null) {
			$op = 'init';
		}
		
		// check request
		if (!in_array($op, array('init', 'registry', 'addItemGroup', 'delItemGroup', 'confirm', 'cancel'))) {
			die('illegal reuest');
		}
		
		// set action map
		$actionMap = array();
		$actionMap['registry_success'] = 'user_register_finish.html';
		$actionMap['success'] = 'user_register_form.html';
		$actionMap['inputError'] = 'user_register_form.html';
		
		include XOOPS_ROOT_PATH . '/header.php';
		require_once USER_TRUST_PATH . '/actions/UserRegisterAction.class.php';
		// do action
		$action = new User_UserRegisterAction(XCUBE_CORE_USER_MODULE_NAME);
		$action->doAction($request, $response);
		// forward
		$response->forward($actionMap);
		
		include XOOPS_ROOT_PATH . '/footer.php';		
	}
	
	/***
	 * @internal
	 * The process for lostpass.php. This process doesn't execute anything
	 * directly. If the current user is registered user, kick out to the top
	 * page. Else, forward to the lost-pass page.
	 */
	function lostpass()
	{
		$root =& XCube_Root::getSingleton();
		$xoopsUser =& $root->mContext->mXoopsUser;

		if (is_object($xoopsUser)) {
			$root->mController->executeForward(XOOPS_URL);
		}
		
		//
		// Boot the action frame of the user module directly.
		//
		$root->mController->executeHeader();

		$root->mController->setupModuleContext(XCUBE_CORE_USER_MODULE_NAME);
		$root->mLanguageManager->loadModuleMessageCatalog(XCUBE_CORE_USER_MODULE_NAME);
				
		require_once USER_TRUST_PATH . "/class/ActionFrame.class.php";

		$root =& XCube_Root::getSingleton();

		$moduleRunner = new User_ActionFrame(false);
		$moduleRunner->setActionName("LostPass");

		$root->mController->mExecute->add(array(&$moduleRunner, 'execute'));

		$root->mController->execute();
		
		$root->mController->executeView();
	}

	/***
	 * @internal
	 * The process for user.php. This process doesn't execute anything directly.
	 * Forward to the controller of the user module.
	 */
	function user()
	{
		$root =& XCube_Root::getSingleton();
		$op = isset($_REQUEST['op']) ? trim(xoops_getrequest('op')) : "main";
		$xoopsUser =& $root->mContext->mXoopsUser;
		
		$actionName = "default";
		
		switch($op) {
			case "login":
				$root->mController->checkLogin();
				return;
			
			case "logout":
				$root->mController->logout();
				return;
				
			case "main":
				if (is_object($xoopsUser)) {
					$root->mController->executeForward(XOOPS_URL . "/userinfo.php?uid=" . $xoopsUser->get('uid'));
				}
				break;
				
			case "actv":
				$actionName = "UserActivate";
				break;
				
			case "delete":
				$actionName = "UserDelete";
				break;
		}
		
		//
		// Boot the action frame of the user module directly.
		//
		$root =& XCube_Root::getSingleton();
		$root->mController->executeHeader();
		
		$root->mController->setupModuleContext(XCUBE_CORE_USER_MODULE_NAME);
		$root->mLanguageManager->loadModuleMessageCatalog(XCUBE_CORE_USER_MODULE_NAME);
		
		require_once USER_TRUST_PATH . "/class/ActionFrame.class.php";

		$moduleRunner = new User_ActionFrame(false);
		$moduleRunner->setActionName($actionName);

		$root->mController->mExecute->add(array(&$moduleRunner, 'execute'));

		$root->mController->execute();
		
		$root->mController->executeView();
	}
	
	function checkLogin(&$xoopsUser)
	{
		if (is_object($xoopsUser)) {
			return;
		}

		$root =& XCube_Root::getSingleton();
		$root->mLanguageManager->loadModuleMessageCatalog(XCUBE_CORE_USER_MODULE_NAME);

		$userHandler =& xoops_getmodulehandler('users', XCUBE_CORE_USER_MODULE_NAME);
		
		$criteria = new CriteriaCompo();
		$criteria->add(new Criteria('uname', xoops_getrequest('uname')));
		$criteria->add(new Criteria('pass', md5(xoops_getrequest('pass'))));
		
		$userArr =& $userHandler->getObjects($criteria);
		
		if (count($userArr) != 1) {
			return;
		}

		if (!defined('USER_TRUST_PATH')) {
			require XOOPS_ROOT_PATH . '/modules/' . XCUBE_CORE_USER_MODULE_NAME . '/mytrustdirname.php';
			define('USER_TRUST_PATH', XOOPS_TRUST_PATH . '/modules/' . $mytrustdirname);
		}
		require_once USER_TRUST_PATH . '/class/core/User.class.php';

		$user = User_User::getInstance();
		$xoopsUser = $user->checkLoginImpl($userArr[0]->get('uid'), true);
		if (!$xoopsUser) {
			return;
		}
	
		//
		// Regist to session
		//
		$root->mSession->regenerate();
		$_SESSION = array();
		$_SESSION['xoopsUserId'] = $xoopsUser->get('uid');
		$_SESSION['xoopsUserGroups'] = $xoopsUser->getGroups();
	}
	
    function checkLoginSuccess(&$xoopsUser)
    {
		if (is_object($xoopsUser)) {			
			XCube_DelegateUtils::call("Module.User.Evnet.User.Login.Success",$xoopsUser);
			$handler =& xoops_gethandler('user');			
			$xoopsUser->set('last_login', time());			
			$handler->insert($xoopsUser);
		}
	}
	
	function checkLoginFail(&$xoopsUser)
    {					
		XCube_DelegateUtils::call("Module.User.Evnet.User.Login.Fail",xoops_getrequest('uname'));
		redirect_header(XOOPS_URL . '/', 1, _MD_LEGACY_ERROR_INCORRECTLOGIN);
	}

	function logout(&$successFlag, $xoopsUser)
	{
		if (isset($_SESSION['xoonips_old_uid'])) {
			header('Location:' . XOOPS_URL . '/modules/' . XCUBE_CORE_USER_MODULE_NAME . '/index.php?action=userSu&op=end');
			exit();
		}
		$root =& XCube_Root::getSingleton();
		$xoopsConfig = $root->mContext->mXoopsConfig;
		
		$root->mLanguageManager->loadModuleMessageCatalog(XCUBE_CORE_USER_MODULE_NAME);
		
		// Reset session
		$_SESSION = array();
		$root->mSession->destroy(true);

		// clear entry from online users table
		if (is_object($xoopsUser)) {
			$onlineHandler =& xoops_gethandler('online');
			$onlineHandler->destroy($xoopsUser->get('uid'));
		}
		XCube_DelegateUtils::call("Module.User.Evnet.User.Logout.Success",$xoopsUser);
		$successFlag = true;
    }
	
	function misc()
	{
		if (xoops_getrequest('type') != 'online') {
			return;
		}
		
		require_once USER_TRUST_PATH . "/class/ActionFrame.class.php";

		$root =& XCube_Root::getSingleton();
		$root->mController->setupModuleContext(XCUBE_CORE_USER_MODULE_NAME);
		
		$actionName = "MiscOnline";

		$moduleRunner = new User_ActionFrame(false);
		$moduleRunner->setActionName($actionName);

		$root->mController->mExecute->add(array(&$moduleRunner, 'execute'));

		$root->mController->setDialogMode(true);

		$root->mController->execute();

		$root->mController->executeView();
	}
}

?>
