<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH .'/modules/legacy/class/interface/WorkflowDelegateInterface.class.php';
require_once XOOPS_TRUST_PATH .'/libs/xoonips/class/core/Utils.class.php';
require_once XOOPS_TRUST_PATH .'/libs/xoonips/class/Enum.class.php';

class Xleprogress_DelegateFunctions //extends Legacy_AbstractWorkflowDelegate
{
	public function checkApproval(&$result, /*** int ***/ $type_id)
	{
		$approvalHandler = Legacy_Utils::getModuleHandler('approval', self::_getDirname());
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('type_id', $type_id));
		$approvalObjs = $approvalHandler->getObjects($cri);
		if(count($approvalObjs)==0){
			Xoonips_Utils::loadMessage(Xoonips_Enum::XLEPROGRESS);
			$result[0] = false;
			$result[1] = _MD_XLEPROGRESS_ERROR_SETTING;
			return;
		}
		$result[0] = true;
	}
	
	/**
	 * addItem
	 *
	 * @param string $title
	 * @param int $type_id
	 * @param int $id
	 *
	 * @return	void
	 */ 
	public function addItem(&$result,/*** string ***/ $title, /*** int ***/ $type_id, /*** int ***/ $id)
	{			
		$approvalHandler = Legacy_Utils::getModuleHandler('approval', self::_getDirname());
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('type_id', $type_id));
		$approvalObjs = $approvalHandler->getObjects($cri);
		if(count($approvalObjs)==0){
			Xoonips_Utils::loadMessage(Xoonips_Enum::XLEPROGRESS);
			$result[0] = false;
			$result[1] = _MD_XLEPROGRESS_ERROR_SETTING;
			return;
		}
		$handler = Legacy_Utils::getModuleHandler('item', self::_getDirname());
		$objs = $handler->getObjects(self::_getItemCriteria($type_id, $id));
		if(count($objs)==0){
			$obj = $handler->create();
			$obj->set('title', $title);
			$obj->set('type_id', $type_id);
			$obj->set('target_id', $id);
			$obj->set('uid', Legacy_Utils::getUid());
			$obj->setFirstStep();
			$handler->insert($obj,true);
		}
		elseif(count($objs)==1){
			$obj = array_shift($objs);
			$obj->set('title', $title);
			$obj->set('status', Lenum_WorkflowStatus::PROGRESS);
			$obj->set('updatetime', time());
			$obj->setFirstStep();
			$obj->incrementRevision();
			$handler->insert($obj);
		}
		$result[0] = true;
	}

	/**
	 * deleteItem
	 *
	 * @param int $type_id
	 * @param int $id
	 *
	 * @return	void
	 */ 
	public function deleteItem(/*** int ***/ $type_id, /*** int ***/ $id)
	{
		$handler = Legacy_Utils::getModuleHandler('item', self::_getDirname());
		$objs = $handler->getObjects(self::_getItemCriteria($type_id, $id));
		if(count($objs)==1){
			$handler->delete(array_shift($objs));
		}
	}

	/**
	 * getHistory
	 *
	 * @param mix[] &$historyArr
	 * @param int $type_id
	 * @param int $id
	 *
	 * @return	void
	 */ 
	public function getHistory(/*** mix[] ***/ &$historyArr, /*** int ***/ $type_id, /*** int ***/ $id)
	{
		$handler = Legacy_Utils::getModuleHandler('item', self::_getDirname());
		$objs = $handler->getObjects(self::_getItemCriteria($type_id, $id));
		if(count($objs)==1){
			$obj = array_shift($objs);
			$obj->loadHistory();
			foreach($obj->mHistory as $history){
				$hisotryArr['step'][] = $history->get('step');
				$hisotryArr['uid'][] = $history->get('uid');
				$hisotryArr['result'][] = $history->get('result');
				$hisotryArr['comment'][] = $history->get('comment');
				$hisotryArr['posttime'][] = $history->get('posttime');
			}
		}
	}
	
	/**
	 * getCurrentCertifyUsers
	 *
	 * @param int   $targetId
	 * @param array &uids
	 *
	 * @return	void
	 */
	public function getCurrentCertifyUsers(/*** int ***/ $type_id, /*** int ***/ $targetId, /*** array ***/ &$uids){
		$itemHandler = Legacy_Utils::getModuleHandler('item', self::_getDirname());
		$approvalHandler = Legacy_Utils::getModuleHandler('approval', self::_getDirname());
		$itemObj = $itemHandler->getByTargetId($type_id,$targetId);
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('type_id', $itemObj->get('type_id')));
		$cri->add(new Criteria('step', $itemObj->get('step')));
		$approvalObjs = $approvalHandler->getObjects($cri);
		if($approvalObjs[0]->get('groupid')==null){
			$uids = array($approvalObjs[0]->get('uid'));
			return;
		}
		$groupUsers = array();
		$groupUsersHandler = Legacy_Utils::getModuleHandler('GroupUser', self::_getDirname());
		if($approvalObjs[0]->get('groupid') == Xoonips_Enum::XLEPROGRESS_GROUP){
			$groupId = $itemObj->getTargetGroupId();
			$groupUsers = $groupUsersHandler->getAdminUsers($groupId);
		}
		else{
			$groupUsers = $groupUsersHandler->getUsers($approvalObjs[0]->get('groupid'));
		}
		foreach($groupUsers as $groupUser){
			$uids[] = $groupUser->get('uid');
		}
	}
	
	/**
	 * getAllCertifyUsers
	 *
	 * @param int   $type_id
	 * @param array &uids
	 *
	 * @return	void
	 */
	public function getAllCertifyUsers(/*** int ***/ $type_id, /*** array ***/ &$uids, $groupId=null){
		$approvalHandler = Legacy_Utils::getModuleHandler('approval', self::_getDirname());
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('type_id', $type_id));
		$approvalObjs = $approvalHandler->getObjects($cri);
		foreach ($approvalObjs as $obj) {
			if ($obj->get('groupid') == null) {
				$uids[$obj->get('uid')] = $obj->get('uid');
				continue;
			}
			$groupUsers = array();
			$groupUsersHandler = Legacy_Utils::getModuleHandler('GroupUser', self::_getDirname());
			if ($obj->get('groupid') == Xoonips_Enum::XLEPROGRESS_GROUP) {
				if ($groupId != null) {
					$groupUsers = $groupUsersHandler->getAdminUsers($groupId);
				}
			} else {
				$groupUsers = $groupUsersHandler->getUsers($obj->get('groupid'));
			}
			foreach ($groupUsers as $groupUser) {
				$uids[$groupUser->get('uid')] = $groupUser->get('uid');
			}
		}
	}
	
	/**
	 * autoReject
	 *
	 * @param int   $target_id
	 * @param array &$result
	 *
	 * @return	void
	 */
	public function autoReject(&$result,/*** int ***/ $type_id,/*** int ***/ $target_id){
		$itemHandler = Legacy_Utils::getModuleHandler('item', self::_getDirname());
		$obj = $itemHandler->getByTargetId($type_id, $target_id);
		if(!is_object($obj)){
			$result = false; 
			return;
		}
		$obj->set('status', Lenum_WorkflowStatus::REJECTED);
		if($itemHandler->insert($obj)){
			$result = true;
			return ;
		}
		$result = false;
	}
	
	/**
	 * autoReject
	 *
	 * @param int   $target_id
	 * @param array &$result
	 *
	 * @return	void
	 */
	public function autoCertify(&$result, /*** int ***/ $type_id, /*** int ***/ $target_id){
		$itemHandler = Legacy_Utils::getModuleHandler('item', self::_getDirname());
		$obj = $itemHandler->getByTargetId($type_id, $target_id);
		if(!is_object($obj)){
			$result = false; 
			return;
		}
		$obj->set('status', Lenum_WorkflowStatus::FINISHED);
		if($itemHandler->insert($obj)){
			$result = true;
			return ;
		}
		$result = false;
	}
	
	/**
	 * countMyTask
	 *
	 * @param int &$result
	 *
	 * @return	void
	 */
	public function countMyTask(&$result){
		$uid = Legacy_Utils::getUid();
		$handler = Legacy_Utils::getModuleHandler('item',self::_getDirname());
		$objs = $handler->getMyTaskList($uid);
		if($objs){
			$result = count($objs);
		}
		else{
			$result = 0;
		}
	}
	
	/**
	 * checkAuthen
	 *
	 * @param bool &$result
	 *
	 * @return	void
	 */
	public function checkAuthen(&$result){
		$uid = Legacy_Utils::getUid();
		$handler = Legacy_Utils::getModuleHandler('approval',self::_getDirname());
		$result = $handler->checkAuthen($uid);
	}
	/**
	 * _getDirname
	 *
	 * @param void
	 *
	 * @return	string
	 */ 
	protected function _getDirname()
	{
		return LEGACY_WORKFLOW_DIRNAME;
	}


	/**
	 * _getItemCriteria
	 *
	 * @param string $dirname
	 * @param string $dataname
	 * @param int	 $id
	 *
	 * @return	
	 */ 
	protected function _getItemCriteria(/*** string ***/ $type_id, /*** int ***/ $id)
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('type_id', $type_id));
		$cri->add(new Criteria('target_id', $id));
		$cri->add(new Criteria('deletetime', 0));
	
		return $cri;
	}

}

?>
