<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * Xleprogress_UserObject
**/
class Xleprogress_UserObject extends XoopsSimpleObject
{
	public $mDirname = null;

	/**
	 * __construct
	 * 
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct()
	{
		$this->initVar('uid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('activate', XOBJ_DTYPE_INT, '', false);
		$this->initVar('name', XOBJ_DTYPE_STRING, '', false, 60);
		$this->initVar('uname', XOBJ_DTYPE_STRING, '', false, 25);
	}
	
	/**
	 * _getDirname
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	public function getDirname()
	{
		return $this->mDirname;
	}
}

/**
 * Xleprogress_UserHandler
**/
class Xleprogress_UserHandler extends XoopsObjectGenericHandler
{
	public /*** string ***/ $mTable = 'users';

	public /*** string ***/ $mPrimary = 'uid';

	public /*** string ***/ $mClass = 'Xleprogress_UserObject';

	/**
	 * __construct
	 * 
	 * @param	XoopsDatabase  &$db
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
	{
		$this->mTable = strtr($this->mTable,array('{dirname}' => $dirname));
		parent::XoopsObjectGenericHandler($db);
	}

	/**
	 * getUserList
	 * 
	 * @param	string	$dirname
	 * @param	string	$target
	 * 
	 * @return	Xleprogress_UserObject[]
	**/
	public function getUserList()
	{
		$ret = array();
		global $xoopsDB;
		$userTable = $xoopsDB->prefix('users');
		$activateTable = $xoopsDB->prefix(self::getActivateTableName());		
		$obj = new Xleprogress_UserObject();
		$sql = "select a.uid,b.value as activate,a.name,a.uname from $userTable a";
		$sql .=" left join $activateTable b on a.uid=b.uid where b.value=2 order by a.uname";
		$result = $xoopsDB->queryF($sql);
        if($result!= false){
        	 while($row = $xoopsDB->fetchArray($result)){
        	 	$obj = new Xleprogress_UserObject();
        	 	$obj->set('uid',$row['uid']);
        	 	$obj->set('activate',$row['activate']);
        	 	$obj->set('name',$row['name']);
        	 	$obj->set('uname',$row['uname']);
        	 	$ret[] = $obj;
        	 }
        }
        return $ret;
	}

	private static function getActivateTableName() {
    	$module_handler =& xoops_gethandler('module');
		$module =& $module_handler->getByDirname(XCUBE_CORE_USER_MODULE_NAME);
		if (is_object($module)) {
			$trustDirname = $module->getVar('trust_dirname');
		} else {
			$trustDirname = 'user';
		}
		require_once XOOPS_TRUST_PATH . '/modules/' . $trustDirname . '/class/core/UserFieldManager.class.php';
    	$userFieldManager = User_UserFieldManager::getInstance(true);
    	foreach ($userFieldManager->getFields() as $field) {
    		if ($field->getXmlTag() == 'activate') {
				return $field->getTableName();    		
    		}
    	}
    	return $this->dirname . '_extend35';
    }
}

?>

