<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XLEPROGRESS_TRUST_PATH . '/admin/class/installer/XleprogressInstallUtils.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

/**
 * Xleprogress_Installer
**/
class Xleprogress_Installer
{
    public /*** Legacy_ModuleInstallLog ***/ $mLog = null;

    private /*** bool ***/ $_mForceMode = false;

    private /*** XoopsModule ***/ $_mXoopsModule = null;

    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->mLog = new Legacy_ModuleInstallLog();
    }

    /**
     * setCurrentXoopsModule
     * 
     * @param   XoopsModule  &$xoopsModule
     * 
     * @return  void
    **/
    public function setCurrentXoopsModule(/*** XoopsModule ***/ &$xoopsModule)
    {
        $this->_mXoopsModule =& $xoopsModule;
    }

    /**
     * setForceMode
     * 
     * @param   bool  $isForceMode
     * 
     * @return  void
    **/
    public function setForceMode(/*** bool ***/ $isForceMode)
    {
        $this->_mForceMode = $isForceMode;
    }

    /**
     * _installTables
     * 
     * @param   void
     * 
     * @return  bool
    **/
    private function _installTables()
    {
        Xleprogress_InstallUtils::installSQLAutomatically(
        	$this->_mXoopsModule,
        	$this->mLog
        );
    }

    /**
     * _installModule
     * 
     * @param   void
     * 
     * @return  bool
    **/
    private function _installModule()
    {
        $moduleHandler =& Xleprogress_Utils::getXoopsHandler('module');
        if(!$moduleHandler->insert($this->_mXoopsModule))
        {
            $this->mLog->addError(_MI_XLEPROGRESS_INSTALL_ERROR_MODULE_INSTALLED);
            return false;
        }
    
        $gpermHandler =& Xleprogress_Utils::getXoopsHandler('groupperm');
    
        if($this->_mXoopsModule->getInfo('hasAdmin'))
        {
            $adminPerm =& $this->_createPermission(XOOPS_GROUP_ADMIN);
            $adminPerm->setVar('gperm_name','module_admin');
            if(!$gpermHandler->insert($adminPerm))
            {
                $this->mLog->addError(_MI_XLEPROGRESS_INSTALL_ERROR_PERM_ADMIN_SET);
            }
        }
    
        if($this->_mXoopsModule->getInfo('hasMain'))
        {
            if($this->_mXoopsModule->getInfo('read_any'))
            {
                $memberHandler =& Xleprogress_Utils::getXoopsHandler('member');
                $groupObjects =& $memberHandler->getGroups();
                foreach($groupObjects as $group)
                {
                    $readPerm =& $this->_createPermission($group->getVar('groupid'));
                    $readPerm->setVar('gperm_name','module_read');
                    if(!$gpermHandler->insert($readPerm))
                    {
                        $this->mLog->addError(_MI_XLEPROGRESS_INSTALL_ERROR_PERM_READ_SET);
                    }
                }
            }
            else
            {
                foreach(array(XOOPS_GROUP_ADMIN,XOOPS_GROUP_USERS) as $group)
                {
                    $readPerm =& $this->_createPermission($group);
                    $readPerm->setVar('gperm_name','module_read');
                    if(!$gpermHandler->insert($readPerm))
                    {
                        $this->mLog->addError(_MI_XLEPROGRESS_INSTALL_ERROR_PERM_READ_SET);
                    }
                }
            }
        }
    
        return true;
    }

    /**
     * &_createPermission
     * 
     * @param   int  $group
     * 
     * @return  XoopsGroupPerm
    **/
    private function &_createPermission(/*** int ***/ $group)
    {
        $gpermHandler =& Xleprogress_Utils::getXoopsHandler('groupperm');
        $perm =& $gpermHandler->create();
        $perm->setVar('gperm_groupid',$group);
        $perm->setVar('gperm_itemid',$this->_mXoopsModule->getVar('mid'));
        $perm->setVar('gperm_modid',1);
    
        return $perm;
    }

    /**
     * _installTemplates
     * 
     * @param   void
     * 
     * @return  void
    **/
    private function _installTemplates()
    {
        Xleprogress_InstallUtils::installAllOfModuleTemplates(
            $this->_mXoopsModule,
            $this->mLog
        );
    }

    /**
     * _installBlocks
     * 
     * @param   void
     * 
     * @return  void
    **/
    private function _installBlocks()
    {
        Xleprogress_InstallUtils::installAllOfBlocks(
            $this->_mXoopsModule,
            $this->mLog
        );
    }

    /**
     * _installPreferences
     * 
     * @param   void
     * 
     * @return  void
    **/
    private function _installPreferences()
    {
        Xleprogress_InstallUtils::installAllOfConfigs(
            $this->_mXoopsModule,
            $this->mLog
        );
    }

        
	function _processScript()
    {        
    	Xleprogress_InstallUtils::installTypeUser(
    	    	$this->_mXoopsModule,
       	 	$this->mLog
    	);
    	Xleprogress_InstallUtils::installTypeXooNIps(
        		$this->_mXoopsModule,
       	 	$this->mLog
    	);	
    	$result = $this->moduleInstall($this->_mXoopsModule);
    	if (!$result) {
    		$this->mLog->addError(_MI_XLEPROGRESS_INSTALL_ERROR_MODULE_INSTALLED);	
    	}
    }

    /**
     * _processReport
     * 
     * @param   void
     * 
     * @return  void
    **/
    private function _processReport()
    {
        if(!$this->mLog->hasError())
        {
            $this->mLog->add(
                XCube_Utils::formatString(
                    _MI_XLEPROGRESS_INSTALL_MSG_MODULE_INSTALLED,
                    $this->_mXoopsModule->getInfo('name')
                )
            );
        }
        else if(is_object($this->_mXoopsModule))
        {
            $this->mLog->addError(
                XCube_Utils::formatString(
                    _MI_XLEPROGRESS_INSTALL_ERROR_MODULE_INSTALLED,
                    $this->_mXoopsModule->getInfo('name')
                )
            );
        }
        else
        {
            $this->mLog->addError(
                XCube_Utils::formatString(
                    _MI_XLEPROGRESS_INSTALL_ERROR_MODULE_INSTALLED,
                    'something'
                )
            );
        }
    }

    /**
     * executeInstall
     * 
     * @param   void
     * 
     * @return  bool
    **/
    public function executeInstall()
    {
        $this->_installTables();
        if(!$this->_mForceMode && $this->mLog->hasError())
        {
            $this->_processReport();
            return false;
        }
    
        $this->_installModule();
        if(!$this->_mForceMode && $this->mLog->hasError())
        {
            $this->_processReport();
            return false;
        }
    
        $this->_installTemplates();
        if(!$this->_mForceMode && $this->mLog->hasError())
        {
            $this->_processReport();
            return false;
        }
    
        $this->_installBlocks();
        if(!$this->_mForceMode && $this->mLog->hasError())
        {
            $this->_processReport();
            return false;
        }
    
        $this->_installPreferences();
        if(!$this->_mForceMode && $this->mLog->hasError())
        {
            $this->_processReport();
            return false;
        }

        $this->_processScript();
		if (!$this->_mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}

		$this->_processReport();
        return true;
    }
    
    private function moduleInstall($xoopsMod) {
    	$mydirname = $xoopsMod->getVar('dirname');
    	$uid = $GLOBALS['xoopsUser']->getVar('uid', 'n');
    	$mid = $xoopsMod->getVar('mid', 'n');

    	// check moderator groups
    	$mgid = null;
    	$member_handler =& xoops_gethandler('member');
    	$groups = $member_handler->getGroupList();
    	foreach ($groups as $id => $val) {
    		if ($val == 'moderator') {
    			$mgid = $id;
    		}
    	}

    	// create and join moderator group
    	if (is_null($mgid)) $mgid = Xleprogress_InstallUtils::createGroup('moderator', 'platform moderator');
    	if ($mgid === false) {
    		return false;
    	}
    
    	// set module_admin for moderator group
    	Xleprogress_InstallUtils::setReadRight(true, $mid, $mgid, true);
    	Xleprogress_InstallUtils::setAdminRight($mid, $mgid);
    
    	$modulehandler =& xoops_gethandler('module');
    	$module =& $modulehandler->getByDirname(XCUBE_CORE_USER_MODULE_NAME);
    	Xleprogress_InstallUtils::setReadRight(true, $module->get('mid'), $mgid, true);
    	Xleprogress_InstallUtils::setAdminRight($module->get('mid'), $mgid);
    
    	$module =& $modulehandler->getByDirname('xoonips');
    	if ($module) {
    		Xleprogress_InstallUtils::setReadRight(true, $module->get('mid'), $mgid, true);
    		Xleprogress_InstallUtils::setAdminRight($module->get('mid'), $mgid);
    	}
    
    	// set group active
    	$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', XCUBE_CORE_USER_MODULE_NAME);
    	if (!$groupBean -> groupsCertify($mgid)) {
    		return false;
    	}
    
    	if (!Xleprogress_InstallUtils::addUserToXoopsGroup($mgid, $uid)) {
    		return false;
    	}
    	
    	// mainmenu of legacy
    	if (defined('XOOPS_CUBE_LEGACY')) {
    		$sysmid = Xleprogress_InstallUtils::getModuleId('legacy');
    		if ($sysmid === false) continue;
    		$bids = Xleprogress_InstallUtils::getBlockIds($sysmid, 'b_legacy_mainmenu_show');
    		foreach ($bids as $bid) {
    			Xleprogress_InstallUtils::setReadRight(false, $bid, $mgid, true);
    		}
    	}
    	
    	// install approval
    	$types = Xleprogress_InstallUtils::getTypeList($this->_mXoopsModule);
    	foreach ($types as $type) {
    		$tid = $type->get('type_id');
    		$m_arr = array('user.WorkflowGroupJoin','user.WorkflowGroupLeave'
    				,'xoonips.WorkflowGroupItems','xoonips.WorkflowGroupItemsWithdrawal');
    		$gid = $mgid;
    		if (in_array($type->get('module'), $m_arr)) $gid = 999999;
    		Xleprogress_InstallUtils::installApproval($this->_mXoopsModule, $gid, $tid, '10');
    	}
    	
    	return true;
	}
}
?>
