<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * Xleprogress_GroupObject
**/
class Xleprogress_GroupUserObject extends XoopsSimpleObject
{
	public $mDirname = null;

	/**
	 * __construct
	 * 
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct()
	{
		$this->initVar('linkid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('activate', XOBJ_DTYPE_INT, '', false);
		$this->initVar('groupid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('uid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('is_admin', XOBJ_DTYPE_INT, '', false);
	}
	
	/**
	 * _getDirname
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	public function getDirname()
	{
		return $this->mDirname;
	}
}

/**
 * Xleprogress_GroupHandler
**/
class Xleprogress_GroupUserHandler extends XoopsObjectGenericHandler
{
	public /*** string ***/ $mTable = 'groups_users_link';

	public /*** string ***/ $mPrimary = 'linkid';

	public /*** string ***/ $mClass = 'Xleprogress_GroupUserObject';

	/**
	 * __construct
	 * 
	 * @param	XoopsDatabase  &$db
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
	{
		$this->mTable = strtr($this->mTable,array('{dirname}' => $dirname));
		parent::XoopsObjectGenericHandler($db);
	}

	/**
	 * getUsers
	 * 
	 * @param	int	$groupid
	 * 
	 * @return	Xleprogress_GroupUserObject[]
	**/
	public function getUsers($groupid)
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('activate',1,'<>'));
		$cri->add(new Criteria('groupid',$groupid,'='));
		return $this->getObjects($cri);
	}
	
	/**
	 * getAdminUsers
	 * 
	 * @param	int	$groupid
	 * 
	 * @return	Xleprogress_GroupUserObject[]
	**/
	public function getAdminUsers($groupid)
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('activate',1,'<>'));
		$cri->add(new Criteria('groupid',$groupid,'='));
		$cri->add(new Criteria('is_admin','1','='));
		return $this->getObjects($cri);
	}

}

?>

