<?php

require_once 'BeanFactory.class.php';

class Xoonips_ComplementFactory {

	private static $instance;
	private $complementInstances = array();

	private function Xoonips_ComplementFactory($dirname, $trustDirname) {
		$bean = Xoonips_BeanFactory::getBean('ComplementBean', $dirname, $trustDirname);
		$complements = $bean->getComplementInfo();
		if( !$complements ){
			return;
		}
		foreach($complements as $comp){
			$compId = $comp['complement_id'];
			$vtId = $comp['view_type_id'];
			$module = $comp['module'];
			if (empty($module)){
				continue;
			}

			if (file_exists(XOOPS_TRUST_PATH . "/modules/$trustDirname/class/core/" . $module . '.class.php')) {
				require_once XOOPS_TRUST_PATH . "/modules/$trustDirname/class/core/" . $module . '.class.php';
				$className = UCfirst($trustDirname) . '_' . $module;
			} elseif (file_exists(XOOPS_TRUST_PATH . "/libs/xoonips/class/core/" . $module . '.class.php')) {
				require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/" . $module . '.class.php';
				$className = 'Xoonips_' . $module;
			} else {
				echo "$module is not found";
				return false;
			}
			$this->complementInstances[$vtId] = new $className;
			$this->complementInstances[$vtId]->setId($compId);
			$this->complementInstances[$vtId]->setDirname($dirname);
			$this->complementInstances[$vtId]->setTrustDirname($trustDirname);
		}
	}

	public static function getInstance($dirname, $trustDirname){
		if (!isset(self::$instance)) {
			$c = __CLASS__;
			self::$instance = new $c($dirname, $trustDirname);
		}
		return self::$instance;
	}

	public function getComplement($id){
		return $this->complementInstances[$id];
	}
}

