<?php

class model_itemdel{
  private $dirname;
  private $trustDirname;
  private $transaction;
  
  // error handling
  private $bean_func_name; // fail to delete in delete_each function.
  private $file_id;        // fail to detele file_id
  private $table_name;     // fail table name
  private $uid;

  /**
   * Initialize mode_itemdel class.
   * !! Create instance,immediately call this function. !!
   */
  public function Init() {
    $this->dirname = $this->trustDirname = 'xoonips';
    $this->transaction = Xoonips_Transaction::getInstance();
  }
  
  
  public function set_uid($uid) {
    $this->uid = $uid;
  }

  /**
   * del function occur error.
   * occuring error function name get this function.
   */
  public function get_error_info($rc) {
    switch ($rc) {
    case -1:
      return $this->bean_func_name.' error detect.';
      break;
    case -2:
      return 'Table name '.$this->table_name.' delete error.';
      break;
    case -3:
      return 'File id '.$this->file_id.' delete error.';
      break;
    case -4:
      return 'item_id doesn\'t find related item.';
      break;
    case -5:
      return 'You don\'t have that item delete permission.';
      break;        
    }
  }

  /**
   * delete db,exclude item_extend
   * 
   * @param type $item_id 
   */
  private function delete_each($item_id) {
    // delete all items
    // below array,key is class name and value is delete fuctionname
    $beans = array(
      'ItemBean'  => 'delete',
      'ItemRelatedToBean' => 'deleteBoth',
      'ItemChangeLogBean' => 'delete',
      'ItemUsersLinkBean' => 'delete',
      'IndexItemLinkBean' => 'delete',
      'ItemFileBean'      => 'deleteFiles',
      'ItemTitleBean'     => 'delete',
      'ItemKeywordBean'   => 'delete'
    );
    foreach ($beans as $bean_name => $del_func) {
      $bean_instance = Xoonips_BeanFactory::getBean($bean_name, $this->dirname, $this->trustDirname);
      if (method_exists($bean_instance,$del_func) == false) {
        $this->bean_func_name = $bean_name.'.'.$del_func;
        return false;
      }
      $rc = $bean_instance->$del_func($item_id);
      if ($rc == false) {
        $this->bean_func_name = $bean_name.'.'.$del_func;
        return false;
      }
      unset($bean_instance);
    }
    return true;
  }
  
  /**
   * Extend table delete
   * 
   * @param integer $item_id
   * @return boolean true:Success,false:Fail
   */
  private function delete_extend($item_id) {
    $item_bean = Xoonips_BeanFactory::getBean('ItemBean', $this->dirname, $this->trustDirname);
    $item_extend_bean = Xoonips_BeanFactory::getBean('ItemExtendBean', $this->dirname, $this->trustDirname);
    $field_detail = $item_bean->getItemTypeDetails($item_id);
    foreach ($field_detail as $field_detail_row) {
      $this->table_name = $field_detail_row['table_name'];
      $pos = strpos($this->table_name, 'xoonips_item_extend');
      if ($pos === false||$pos != 0) {
        return false;
      }

      if ($item_extend_bean->delete($item_id,$this->table_name) == false) {
        return false;
      }
    }
    return true;
  }

  private function delete_file($file_id,$item_id) {
    $config_bean = Xoonips_BeanFactory::getBean('ConfigBean', $this->dirname, $this->trustDirname);
    $uploadDir = $config_bean->getConfig('upload_dir');
    $del_file_name = $uploadDir.'/item/'.$item_id.'/'.$file_id;

    if (file_exists($del_file_name) == false) {
      return false;
    }
    if (unlink($del_file_name)) {
      return true;
    }
    return false;
  }
  
  private function delete_files($item_id) {
    $item_file_bean = Xoonips_BeanFactory::getBean('ItemFileBean', $this->dirname, $this->trustDirname);
    $item_files = $item_file_bean->getFilesByItemId($item_id);
    foreach ($item_files as $item_file_row) {
      $this->file_id = $item_file_row['file_id'];
      $rc = $this->delete_file($this->file_id,$item_id);
      if($rc == false){
        return false;
      }
    }
    return true;
  }
  
  /**
   * Exist item_id?
   * 
   * @param type $item_id
   * @return type 
   */
  private function exist_item($item_id) {
    $item_bean = Xoonips_BeanFactory::getBean('ItemBean', $this->dirname, $this->trustDirname);
    $arr = $item_bean->getItemBasicInfo($item_id);
    if (empty($arr))
      return false;
    return true;
  }

  private function canDelete($item_id) {
    $item_virtual_bean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $this->dirname, $this->trustDirname);
    return $item_virtual_bean->canItemDelete($item_id,  $this->uid);
  }
  
  /**
   * Table and upload file delete related item_id.
   * 
   * @param type $item_id
   * @return integer 0:Success,
   *                  -1:each table delete fail ,
   *                  -2:extend table delete fail.
   *                  -3:fail delete file.
   *                  -4:item_id don't exist.
   *                  -5:You don't have permission.
   */
  public function del($item_id){
    if ($this->exist_item($item_id) == false) {
      return -4;
    }
    if ($this->canDelete($item_id)==false) {
      return -5;
    }
    
    $this->transaction->start();
    if ($this->delete_each($item_id) == false) {
      $this->transaction->rollback();
      return -1;
    }
    if ($this->delete_extend($item_id) == false) {
      $this->transaction->rollback();
      return -2;
    }
    $this->transaction->commit();
    return 0;
  }
}
