<?php

require_once dirname(dirname(__FILE__)) . '/class/core/User.class.php';
require_once dirname(dirname(__FILE__)) . '/class/core/ActionBase.class.php';

class User_UserSearchAction extends User_ActionBase {
	private $breadcrumbs = array(
		array(
			'name' => _MD_USER_LANG_USERSEARCH
		)
	);
	private $breadcrumbs_userlist = array(
		array(
			'name' => _MD_USER_LANG_USERSEARCH,
			'url' => 'index.php?action=userSearch'
		),
		array(
			'name' => _MD_USER_LANG_USERLIST
		)
	);
		
	private function getUserId() {
		$userId = $_SESSION['xoopsUserId'];
		return $userId;
	}
    
	// set page size
	private $perPage = 20;
	
	/**
	 * Moderator 
	 * 
	 * @return bool
	 */
	private function isModerator() {
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$ret = false;
		if ($userBean->isModerator($this->getUserId())) {
			$ret = true;
		}
		return $ret;
	}
		
	/**
	 * User can delete itself.
	 * 
	 * @return bool
	 */
	private function isSelfDelete() {
		$ret = false;
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		if ($myxoopsConfigUser['self_delete'] == 1) {
			$ret = true;
		}
		return $ret;
	}
	
	/**
	 * Every page's url setting.
	 * 
	 * @param array $list
	 *        string $url
	 *        int $perPage
	 * @return array
	 */
	private function pagenavi($list, $url, $perPage) {
		$cnt = 1;
		$pageIndex = array();
		(int) $pageCount = count($list) / $perPage + 1;
		do {
			$page = $cnt;
			$pageIndex[$cnt] = "$url" . "page=$page";
			$cnt++;
		} while ($cnt < $pageCount);
		return $pageIndex;
	}
	
	/**
	 * Every page's user information setting.
	 * 
	 * @param array $userslist
	 *        int $page
	 *        int $perPage
	 * @return array
	 */
	private function pageUserslist($userslist, $page, $perPage) {
		$pagelists = array_chunk($userslist, $perPage);
		$ret = array();
		$cnt = 1;
		foreach ($pagelists as $list) {
			if ($cnt == $page) {
				$ret = $list;
				break;
			}
			$cnt++;
		}
		return $ret;
	}
	
	/**
	 * Get array_multisort's list. 
	 * 
	 * @param array $userslist
	 *        int $detailId
	 *        string $sortkey
	 * @return array
	 */
	private function getSortList($userslist, $detailId, $sortkey) {
		$extendTbl = "user_extend$detailId";
		$sortlist = array();
		foreach ($userslist as $row) {
			if (!isset($row[$sortkey])) {
				//if extend table
				if (isset($row[$extendTbl])) {
					foreach ($row as $key => $rowTag) {
						if ($key == $extendTbl) {
							$sortlist[] = $rowTag[0];
						}
					}
				} else {
					$sortlist[] = null;
				}
			} else {
				$sortlist[] = $row[$sortkey];
			}
		}
		return $sortlist;
	}
	
	/**
	 * 
	 * initialization view
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doInit(&$request, &$response) {
		$user = User_User::getInstance();
		$userType = 'user';
		$viewData['searchView'] = $user->getSearchView();
		$viewData['xoops_breadcrumbs'] = $this->breadcrumbs;
		$viewData['select_tab'] = 1;
		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}
	
	/**
	 * 
	 * do search
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doSearch(&$request, &$response) {
		$user = User_User::getInstance();
		$viewData = array();
		$errors = new Xoonips_Errors();
		$user->setDataFromPost($_POST);
		$user->searchCheck($errors);
		$page = $request->getParameter('page');
		if (!isset($_POST['sortkey'])) {
			$sortkey = '';
		} else {
			$sortkey = $_POST['sortkey'];
		}
		if (!isset($_POST['Id'])) {
			$detailId = '';
		} else {
			$detailId = $_POST['Id'];
		}
		if (!isset($_POST['newOrder'])) {
			$order = '';
		} else {
			$order = $_POST['newOrder'];
		}
		if ($page == '') {
			$page = 1;
		}
		if (count($errors->getErrors()) != 0) {
			$viewData['xoops_breadcrumbs'] = $this->breadcrumbs;
			$viewData['select_tab'] = 1;
			$viewData['searchView'] = $user->getSearchViewWithData();
			$viewData['errors'] = $errors->getView($this->dirname);
			$response->setViewData($viewData);
			$response->setForward('inputError');
		} else {
			$userslist = $user->doSearch();
			if ($userslist === false) {
				$response->setSystemError('search error!');
				return false;
			}
			//sequence
			if ($detailId != '') {
				$sortlist = $this->getSortList($userslist, $detailId, $sortkey);
				if ($order == 'DESC') {
					array_multisort($sortlist, SORT_DESC, $userslist);
				} else {
					array_multisort($sortlist, $userslist);
				}
			}
			
			$viewData['xoops_breadcrumbs'] = $this->breadcrumbs_userlist;
			$viewData['isSelfDelete'] = $this->isSelfDelete();
			$viewData['isModerator'] = $this->isModerator();
			unset($_POST['sortkey']);
			unset($_POST['Id']);
			unset($_POST['newOrder']);
			$viewData['hiddenData'] = $_POST;
			$viewData['userId'] = $this->getUserId();
			$viewData['userslist'] = $this->pageUserslist($userslist, $page, $this->perPage);
			$viewData['head'] = $user->getDetailHead();
			$viewData['pagenavi'] = $this->pagenavi($userslist, "index.php?action=userSearch&op=search&", $this->perPage);
			$viewData['detailId'] = $detailId;
			$viewData['sortkey'] = $sortkey;
			$viewData['order'] = $order;
			$viewData['page'] = $page;
			$response->setForward('success');
			$response->setViewData($viewData);
		}
		return true;
	}
	
	/**
	 * 
	 * sequence
	 * 
	 * @param object $request
	 *        object $response
	 * @return boolean
	 */
	protected function doSort(&$request, &$response) {
		$user = User_User::getInstance();
		$user->setDataFromPost($_POST);
		$sortkey = $request->getParameter('key');
		$order = $request->getParameter('order');
		$detailId = $request->getParameter('detailId');
		$userslist = $user->doSearch();
		$head = $user->getDetailHead();
		$sortlist = $this->getSortList($userslist, $detailId, $sortkey);
		if ($order == 'DESC') {
			array_multisort($sortlist, SORT_DESC, $userslist);
		} else {
			array_multisort($sortlist, $userslist);
		}
		//set page
		$page = 1;
		unset($_POST['sortkey']);
		unset($_POST['Id']);
		unset($_POST['newOrder']);
		$viewData['hiddenData'] = $_POST;
		$viewData['userslist'] = $this->pageUserslist($userslist,$page,$this->perPage);
		$viewData['pagenavi'] = $this->pagenavi($userslist, "index.php?action=userSearch&op=search&", $this->perPage);
		$viewData['head'] = $head;
		$viewData['xoops_breadcrumbs'] = $this->breadcrumbs_userlist;
		$viewData['isSelfDelete'] = $this->isSelfDelete();
		$viewData['isModerator'] = $this->isModerator();
		$viewData['userId'] = $this->getUserId();
		$viewData['detailId'] = $detailId;
		$viewData['sortkey'] = $sortkey;
		$viewData['order'] = $order;
		$viewData['page'] = $page;
		$response->setForward('success');
		$response->setViewData($viewData);
		return true;
	}
}

