<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . "/class/AbstractDeleteAction.class.php";
require_once USER_TRUST_PATH . "/admin/forms/UserValueSetAdminEditForm.class.php";
require_once XOOPS_TRUST_PATH . "/libs/xoonips/class/core/BeanFactory.class.php";

class User_UserValueSetDeleteAction extends User_AbstractDeleteAction
{
	var $message = null;

	function _getId()
	{
		return xoops_getrequest('title_id');
	}

	function _getName()
	{
		return xoops_getrequest('select_name_input');
	}
	
	function _getMode()
	{
		return xoops_getrequest('mode');
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('user_field_value_set');
		return $handler;
	}
	
	function _setupActionForm()
	{
		$this->mActionForm = new User_UserValueSetAdminEditForm();		
		$this->mActionForm->prepare();
	}
	
	function _setupObject()
	{		
		$name = $this->_getName();
		$id = $this->_getId();
		$this->mObjectHandler = $this->_getHandler();		
		$this->mObject =& $this->mObjectHandler->getDetail($name,$id);
		$userValueSetBean= Xoonips_BeanFactory::getBean('UserFieldValueSetBean', $this->dirname, $this->trustDirname);
		if ($userValueSetBean->checkUsedTitleId($name, $id) > 0) {
			$this->message = _AM_USER_ERROR_VALUE_DELETE;
			return USER_FRAME_VIEW_ERROR;
		}
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$mode = $this->_getMode();
		$name = $this->_getName();
		$url = "./index.php?action=UserValueSetEdit&mode=$mode&select_name_input=$name";
		$controller->executeForward($url);

	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$mode = $this->_getMode();
		$name = $this->_getName();
		$url = "./index.php?action=UserValueSetEdit&mode=$mode&select_name_input=$name";
		$controller->executeRedirect($url, 1, _AD_USER_MESSAGE_DELETE);
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$mode = $this->_getMode();
		$name = $this->_getName();
		$url = "./index.php?action=UserValueSetEdit&mode=$mode&select_name_input=$name";
		if (is_null($this->message)) {
			$controller->executeRedirect($url, 1, _MD_USER_ERROR_DBUPDATE_FAILED);
		} else {
			$controller->executeRedirect($url, 1, $this->message);
		}
	}	
}


