<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/core/XCube_ActionForm.class.php";

class User_UserValueSetAdminEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.user.UserValueSetAdminEditForm.TOKEN" . $this->get('select_name');
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['select_name_db'] = new XCube_StringProperty('select_name_db');
		$this->mFormProperties['select_name_input'] = new XCube_StringProperty('select_name_input');
		$this->mFormProperties['title'] = new XCube_StringProperty('title');
		$this->mFormProperties['mode'] = new XCube_IntProperty('mode');
		$this->mFormProperties['op'] = new XCube_StringProperty('op');				
		//
		// Set field properties
		//
		$this->mFieldProperties['select_name_input'] = new XCube_FieldProperty($this);
		$this->mFieldProperties['select_name_input']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['select_name_input']->addMessage('required', _MD_USER_ERROR_REQUIRED, _AD_USER_LANG_USER_VALUE_SET_TITLE, '50');
		$this->mFieldProperties['select_name_input']->addMessage('maxlength', _MD_USER_ERROR_MAXLENGTH, _AD_USER_LANG_USER_VALUE_SET_TITLE, '50');
		$this->mFieldProperties['select_name_input']->addVar('maxlength', 50);
	}
	
	function validateSelect_Name_Input()
	{
		if (($this->get('mode') == 1 && $this->get('select_name_db') == '')
			|| ($this->get('mode') == 5 && $this->get('select_name_input') != $this->get('select_name_db'))) {
			//
			// name unique check
			//
			$handler =& xoops_getmodulehandler('user_field_value_set');
			$this->mObject =$handler->get(addslashes($this->get('select_name_input')));
				
			if($this->mObject != null){
				$this->addErrorMessage(_AD_USER_ERROR_SELECT_NAME_EXISTS);
			}
		}
	}
	
	function load(&$obj)
	{
		$this->set('select_name_input', $obj[0]->get('select_name'));
	}

	function update(&$obj)
	{
		if ($obj[0]->get('title_id') != '') {
			$this->set('select_name_db', $this->get('select_name_input'));
		}
		if($this->get('mode') == 1){
			$obj[0]->set('select_name', $this->get('select_name_input'));
		}
	}
}


