<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Field.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';
require_once 'User.class.php';

class User_UserField extends Xoonips_Field {
	
	public function isDisplay($op, $userType) {
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$user = User_User::getInstance();
		$uid = $user->getId();
		$ret = true;
		$viewType= $this->getViewType();
		//
		if ($viewType->isDisplay($op) == false) {
			return false;
		} elseif ($userType == Xoonips_Enum::USER_TYPE_MODERATOR) {
			return true;
			//$op(1:list 2:detail 3:registry 4:edit 5:search)
			//$userType(0:guest 1:user 2:groupManager 3:moderator)
	    } elseif ($this->getNonDisplay() == 1 && ($userType != Xoonips_Enum::USER_TYPE_MODERATOR || $op != Xoonips_Enum::OP_TYPE_EDIT)) {
			return false;
		} else {
			//$op(1:list 2:detail 3:registry 4:edit 5:search)
			switch ($op) {
				case Xoonips_Enum::OP_TYPE_LIST:
					if ($this->getListDisplay() == 0) {
						$ret = false;
					}
					break;
				case Xoonips_Enum::OP_TYPE_DETAIL:
					if ($userType == Xoonips_Enum::USER_TYPE_GUEST) {
						if ($this->getDetailDisplay() < 3) {
							$ret = false;
						}
					}
					if ($userType == Xoonips_Enum::USER_TYPE_USER) {
						if ($userBean->isModerator($_SESSION['xoopsUserId']) || $uid == $_SESSION['xoopsUserId']) {
							if ($this->getDetailDisplay() < 1) {
								$ret = false;
							}
						} else {
							if ($this->getDetailDisplay() < 2) {
								$ret = false;
							}
						}
					}
					if ($userType == Xoonips_Enum::USER_TYPE_MODERATOR) {
						if ($this->getDetailDisplay() < 1) {
							$ret = false;
						}
					}
					break;
				case Xoonips_Enum::OP_TYPE_REGISTRY:
					if ($this->getRegistry() == 0) {
						$ret = false;
					}
					break;
				case Xoonips_Enum::OP_TYPE_EDIT:
					if ($this->getEdit() == 0) {
						$ret = false;
					}
					break;
				case Xoonips_Enum::OP_TYPE_SEARCH:
					if ($this->getSearch() == 0) {
						$ret = false;
					}
					break;
				default:
					$ret = false;
					break;
			}
		}
		return $ret;
	}
	
	public function getList() {
		$ret = array();
		global $xoopsDB;
		$sql = 'select title_id,title from ' . $xoopsDB->prefix('user_field_value_set');
		$sql = $sql . " where select_name='" . $this->getListId() ."'";
		$sql = $sql . ' order by weight';
		$result = $xoopsDB->queryF($sql);
		while ($row = $xoopsDB->fetchArray($result)) {
			$ret[$row['title_id']] = $row['title'];				
	    }
	    return $ret;
	}
}

