<?php

/**
 * notification related functions
 * 
 */
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/inc/migrate_db.inc.php';

class notification{
  protected $db;
  protected $mid;

  private function get_mid() {
    $wktbl = get_tbl('modules');
    $sql = "select * from {$wktbl} where name='XooNIps'";
    $result_array = $this->db->query($sql);
    if($result_array === FALSE){
      errmsg(APP_MIGRATE, 'E3003');
      return false;
    }
    $this->mid =  $result_array[0]['mid'];
    return TRUE;
  }
  
  public function init($db){
    $this->db = $db;
    return $this->get_mid();
  }
  
  /**
   * Get old table datas.
   * 
   * @return mixed Success:array,Fail:false
   */
  protected function get_old_notification()
  {
    $wktbl = get_WK_tbl('xoopsnotifications');
    $sql = "select * from {$wktbl}";
    $result_array = $this->db->query($sql);
    if($result_array === FALSE){
      return false;
    }
    return $result_array;
  }
  
  /**
   * Datas insert to new table .
   * 
   * @return mixed Success:array,Fail:false
   */
  protected function insert_new_notification($insertdat) {
    $tbl = get_tbl('xoopsnotifications');
    $cat = $insertdat['not_category'];
    $event = $insertdat['not_event'];
    $uid   = $insertdat['not_uid'];
    $sql = "insert into {$tbl} (not_modid,not_category,not_event,not_uid) ".
           "VALUES({$this->mid},'{$cat}','{$event}',{$uid})";
    return $this->db->exec($sql);
  }


  public function migrate() {
    global $RUN_LOG;
    
    #Get old XooNips datas.
    $nots = $this->get_old_notification();
    if($nots === false){
      return -errmsg(APP_MIGRATE, 'E3001');
    }
    
    #Definition conversion rule.
    #Array key means  xoopsnotification['not_category']:xoopsnotification['not_event']
    #Array value means conversion result.
    # Array[0] means converted xoopsnotification['not_category'].
    # Array[1] means converted xoopsnotification['not_event'].
    # Array[2] means that it true set below (1) and (2) of same rule don't permit repeated conversion.
    $conv_rule = array(
      "administrator:item_transfer"              => array("common","item",true), #(1)
      "administrator:item_certify"               => array("common","item",true), #(2)
      "user:item_transfer"                       => array("user","item_transfer",false),
      "user:item_updated"                        => array("user","item_updated",false),        
      "user:file_downloaded"                     => array("user","file_downloaded",false)
      #other wise  does not prcess.
    );
    $conved_check_list = array(); #(1) or (2) already applyed check.
    foreach ($nots as $not) {
      #conversion 
      $idx = $not['not_category'].':'.$not['not_event'];
      if(array_key_exists($idx, $conv_rule) == true){
        $not['not_category'] = $conv_rule[$idx][0];
        $not['not_event'] = $conv_rule[$idx][1];
        if($conv_rule[$idx][2] === true){
          $not_uid = $not['not_uid'];
          if(array_key_exists($not_uid, $conved_check_list)==true){
            continue;
          }
          $conved_check_list[$not_uid] = true;
        }
        if($this->insert_new_notification($not) === false){
          return -errmsg(APP_MIGRATE, 'E3002');
        }
      }
    }
    return 0;
  }
}