<?php

/**
 * OAI-pMH related functions
 * 
 */

require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/inc/migrate_db.inc.php';

class oai_pmh{
  protected $db;

  public function init($db){
    $this->db = $db;
  }
  /**
   * xoops_config array 
   * 
   * @param array $config_array
   * @param string $key
   * @return mixed Success:string,Fail:FALSE
   */
  private function get_config(&$config_array,$key) {
    foreach ($config_array as $config) {
      if(strcmp($config['name'],$key)==0){
        return $config['value'];
      }
    }
    return FALSE;
  }


  /**
   * Can OAI-PMH migrate?
   * 
   * @return mixed Success:array,Fail:int 0,Query Error:-1
   */
  protected function can_migrate() {
    $wktbl = get_WK_tbl('xoonips_config');
    $sql = "select * from {$wktbl}";
    $config_array = $this->db->query($sql);
    if($config_array === FALSE){
      return -1;
    }
    foreach (array('repository_name','repository_nijc_code') as $value) {
      $result = $this->get_config($config_array,$value);
      if(is_string($result)){
        if(!is_null($result) && strlen($result) > 0 ){
          return $config_array;
        }
      }
    }
    return 0;
  }

  /**
   * xoonips_confit table migrate.
   * 
   * @param array $config_array
   * @return boolean Success:TRUE,Fail:FALSE
   */
  protected function migrate_config(&$config_array) {
    $tbl = get_tbl('xoonips_config');
    foreach (array('repository_deletion_track',
                  'repository_name',
                  'repository_nijc_code') as $name) {
      $value = $this->get_config($config_array,$name);
      $sql = "update {$tbl} set value='{$value}' where name='{$name}'";
      $rc = $this->db->exec($sql);
      if($rc === FALSE)return FALSE;
    }
    return TRUE;
  }
  
  /**
   * item_id get public index from xoonips_index,xoonips_index_item_link.
   * 
   * @return Success:item_ids array,Fail:False
   */
  protected function get_items(&$items_array)
  {
    $index = get_tbl('xoonips_index');
    $item_link = get_tbl('xoonips_index_item_link');
    $sql = "select distinct(item_id) from {$index} as index1,{$item_link} as item_link ".
            "where index1.index_id = item_link.index_id and open_level = 1";
    $items_array = $this->db->query($sql);
    if($items_array === FALSE){
      return FALSE;
    }
    return TRUE;
  }

  /**
   * xoonips_oaipmh_item_status create.
   * 
   * @return boolean Succes:TRUE,Fail:FALSE
   */
  protected function create_item_status() {
    $items_array = array();
    $rc = $this->get_items($items_array);
    if($rc === FALSE)return FALSE;
    $wk_tbl = get_tbl('xoonips_oaipmh_item_status');
    foreach ($items_array as $item_id) {
      $tm = time();
      $sql = "insert into {$wk_tbl} (item_id,timestamp,created_timestamp,is_deleted) ".
            "values({$item_id['item_id']},{$tm},{$tm},0)";
      $rc = $this->db->exec($sql);
      if($rc === FALSE)return FALSE;
    }
    return TRUE;
  }

  /**
   * OAI-PMH migrate
   * 
   * @return int Success:0,Fail:Negative Number
   */
  public function migrate() {
    $config_array = $this->can_migrate();
    if($config_array === 0){
      fprintf(STDERR,"OAI-PMH Config migrate skip.\n");
    }else if($config_array === -1){
      return -errmsg(APP_MIGRATE,'E1005');
    }else if(count($config_array)>0){
      #xoops_config migrate
      $rc = $this->migrate_config($config_array);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE,'E2701');
      }
    }
    
    #xoonips_oaipmh_item_status create.
    $rc = $this->create_item_status();
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE,'E2702');
    }
    return 0;
  }
}
