<?php
global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnpmodel extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }
  
  /**
   * Initialize 
   */
  public function init($db) {
    parent::init($db);
    $this->set_ng_item_name('Model');
    $this->add_file_mapping_array('model_data', 'files');
    $this->add_file_mapping_array('preview', 'preview');
    $this->add_file_mapping_array('preview', 'preview');
    $this->add_file_mapping_array('readme', 'readme');
    $this->add_file_mapping_array('rights', 'rights');    
    
    #Description migrate to ...
    $this->set_description('outline');
    
    #Duplicate Table
    $this->add_dup_table('xnpmodel_creator');
    $this->add_dup_table('xnpmodel_item_detail');
  }

  /**
   *
   * get xnpmodel_item_detail fields .
   * 
   * @param int $item_id
   * @return Success:Array includes fields, Fail:FALSE
   */
  protected function get_xnpmodel_item_detail($item_id) {
    $wktbl = get_WK_tbl('xnpmodel_item_detail');
    $sql = "select * from {$wktbl} where model_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0];
    }
    return FALSE;    
  }

  /**
   *
   * get xnpmodel_creator
   * 
   * @param int $item_id
   * @return Success:Array includes fields, Fail:FALSE 
   */
  protected function get_xnpmodel_creator($item_id){
    $wktbl = get_WK_tbl('xnpmodel_creator');
    $sql = "select * from {$wktbl} where model_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) > 0){
      return $result_array;
    }
    return FALSE;    
  }
  
  /**
   * XooNIps 3.46a item type model migrate to Next Generation XooNIps.
   * 
   * @param Success:0 Fail:Negative Number
   */
  public function migrate($item) {
    #xoonips_item
    $item_id = $item['item_id'];

    $item_detail = $this->get_xnpmodel_item_detail($item_id);
    if($item_detail === FALSE || $item_detail === null){
      return -errmsg(APP_MIGRATE, 'E1202',$item_id);
    }
    
    #model_type
    $model_array = $this->get_table_column_by_group('model_type',  $this->get_ng_item_name());
    if($model_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1203');
    }
    $rc = $this->insert_any($model_array, $item_id, $item_detail['model_type']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1204',$item_id);
    }
    
    #readme
    $readme_array = $this->get_table_column_by_group('readme',  $this->get_ng_item_name());
    if($readme_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1205');
    }
    $rc = $this->insert_any($readme_array, $item_id, $item_detail['readme']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1206',$item_id);
    }
    
    #rights
    $rights_array = $this->get_table_column_by_item('rights',  $this->get_ng_item_name());
    if($rights_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1207');
    }
    $rights = $this->make_rights($item_detail);
    $rc = $this->insert_any($rights_array,$item_id,  $rights);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1208',$item_id);
    }
    
    #attachment_dl_limit
    $attdl_array = $this->get_table_column_by_item('attachment_dl_limit',  $this->get_ng_item_name());
    if($attdl_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1209');
    }
    $rc = $this->insert_any($attdl_array,$item_id,$item_detail['attachment_dl_limit']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1210',$item_id);
    }
    
    #attachment_dl_notify
    $attnotify_array = $this->get_table_column_by_item('attachment_dl_notify',  $this->get_ng_item_name());
    if($attnotify_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1211');
    }
    $rc = $this->insert_any($attnotify_array,$item_id,$item_detail['attachment_dl_notify']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1212',$item_id);
    }
    
    #name
    $creaters_array = $this->get_table_column_by_group('creators',  $this->get_ng_item_name());
    if($creaters_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1213');
    }
    $creator   = $this->get_xnpmodel_creator($item_id);
    if($creator === FALSE){
      return -errmsg(APP_MIGRATE, 'E1201',$item_id);
    }
    foreach ($creator as $value) {
      $rc = $this->insert_any($creaters_array,$item_id,$value['creator'],$value['creator_order']+1);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E1214',$item_id);
      }     
    }

    return 0;
  }
}
