<?php
global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnptool extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }

  /**
   * Initialize 
   */
  public function init($db) {
    parent::init($db);
    $this->set_ng_item_name('Tool');
    $this->add_file_mapping_array('tool_data', 'files');
    $this->add_file_mapping_array('preview', 'preview');
    $this->add_file_mapping_array('readme', 'readme');
    $this->add_file_mapping_array('rights', 'rights');
    
    #Description migrate to ...
    $this->set_description('outline');
    
    #Duplicate Table
    $this->add_dup_table('xnptool_developer');
    $this->add_dup_table('xnptool_item_detail');
  }

  /**
   *
   * This function get xnptool_item_detail table info.
   * 
   * @param int $item_id
   * @return mixed Success:xnptool_item_detail Array includes fields, Fail:FALSE 
   */ 
  protected function get_xnptool_item_detail($item_id){
    $wktbl = get_WK_tbl('xnptool_item_detail');
    $sql = "select * from {$wktbl} where tool_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0];
    }
    return FALSE;    
  }

  /**
   *
   * This function get xnptool_developer table info.
   * 
   * @param int $item_id
   * @return mixed Success:xnptool_developer Array includes fields, Fail:FALSE 
   */
  protected function get_xnptool_developer($item_id){
    $wktbl = get_WK_tbl('xnptool_developer');
    $sql = "select * from {$wktbl} where tool_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) > 0){
      return $result_array;
    }
    return FALSE;    
  }
  
  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */
  public function migrate($item) {
    #xoonips_item
    $item_id = $item['item_id'];
    $item_detail = $this->get_xnptool_item_detail($item_id);
    if($item_detail === FALSE || $item_detail === null){
      return -errmsg(APP_MIGRATE, 'E1301',$item_id);
    }
    
    #tool type
    $tool_type_array = $this->get_table_column_by_item('tool_type',  $this->get_ng_item_name());
    if($tool_type_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1303');
    }
    $rc = $this->insert_any($tool_type_array,$item_id,$item_detail['tool_type']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1304',$item_id);
    }

    #readme
    $readme_array = $this->get_table_column_by_item('readme',  $this->get_ng_item_name());
    if($readme_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1305');
    }
    $rc = $this->insert_any($readme_array,$item_id,$item_detail['readme']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1306',$item_id);
    }
    
    #rights
    $rights_array = $this->get_table_column_by_item('rights',  $this->get_ng_item_name());
    if($rights_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1307');
    }
    $rights = $this->make_rights($item_detail);
     $rc = $this->insert_any($rights_array,$item_id,  $rights);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1308',$item_id);
    }
    
    #date
    $rc = $this->migrate_simple_date($item);
    if($rc < 0)return $rc;
    
    #attachment_dl_limit
    $attdl_array = $this->get_table_column_by_item('attachment_dl_limit',  $this->get_ng_item_name());
    if($attdl_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1309');
    }
    $rc = $this->insert_any($attdl_array,$item_id,$item_detail['attachment_dl_limit']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1310',$item_id);
    }
    
    #attachment_dl_notify
    $attnotify_array = $this->get_table_column_by_item('attachment_dl_notify',  $this->get_ng_item_name());
    if($attnotify_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1311');
    }
    $rc = $this->insert_any($attnotify_array,$item_id,$item_detail['attachment_dl_notify']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1312',$item_id);
    }
    
    #name
    $developer_array = $this->get_table_column_by_item('name',  $this->get_ng_item_name());
    if($developer_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1313');
    }
    $tool_developer_array   = $this->get_xnptool_developer($item_id);
    if($tool_developer_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1302',$item_id);
    }
    foreach ($tool_developer_array as $developer) {
      $rc = $this->insert_any($developer_array,$item_id,$developer['developer'],$developer['developer_order']+1);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E1314',$item_id);
      }      
    }
    return 0;
  }
}
