<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XLEPROGRESS_TRUST_PATH . '/class/AbstractEditAction.class.php';

/**
 * Xleprogress_HistoryEditAction
**/
class Xleprogress_HistoryEditAction extends Xleprogress_AbstractEditAction
{
	/**
	 * &_getHandler
	 * 
	 * @param	void
	 * 
	 * @return	Xleprogress_HistoryHandler
	**/
	protected function &_getHandler()
	{
		$handler =& $this->mAsset->getObject('handler', 'History');
		return $handler;
	}

	/**
	 * _checkStep
	 * 
	 * @param	void
	 * 
	 * @return	bool
	**/
	protected function _checkStep()
	{
		if(!is_array($this->mObject->mSteps) || count($this->mObject->mSteps)==0){
			return false;
		}
		return (in_array($this->mObject->mItem->get('step'), $this->mObject->mSteps)) ? true : false;
		
	}

	/**
	 * prepare
	 * 
	 * @param	void
	 * 
	 * @return	bool
	**/
	public function prepare()
	{
		parent::prepare();
		if($this->mObject->isNew()){
			$this->mObject->set('item_id', $this->mRoot->mContext->mRequest->getRequest('item_id'));
			$this->mObject->set('uid', Legacy_Utils::getUid());
			$this->mObject->set('step', $this->mObject->setMyStep());
		}
		$this->mObject->loadItem();
	    $this->mObject->mItem->loadType();
	    $this->mObject->loadMySteps();
		$this->mObject->mItem->loadHistory();
		$this->mActionForm->set('status', $this->mObject->mItem->get('status'));
		if(! $this->_checkStep()){
			$this->mRoot->mController->executeRedirect('./index.php?action=ItemList', 1, _MD_XLEPROGRESS_ERROR_NO_PERMISSION);
		}
	
		return true;
	}

	/**
	 * _setupActionForm
	 * 
	 * @param	void
	 * 
	 * @return	void
	**/
	protected function _setupActionForm()
	{
		$this->mActionForm =& $this->mAsset->getObject('form', 'History',false,'edit');
		$this->mActionForm->prepare();
	}

	/**
	 * _doExecute
	 * 
	 * @param	void
	 * 
	 * @return	Enum
	**/
	protected function _doExecute()
	{
		$iHandler = Legacy_Utils::getModuleHandler('item', $this->mAsset->mDirname);
		if($this->mObjectHandler->insert($this->mObject))
		{
			$result = false;
			if($this->mObject->get('result')==Xleprogress_Result::APPROVE){
				$result = $iHandler->proceedStep($this->mObject->mItem, $this->mObject->get('comment'));
			}
			else{
				$result = $iHandler->revertStep($this->mObject->mItem, $this->mObject->get('comment'));
			}
			if($result === true){
				return XLEPROGRESS_FRAME_VIEW_SUCCESS;
			}
			else if($result === false){					
					return XLEPROGRESS_FRAME_VIEW_ERROR;
			}
			else{
				$this->mActionForm->addErrorMessage($result);
				return XLEPROGRESS_FRAME_VIEW_ERROR;
			}
		}
		return XLEPROGRESS_FRAME_VIEW_ERROR;
	}

	/**
	 * executeViewInput
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewInput(/*** XCube_RenderTarget ***/ &$render)
	{
		$render->setTemplateName($this->mAsset->mDirname . '_history_edit.html');
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
		$render->setAttribute('dirname', $this->mAsset->mDirname);
		$result = '';
		XCube_DelegateUtils::call('Legacy_Workflow.GetDetailView', new XCube_Ref($result), $this->mObject->mItem->get('type_id'),$this->mObject->mItem->mType->get('module'),$this->mObject->mItem->get('target_id'));
		$render->setAttribute('detailview', $result);
		$render->setAttribute('status_request', Xleprogress_Result::REQUEST);
		$render->setAttribute('status_approve', Xleprogress_Result::APPROVE);
		$render->setAttribute('status_rject', Xleprogress_Result::REJECT);
	}

	/**
	 * executeViewSuccess
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewSuccess(/*** XCube_RenderTarget ***/ &$render)
	{
		$this->mRoot->mController->executeForward('./index.php?action=HistoryList&item_id=' . $this->mObject->get('item_id'));
	}

	/**
	 * executeViewError
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewError(/*** XCube_RenderTarget ***/ &$render)
	{
		$this->mRoot->mController->executeRedirect('./index.php?action=HistoryList&item_id=' . $this->mRoot->mContext->mRequest->getRequest('item_id'), 1, _MD_XLEPROGRESS_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * executeViewCancel
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewCancel(/*** XCube_RenderTarget ***/ &$render)
	{
		$this->mRoot->mController->executeForward('./index.php?action=HistoryList&item_id=' . $this->mRoot->mContext->mRequest->getRequest('item_id'));
	}
}
?>
