<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

class Xoonips_MaintenanceItemAction extends Xoonips_ActionBase {

	protected function doInit(&$request, &$response) {

		// breadcrumbs
		$breadcrumbs = array(
		  array(
		    'name' => _AM_XOONIPS_TITLE,
		    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
		  ),
		  array(
		    'name' => _AM_XOONIPS_MAINTENANCE_TITLE,
		    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/maintenance.php',
		  ),
		  array(
		    'name' => _AM_XOONIPS_MAINTENANCE_ITEM_TITLE,
		  ),
		);

		// menu
		$menu = array(
		  array(
		    'label' => _AM_XOONIPS_MAINTENANCE_ITEMDELETE_TITLE,
		  	 'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/maintenance_itemdelete.php',
		  ),
		);
		
		if (Xoonips_BeanFactory::chkXleprogress()) {
			$menu[] = array(
		    'label' => _AM_XOONIPS_MAINTENANCE_ITEMWITHDRAW_TITLE,
		  	'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/maintenance_itemwithdraw.php',
			);
		}
		
		$menu[] = array(
		    'label' => _AM_XOONIPS_MAINTENANCE_ITEMTRANSFER_TITLE,
		  	'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/maintenance_itemtransfer.php',
		);
		
		// get common viewdata
		$viewData = array();
		
		$viewData['menu'] = $menu;
		$viewData['breadcrumbs'] = $breadcrumbs;
		
		$response->setViewData($viewData);
		$response->setForward('init_success');

		return true;
	}
}

