<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';

/**
 * @brief operate xoonips_complement table
 *
 */
class Xoonips_ComplementBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function Xoonips_ComplementBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('complement', true);
	}

	/**
	 *
	 * get complement info
	 *
	 * @param
	 * @return array
	 */
	public function getComplementInfo() {
		$sql = 'SELECT * FROM ' . $this->table;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}

		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 *
	 * get complement detail info
	 *
	 * @param int $id complement_id
	 * @return array
	 */
	public function getComplementDetailInfo($id = NULL) {
		$table = $this->prefix($this->modulePrefix('complement_detail'));
		if (!is_null($id)) {
			$sql = "SELECT * FROM " . $table . " WHERE complement_id=".$id." ORDER BY complement_detail_id";
		} else {
			$sql = "SELECT * FROM " . $table . " ORDER BY complement_detail_id";
		}
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}

		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 *
	 * get complement list
	 *
	 * @param int $id $itemtypeid
	 * @return array
	 */
	public function getComplementList($itemtypeid) {
		$groupTable = $this->prefix($this->modulePrefix('item_field_group'));
		$detailTable = $this->prefix($this->modulePrefix('item_field_detail'));
		$tlinkTable = $this->prefix($this->modulePrefix('item_field_detail_complement_link'));

		$sql = "SELECT lt.complement_id, dt.item_field_detail_id, gt.group_id"
		. ", dt.name as detail_name , gt.name as group_name FROM $tlinkTable lt"
		. " LEFT JOIN $detailTable dt"
		. " ON lt.base_item_field_detail_id=dt.item_field_detail_id"
		. " LEFT JOIN $groupTable gt"
		. " ON lt.base_group_id=gt.group_id"
		. " WHERE lt.item_type_id=${itemtypeid}";
		
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$chk = true;
 			foreach ($ret as $ret_tmp) {
					if ($row['complement_id'] == $ret_tmp['complement_id']
						&& $row['group_id'] == $ret_tmp['group_id']
						&& $row['item_field_detail_id'] == $ret_tmp['item_field_detail_id']) {
						$chk = false;
						break;
					}
			}
			if ($chk) 	$ret[] = $row;		
		}

		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * insert complement
	 *
	 * @param array $complement
	 * @param int $insertId
	 * @return bool true:success,false:failed
	 */
	public function insert($complement, &$insertId) {
		$sql = "INSERT INTO $this->table (view_type_id, title, module)";
		$sql .= ' VALUES(' . Xoonips_Utils::convertSQLNum($complement['view_type_id']);
		$sql .=  ',' . Xoonips_Utils::convertSQLStr($complement['title']);
		$sql .=  ',' . Xoonips_Utils::convertSQLStr($complement['module']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$insertId = $this->getInsertId();
		return true;
	}

	/**
	 * insert complement detail
	 *
	 * @param array $detail
	 * @param int $insertId
	 * @return bool true:success,false:failed
	 */
	public function insertDetail($detail, &$insertId) {
		$detailTable = $this->prefix($this->modulePrefix('complement_detail'));
		$sql = "INSERT INTO $detailTable (complement_id, code, title)";
		$sql .= ' VALUES(' . Xoonips_Utils::convertSQLNum($detail['complement_id']);
		$sql .=  ',' . Xoonips_Utils::convertSQLStr($detail['code']);
		$sql .=  ',' . Xoonips_Utils::convertSQLStr($detail['title']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$insertId = $this->getInsertId();
		return true;
	}
}

