<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
/**
 * @brief operate xoonips_item_type_search_condition_detail table
 *
 */
class Xoonips_ItemTypeSearchConditionDetailBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function Xoonips_ItemTypeSearchConditionDetailBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('item_type_search_condition_detail', true);
	}

	/**
	 * select search condition detail
	 *
	 * @param $condId condition_id
	 * @return array
	 */
	public function select($condId) {
		$ret = array();
		$condId = Xoonips_Utils::convertSQLNum($condId);
		$sql = 'SELECT * FROM ' . $this->table . " WHERE condition_id=" . $condId;
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * select search condition detail
	 *
	 * @param $condId condition_id
	 * @param $itemtypeId item_type_id
	 * @return array
	 */
	public function selectByItemtypeId($condId, $itemtypeId) {
		$ret = array();
		$condId = Xoonips_Utils::convertSQLNum($condId);
		$itemtypeId = Xoonips_Utils::convertSQLNum($itemtypeId);
		$sql = 'SELECT * FROM ' . $this->table . " WHERE condition_id=" . $condId ." AND item_type_id=" . $itemtypeId;
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * delete search condition detail
	 *
	 * @param int $condId condition_id
	 * @return bool true:success,false:failed
	 */
	public function delete($condId) {
		$condId = Xoonips_Utils::convertSQLNum($condId);
		$sql = 'DELETE FROM ' . $this->table . " WHERE condition_id=" . $condId;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * delete search condition detail
	 *
	 * @param int $condId condition_id, $itemtypeId itemtype id
	 * @return bool true:success,false:failed
	 */
	public function deleteByItemtypeId($condId, $itemtypeId) {
		if (is_null($condId)) {
			$itemtypeId = Xoonips_Utils::convertSQLNum($itemtypeId);
			$sql = 'DELETE FROM ' . $this->table . " WHERE item_type_id=" . $itemtypeId;
		} else {
			$condId = Xoonips_Utils::convertSQLNum($condId);
			$itemtypeId = Xoonips_Utils::convertSQLNum($itemtypeId);
			$sql = 'DELETE FROM ' . $this->table . " WHERE condition_id=" . $condId. " AND item_type_id=" . $itemtypeId;
		}
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * delete search condition detail
	 *
	 * @param int $condId condition_id, $detailId detail id
	 * @return bool true:success,false:failed
	 */
	public function deleteByDetailId($condId, $detailId=0) {
		$condId = Xoonips_Utils::convertSQLNum($condId);
		$detailId = Xoonips_Utils::convertSQLNum($detailId);
		$sql_detail = "";
		if ($detailId > 0) $sql_detail = " AND item_field_detail_id=" . $detailId;
		$sql = 'DELETE FROM ' . $this->table . " WHERE condition_id=" . $condId . $sql_detail;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * select search quicksearch detail
	 *
	 * @param $itemFieldDetailId
	 * @return array
	 */
	public function getQuickSearchDetail($itemFieldDetailId) {
		$ret = false;
		$itemFieldDetailId = Xoonips_Utils::convertSQLNum($itemFieldDetailId);
		$sql = 'SELECT * FROM ' . $this->table . " WHERE item_field_detail_id=" . $itemFieldDetailId;
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret = true;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * insert search condition detail
	 *
	 * @param $info
	 * @return bool true:success,false:failed
	 */
	public function insert($info) {
		$conditionId = Xoonips_Utils::convertSQLNum($info['condition_id']);
		$itemTypeId = Xoonips_Utils::convertSQLNum($info['item_type_id']);
		$itemFieldDetailId = Xoonips_Utils::convertSQLNum($info['item_field_detail_id']);
		$sql = 'INSERT INTO ' . $this->table . ' ( condition_id, item_type_id, item_field_detail_id ) '
			. '  VALUE (' . $conditionId . ',' . $itemTypeId . ',' . $itemFieldDetailId . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}
}

