<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once dirname(dirname(__FILE__)) . '/core/Item.class.php';

class Xoonips_WorkflowPublicItems extends Xoonips_WorkflowBase {

	public function doCertify($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		list($itemId, $indexId) = $this->getItemAndIndexId($indexItemLinkId, $indexItemLinkBean);
		if ($itemId == 0 || !$indexItemLinkBean->update($indexId, $itemId, XOONIPS_CERTIFIED)) {
			return;
		}
		$itemStatusBean = Xoonips_BeanFactory::getBean('OaipmhItemStatusBean', $this->dirname, $this->trustDirname);		
		if (!$itemStatusBean->updateItemStatus($itemId)) {
			$indexItemLinkBean->update($indexId, $itemId, XOONIPS_CERTIFY_REQUIRED);
			return;
		}
				
		$result[0] = true;
		//event log
		$this->log->recordCertifyItemEvent($itemId, $indexId);
		
		//send to item user
		$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $this->dirname, $this->trustDirname);
		$itemUsersInfo = $itemUsersBean->getItemUsersInfo($itemId);
		$sendToUsers = array();
		foreach ($itemUsersInfo as $itemUser) {
			$sendToUsers[$itemUser['uid']] = $itemUser['uid'];
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyPublicItems($this->dirname), new XCube_Ref($sendToUsers));
		$this->notification->itemCertified($itemId, $indexId, $sendToUsers, $comment);		
	}

	public function doProgress($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		list($itemId, $indexId) = $this->getItemAndIndexId($indexItemLinkId, $indexItemLinkBean);
		if ($itemId == 0) {
			return;
		}
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', Xoonips_Enum::certifyPublicItems($this->dirname), $indexItemLinkId, new XCube_Ref($sendToUsers));
		$this->notification->itemCertifyRequest($itemId, $indexId, $sendToUsers);
		$result[0] = true;
	}

	public function doRefuse($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		list($itemId, $indexId) = $this->getItemAndIndexId($indexItemLinkId, $indexItemLinkBean);
		if ($itemId == 0 || !$indexItemLinkBean->deleteByid($indexId, $itemId)) {
			return;
		}
		
		$result[0] = true;
		//event log
		$this->log->recordRejectItemEvent($itemId, $indexId);
		
		//send to item user
		$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $this->dirname, $this->trustDirname);
		$itemUsersInfo = $itemUsersBean->getItemUsersInfo($itemId);
		$sendToUsers = array();
		foreach ($itemUsersInfo as $itemUser) {
			$sendToUsers[$itemUser['uid']] = $itemUser['uid'];
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyPublicItems($this->dirname), new XCube_Ref($sendToUsers));
		$this->notification->itemRejected($itemId, $indexId, $sendToUsers, $comment);
	}
	
	public function getDetailView($indexItemLinkId) {
		$indexItemLinkBean = null;
		list($itemId, $indexId) = $this->getItemAndIndexId($indexItemLinkId, $indexItemLinkBean);
		if ($itemId == 0) {
			return false;
		}
		$itemBasicBean = Xoonips_BeanFactory::getBean('ItemBean', $this->dirname, $this->trustDirname);
		$itemBasicInfo = $itemBasicBean->getItemBasicInfo($itemId);
		$itemTypeId = $itemBasicInfo['item_type_id'];
		$itemType = new Xoonips_Item($itemTypeId, $this->dirname, $this->trustDirname);
		$itemType->setTemplate($this->dirname . '_itemtype.html');
		global $xoopsTpl;
		$xoopsTpl->assign('detailView', $itemType->getDetailView($itemId, $indexId, false));
		return $xoopsTpl->fetch('db:'. $this->dirname . '_workflow.html');
	}

	public function getItemAndIndexId($indexItemLinkId, &$indexItemLinkBean) {
		$indexItemLinkBean = Xoonips_BeanFactory::getBean('IndexItemLinkBean', $this->dirname, $this->trustDirname);
		$indexItemLinkInfo = $indexItemLinkBean->getIndexItemLinkInfoByIndexItemLinkId($indexItemLinkId);
		if (!$indexItemLinkInfo) {
			return array(0, 0);
		}
		return array($indexItemLinkInfo['item_id'], $indexItemLinkInfo['index_id']);
	}
}

