<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

abstract class control_base {
  protected $uid;
  protected $user;
  const resurl = 'http://xoonips.sourceforge.jp/rest/general/';
  const defurl = 'http://www.w3.org/2000/xmlns/';
  const resprefix = 'G:';
  const resxmlns = 'xmlns:G';
  
  /**
   *itemget and another xml common routine.
   * 
   * @param object $respons_data dom object
   * @param int $code http response code
   * @param int $item_id ITEM ID
   * @param string $response responsedescription
   * @param string $xml  if exist xml ,include xml.
   */
  protected function mk_xml_ele($code, $item_id, $append_dom, $responsedescription, &$domdoc, &$respons_data) {

    // insert errmsg
    if ($code != 0) {
      $msg = get_code_msg($code);
      if (is_null($msg))
        return null;
      $respons_data->appendChild($domdoc->createElementNS(self::resurl,self::resprefix.'code','HTTP/1.1 '.$code.' '.$msg));
    }
    
    if ($item_id != -1) {
      $respons_data->appendChild($domdoc->createElementNS(self::resurl,self::resprefix.'request_id', $item_id));
    }
    
    // insert xmldomobj
    // insert responsedescription
    if (!is_null($responsedescription)) {
      $respons_data->appendChild($domdoc->createElementNS(self::resurl,self::resprefix.'result', $responsedescription));
    }else if (!is_null($append_dom)) {
      $dom_copy = $domdoc->importNode($append_dom->documentElement, true);
      $resultdom = $domdoc->createElementNS(self::resurl,self::resprefix.'result');
      $respons_data->appendChild($resultdom);
      $resultdom->appendChild($dom_copy);
    }    
  }

  /**
   * Create Xml response
   *
   * @param int $code http response code
   * @param int $item_id ITEM ID
   * @param string $response responsedescription
   * @param string $xml  if exist xml ,include xml.
   * @return boolean
   */
  protected function mk_response_xml($code = 0, $item_id = -1, $dom = null, $responsedescription = null) {
    $domdoc = new DOMDocument('1.0');
    $domdoc->encodeing = 'UTF-8';
    $domdoc->formatOutput = true;
    $root = $domdoc->createElementNS(self::resurl, self::resprefix.'status');
    $root->setAttributeNS(self::defurl, self::resxmlns, self::resurl);
    $respons_data = $domdoc->appendChild($root);
    
    $this->mk_xml_ele($code, $item_id, $dom, $responsedescription, $domdoc, $respons_data);
    
    return $domdoc->saveXML();
  }
  
  public function set_uid($uid) {
    $this->uid = $uid;
  }
  
  public function set_user($user) {
    $this->user = $user;
  }
  
  protected function rest_notify_err($code, $str, $item_id = -1) {
    res_code($code, null, true);
    $xml = $this->mk_response_xml($code, $item_id, null, $str);
    echo $xml;
    exit();
  }
 
  /**
   * GET DB language
   * 
   * @return UTF-8:'UTF-8' string,EUC:'EUC-JP' other:NULL
   */
  protected function get_db_lang() {
    $db = $GLOBALS['xoopsDB'];
    $rc = $db->queryF('show create database '.$db->prefix);
    $result_arr = $db->fetchArray($rc);
    $dbstr = $result_arr['Create Database'];
    if (stripos($dbstr,"utf8") !== false) {
      return 'UTF-8';
    } else if (stripos($dbstr, 'euc') !== false || stripos($dbstr, 'ujis') !== false) {
      return 'EUC-JP';
    }
    return null;
  }
  abstract public function init();
  abstract public function run($req);
}
