<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . '/class/AbstractDeleteAction.class.php';
require_once USER_TRUST_PATH . '/admin/forms/GroupAdminDeleteForm.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Errors.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';
require_once USER_TRUST_PATH . '/class/core/User.class.php';

class User_GroupDeleteAction extends User_AbstractDeleteAction
{
	function _getId()
	{
		return xoops_getrequest('groupid');
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('groups');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm = new User_GroupAdminDeleteForm();
		$this->mActionForm->prepare();
	}
	
	function _doExecute()
	{
		$handler =& xoops_gethandler('group');
		$group =& $handler->get($this->mObject->get('groupid'));
		
		if ($group->get('group_type') != Xoonips_Enum::GROUP_TYPE) {
			$handler =& xoops_gethandler('member');
		
			if (!$handler->delete($group)) {
				return false;
			}
			
			$handler =& xoops_gethandler('groupperm');
			if (!$handler->deleteByGroup($this->mObject->get('groupid'))) {
				return false;
			}
		} else {
	        $root =& XCube_Root::getSingleton();
			$render = $root->mContext->mModule->getRenderTarget();
			$groupbean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
			$group = $groupbean->getGroup($this->mObject->get('groupid'));
			if ($group['activate'] == Xoonips_Enum::GRP_DELETE_REQUIRED) {
				return false;
			}
	  		$transaction = Xoonips_Transaction::getInstance();
  			$transaction->start();
			$user = User_User::getInstance();
			$message = '';
			if (!$user->doGroupDelete($group, $message)) {
				// workflow not configured
				if (is_array($message)) {
					$errors = new Xoonips_Errors();
					$errors->addError($message[1], 'workflow', null, false);
					$render->setAttribute('errMsg', $errors->getView($this->dirname));
				} else {
					$render->setAttribute('errMsg', $message);
				}
				$transaction->rollback();
				return false;
			}
			$transaction->commit();
		}
		
		return true;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		if ($this->mObject->get('group_type') == Xoonips_Enum::GROUP_TYPE) {
			$groupbean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
			$group = $groupbean->getGroup($this->mObject->get('groupid'));
			if ($group['activate'] == Xoonips_Enum::GRP_DELETE_REQUIRED) {
				$render->setAttribute('deleteRequired', true);
			}
		}
		$render->setTemplateName("group_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=groupList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		if ($render->getAttribute('errMsg')) {
			$controller->executeRedirect("./index.php?action=groupList", 1, $render->getAttribute('errMsg'));
		} else {
			$controller->executeRedirect("./index.php?action=groupList", 1, _MD_USER_ERROR_DBUPDATE_FAILED);
		}
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=groupList");
	}
}


