<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';

class User_UserValueSetSubAction extends User_ActionBase {
	protected function doInit(&$request, &$response) {
		$select_name = $request->getParameter2('select_name');
		$title_id_db = $request->getParameter2('title_id_db');
		$canIdEdit = $request->getParameter('canIdEdit');
		$mode = $request->getParameter('mode');
		$title_id = $request->getParameter2('title_id');
		$title = $request->getParameter2('title');
		if (_CHARSET != 'UTF-8') {
			$select_name = mb_convert_encoding($select_name, _CHARSET, 'utf-8');
			$title_id_db = mb_convert_encoding($title_id_db, _CHARSET, 'utf-8');
			$title_id = mb_convert_encoding($title_id, _CHARSET, 'utf-8');
			$title = mb_convert_encoding($title, _CHARSET, 'utf-8');
		}

		if (is_null($title_id_db)) {
			$title_id_db = $title_id;
		}

		//mode 2:edit 4:delete
		if ($mode == 2 || $mode == 4) {
			$userValueSetBean= Xoonips_BeanFactory::getBean('UserFieldValueSetBean', $this->dirname, $this->trustDirname);
			$userValueSet = $userValueSetBean->getInfo($select_name, $title_id);	
			$title = $userValueSet['title'];
			if (is_null($canIdEdit) && $mode == 2) {
				if ($userValueSetBean->checkUsedTitleId($select_name, $title_id) > 0) {
					$canIdEdit = false;
				}
			}	
			//$select_name = $userValueSet['select_name'];
		}

		if (is_null($canIdEdit)) {
			if ($mode == 4) {
				$canIdEdit = false;
			} else {
				$canIdEdit = true;
			}
		}

		$token_ticket = $this->createToken('user_value_set_sub');
		$viewData['token_ticket'] = $token_ticket;
		$viewData['select_name'] = $select_name;
		$viewData['title_id_db'] = $title_id_db;
		$viewData['mode'] = $mode;
		$viewData['canIdEdit'] = $canIdEdit;
		$viewData['title_id'] = $title_id;
		$viewData['title'] = $title;
		$viewData['dirname'] = $this->dirname;
		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}
	
	protected function doUpdate(&$request,&$response) {
		if (!$this->validateToken('user_value_set_sub')) {
			$response->setSystemError('Ticket error');
	        return false;
	    }

		$userValueSetBean = Xoonips_BeanFactory::getBean('UserFieldValueSetBean', $this->dirname, $this->trustDirname);

		//get parameter
		$mode = $request->getParameter('mode');
		$select_name = $request->getParameter2('select_name');
		$title_id_db = $request->getParameter2('title_id_db');
		$canIdEdit = $request->getParameter('canIdEdit');
		$title_id = $request->getParameter2('title_id');
		$title = trim($request->getParameter2('title'));
		if (_CHARSET != 'UTF-8') {
			$select_name = mb_convert_encoding($select_name, _CHARSET, 'utf-8');
			$title_id_db = mb_convert_encoding($title_id_db, _CHARSET, 'utf-8');
			$title_id = mb_convert_encoding($title_id, _CHARSET, 'utf-8');
			$title = mb_convert_encoding($title, _CHARSET, 'utf-8');
		}
		$select_name = trim($select_name);
		$title = trim($title);

   		$viewData = array();
		$viewData['dirname'] = $this->dirname;
	    $viewData['callbackvalue'] = $mode;
   		$userValueSet = array();
	    //if mode is not delete, input check
	    if ($mode != 4) {
	    	$errors = new Xoonips_Errors();	
			if ($title == '') {
				$parameters[] = _AD_USER_LANG_NAME;
				$errors->addError('_AD_USER_ERROR_REQUIRED', 'title', $parameters);
			}
			if (strlen($title) > 255 ) {
				$parameters[] = _AD_USER_LANG_NAME;
				$parameters[] = 255;
				$errors->addError('_AD_USER_ERROR_MAXLENGTH', 'title', $parameters);
			}
	    	if ($title_id == '') {
				$parameters[] = _AD_USER_LANG_ID;
				$errors->addError('_AD_USER_ERROR_REQUIRED', 'title_id', $parameters);
			}
			if (strlen($title_id) > 30 ) {
				$parameters[] = _AD_USER_LANG_ID;
				$parameters[] = 30;
				$errors->addError('_AD_USER_ERROR_MAXLENGTH', 'title_id', $parameters);
			}
			if ($errors->hasError()) {
				$this->doInputError($response, $viewData, $select_name,
						$title_id_db, $canIdEdit, $mode, $title_id, $title, $errors);
				return true;
			}
	    }

		//new mode
		if ($mode == 1) {
			if ($select_name == '') {
				$response->setSystemError(_AD_USER_ERROR_SELECT_NAME_REQUIRED);
				return false;
			}
			$userValueSet = $userValueSetBean->getValue($select_name);
			if (!$userValueSet) {
				$userValueSet['select_name'] = $select_name;
				$userValueSet['title_id'] = $title_id;
				$userValueSet['title'] = $title;
				$userValueSet['weight'] = 1;
				$result=$userValueSetBean->insertValue($userValueSet);
				if (!$result) {
					$response->setSystemError(_AD_USER_ERROR_DBUPDATE_FAILED);
					return false;
				}
			} else {
				if ($userValueSetBean->checkTitle($select_name, $title)) {
					$parameters[] = null;
					$errors->addError('_AD_USER_ERROR_TITLE_EXISTS', 'title', $parameters);	
				}
				if ($userValueSetBean->checkTitleId($select_name, $title_id)) {
					$parameters[] = null;
					$errors->addError('_AD_USER_ERROR_TITLE_ID_EXISTS', 'title_id', $parameters);	
				}		
				if ($errors->hasError()) {
					$this->doInputError($response, $viewData, $select_name, $title_id_db,
							$mode, $canIdEdit, $title_id, $title, $errors);
					return true;
				}
				$response->setSystemError(_AD_USER_ERROR_SELECT_NAME_EXISTS);
				return false;
			}
			$viewData['callbackvalue'] = 3;
		}else if($mode == 2){//edit mode
			$userValueSet = $userValueSetBean->getInfo($select_name, $title_id_db);
			$select_name = $userValueSet['select_name'];
			if ($userValueSet['title'] != $title) {
				if ($userValueSetBean->checkTitle($select_name, $title)) {
					$parameters[] = null;
					$errors->addError('_AD_USER_ERROR_TITLE_EXISTS', 'title', $parameters);
				}	
			}
			if ($userValueSet['title_id'] != $title_id) {
				if ($userValueSetBean->checkTitleId($select_name, $title_id)) {
					$parameters[] = null;
					$errors->addError('_AD_USER_ERROR_TITLE_ID_EXISTS', 'title', $parameters);
				}	
			}
			if ($errors->hasError()) {
				$this->doInputError($response, $viewData, $select_name, $title_id,
						$mode, $canIdEdit, $title_id, $title, $errors);
				return true;
			}	
			$userValueSet['title_id_db'] = $userValueSet['title_id'];
			$userValueSet['title'] = $title;
			$userValueSet['title_id'] = $title_id;

			$result = $userValueSetBean->updateValue($userValueSet);
			if (!$result) {
				$response->setSystemError(_AD_USER_ERROR_DBUPDATE_FAILED);
				return false;
			}
		} elseif ($mode == 3) {//add mode
			if ($userValueSetBean->checkTitle($select_name, $title)) {
				$parameters[] = null;
				$errors->addError('_AD_USER_ERROR_TITLE_EXISTS', 'title', $parameters);
			}	
			if ($userValueSetBean->checkTitleId($select_name, $title_id)) {
				$parameters[] = null;
				$errors->addError('_AD_USER_ERROR_TITLE_ID_EXISTS', 'title', $parameters);
			}	
			if ($errors->hasError()) {
				$this->doInputError($response, $viewData, $select_name, $title_id,
						$mode, $canIdEdit, $title_id, $title, $errors);
				return true;
			}
			//insert user value set
			//$title_id = $userValueSetBean->getMax($select_name, 'title_id');
			$weight = $userValueSetBean->getMax($select_name, 'weight');
			$userValueSet['select_name'] = $select_name;
			$userValueSet['title_id'] = $title_id;
			$userValueSet['title'] = $title;
			$userValueSet['weight'] = $weight + 1;
			$result = $userValueSetBean->insertValue($userValueSet);
			if (!$result) {
				$response->setSystemError(_AD_USER_ERROR_DBUPDATE_FAILED);
				return false;
			}
		} elseif ($mode == 4) {//delete mode
			$viewData['callbackid'] = $title_id;
			$viewData['callbackvalue'] = $mode;
		}
		$response->setViewData($viewData);
		$response->setForward('update_success');
		return true;
	}

	private function doInputError(&$response, $viewData, $select_name, $title_id_db,
			$canIdEdit,	$mode, $title_id, $title, $errors) {
		$token_ticket = $this->createToken('user_value_set_sub');
		$viewData['token_ticket'] = $token_ticket;
		$viewData['mode'] = $mode;
		$viewData['select_name'] = $select_name;
		$viewData['title_id_db'] = $title_id_db;
		$viewData['canIdEdit'] = $canIdEdit;
		$viewData['title_id'] = $title_id;
		$viewData['title'] = $title;
		$viewData['errors'] = $errors->getView($this->dirname);
		$response->setViewData($viewData);
		$response->setForward('input_error');
	}
}

