<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * User_Module
**/
class User_Module extends Legacy_ModuleAdapter
{
    /**
     * @brief   string
    **/
    public $mActionName = null;

    /**
     * @brief   User_AbstractAction
    **/
    public $mAction = null;

    /**
     * @brief   bool
    **/
    public $mAdminFlag = false;

    /**
     * @brief   User_AssetManager
    **/
    public $mAssetManager = null;

    /**
     * @brief   string
    **/
    protected $_mPreferenceEditUrl = null;

    /**
     * @brief   string
    **/
    protected $_mHelpViewUrl = null;

    /**
     * @brief   Enum[]
    **/
    
	function User_Module(&$xoopsModule)
	{
		parent::Legacy_ModuleAdapter($xoopsModule);
		$this->mGetAdminMenu =new XCube_Delegate();
		$this->mGetAdminMenu->register('User_Module.getAdminMenu');
	}

	/**
     * startup
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function startup()
    {
        parent::startup();
    
        XCube_DelegateUtils::call('Module.user.Global.Event.GetAssetManager',new XCube_Ref($this->mAssetManager),$this->mXoopsModule->get('dirname'));
   
        //
        // TODO/Insert your initialization code.
        //
    }

    /**
     * setAdminMode
     * 
     * @param   bool  $flag
     * 
     * @return  void
    **/
    public function setAdminMode(/*** bool ***/ $flag)
    {
        $this->mAdminFlag = $flag;
    }

    /**
     * _getDefaultActionName
     * 
     * @param   void
     * 
     * @return  string
    **/
    private function _getDefaultActionName()
    {
        // TODO insert your default action name
        return 'UserList';
    }

    /**
     * setActionName
     * 
     * @param   string  $name
     * 
     * @return  void
    **/
    public function setActionName(/*** string ***/ $name)
    {
        $this->mActionName = $name;
    }

    /**
     * getRenderSystemName
     * 
     * @param   void
     * 
     * @return  string
    **/
    public function getRenderSystemName()
    {
        if(!$this->mAdminFlag)
        {
            return parent::getRenderSystemName();
        }
    
        // TODO will be use site config
        if(!defined('USER_ADMIN_RENDER_REGISTED'))
        {
            define('USER_ADMIN_RENDER_REGISTED',true);
            $root =& XCube_Root::getSingleton();
            $root->overrideSiteConfig(
                array(
                    'RenderSystems' => array(
                        'User_AdminRenderSystem' => 'User_AdminRenderSystem'
                    ),
                    'User_AdminRenderSystem' => array(
                        'root' => USER_TRUST_PATH,
                        'path' => '/admin/class/AdminRenderSystem.class.php',
                        'class' => 'User_AdminRenderSystem'
                    )
                )
            );
        }
    
        return 'User_AdminRenderSystem';
    }

    /**
     * getAdminMenu
     * 
     * @param   void
     * 
     * @return  {string 'title',string 'link',string 'keywords',bool 'show',bool 'absolute'}[]
    **/
    public function getAdminMenu()
    {
        if(is_array($this->mAdminMenu))
        {
            return $this->mAdminMenu;
        }
    
        $root =& XCube_Root::getSingleton();
    
        // load admin menu
        require_once USER_TRUST_PATH . '/admin/menu.php';
        if(!is_array($adminmenu))
        {
            $adminmenu = array();
        }
    
        // add preference menu
        if($url = $this->getPreferenceEditUrl())
        {
            $adminmenu[] = array(
                'title'    => _PREFERENCES,
                'link'     => $url,
                'absolute' => true
            );
        }
    
        // add help menu
        if($url = $this->getHelpViewUrl())
        {
            $adminmenu[] = array(
                'title'    => _HELP,
                'link'     => $url,
                'absolute' => true
            );
        }
    
        $this->mAdminMenu = array();
        foreach($adminmenu as $menu)
        {
            if(!(isset($menu['absolute']) && $menu['absolute']))
            {
                $menu['link'] = XOOPS_MODULE_URL . '/' . $this->mXoopsModule->get('dirname') . '/' . $menu['link'];
            }
            $this->mAdminMenu[] = $menu;
        }
    
        return $this->mAdminMenu;
    }

    /**
     * getPreferenceEditUrl
     * 
     * @param   void
     * 
     * @return  string
    **/
    public function getPreferenceEditUrl()
    {
        if($this->_mPreferenceEditUrl === null)
        {
            if(is_array($this->mXoopsModule->getInfo('config')) && count($this->mXoopsModule->getInfo('config')) > 0)
            {
                $root =& XCube_Root::getSingleton();
                $this->_mPreferenceEditUrl = $root->mController->getPreferenceEditUrl($this->mXoopsModule);
            }
            else
            {
                $this->_mPreferenceEditUrl = false;
            }
        }
    
        return $this->_mPreferenceEditUrl;
    }

    /**
     * getHelpViewUrl
     * 
     * @param   void
     * 
     * @return  string
    **/
    public function getHelpViewUrl()
    {
        if($this->_mHelpViewUrl === null)
        {
            if($this->mXoopsModule->hasHelp())
            {
                $root =& XCube_Root::getSingleton();
                $this->_mHelpViewUrl = $root->mController->getHelpViewUrl($this->mXoopsModule);
            }
            else
            {
                $this->_mHelpViewUrl = false;
            }
        }
    
        return $this->_mHelpViewUrl;
    }

}


