<?php
global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnpdata extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }
  
  /**
   * Initialize 
   */
  public function init() {
    parent::init();
    $this->set_ng_item_name('Data');
    $this->add_file_mapping_array('data_file', 'files');
    $this->add_file_mapping_array('preview', 'preview');
    $this->add_file_mapping_array('readme', 'readme');
    $this->add_file_mapping_array('rights', 'rights');
    
    #Description migrate to ...
    $this->set_description('outline');
    
    #Duplicate Table
    $this->add_dup_table('xnpdata_experimenter');
    $this->add_dup_table('xnpdata_item_detail');
  }
  
  /**
   *
   * This function get get_xnpdata_item_detail table info.
   * 
   * @param int $item_id
   * @return Success:get_xnpdata_item_detail Array includes fields, Fail:FALSE 
   */
  protected function get_xnpdata_item_detail($item_id){
    $tbl = get_WK_tbl('xnpdata_item_detail');
    $sql = "select * from {$tbl} where data_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0];
    }
    return FALSE;    
  }
  
  /**
   *
   * This function get xnpdata_experimenter table info.
   * 
   * @param int $item_id
   * @return Success:xnpdata_experimenter Array includes fields, Fail:FALSE 
   */  
  protected function get_xnpdata_experimenter($item_id){
    $tbl = get_WK_tbl('xnpdata_experimenter');
    $sql = "select * from {$tbl} where data_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) > 0){
      return $result_array;
    }
    return FALSE;    
  }
  
  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */
  public function migrate($item) {
    #xoonips_item
    $item_id = $item['item_id'];
    $item_detail = $this->get_xnpdata_item_detail($item_id);
    if($item_detail === FALSE || $item_detail === null){
      return -errmsg(APP_MIGRATE, 'E2201',$item_id);
    }

    #data_type
    $data_type_array = $this->get_table_column_by_item('data_type');
    if($data_type_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2203');
    }
    $rc = $this->insert_any($data_type_array,$item_id,$item_detail['data_type']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2204',$item_id);
    }

    #readme
    $readme_array = $this->get_table_column_by_group('readme');
    if($readme_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2205');
    }
    $rc = $this->insert_any($readme_array,$item_id,$item_detail['readme']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2206',$item_id);
    }
    
    #rights
    $rights_array = $this->get_table_column_by_group('rights');
    if($rights_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2207');
    }
    $rights = $this->make_rights($item_detail);
    $rc = $this->insert_any($rights_array,$item_id,  $rights);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2208',$item_id);
    }
    
    #date
    $rc = $this->migrate_simple_date($item);
    if($rc < 0)return $rc;
    
    #attachment_dl_limit
    $attdl_array = $this->get_table_column_by_item('attachment_dl_limit');
    if($attdl_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2209');
    }
    $rc = $this->insert_any($attdl_array,$item_id,$item_detail['attachment_dl_limit']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2210',$item_id);
    }
    
    #attachment_dl_notify
    $attnotify_array = $this->get_table_column_by_item('attachment_dl_notify');
    if($attnotify_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2211');
    }
    $rc = $this->insert_any($attnotify_array,$item_id,$item_detail['attachment_dl_notify']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2212',$item_id);
    }
    
    #experimenter
    $experimenters_array = $this->get_table_column_by_group('experimenters');
    if($experimenters_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2213');
    }
    $expimenter = $this->get_xnpdata_experimenter($item_id);
    if($expimenter === FALSE){
      return -errmsg(APP_MIGRATE, 'E2202',$item_id);
    }    
    foreach ($expimenter as $value) {
      $rc = $this->insert_any($experimenters_array,$item_id,$value['experimenter'],$value['experimenter_order']+1);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E2214',$item_id);
      }
    }

    return 0;
  }
}
