<?php
global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnpfiles extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }

  /**
   * Initialize 
   */
  public function init() {
    parent::init();
    $this->set_ng_item_name('File');
    $this->add_file_mapping_array('files_file', 'files');
    #Description migrate to ...
    $this->set_description('outline');
        
    #Duplicate Table
    $this->add_dup_table('xnpfiles_item_detail');
  }

  /**
   *xnpfiles_item_detail migrate to xoonips_item_file.
   * 
   * @param int $item_id itemid
   * @return boolean Success:true,Fail:false
   */
  protected function xnpfiles_item_detail($item_id) {
    $tbl   = get_tbl('xoonips_item_file');
    $wktbl = get_WK_tbl('xnpfiles_item_detail');
    $sql = "insert into {$tbl} (item_id,original_file_name,mime_type,search_module_name) ".
          "select files_id,data_file_name,data_file_mimetype,data_file_filetype from {$wktbl} where files_id={$item_id}";
    $result_array = $this->db->exec($sql);
    if($result_array === FALSE){
      return false;
    }
    return true;    
  }

  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */
  public function migrate($item) {
    $item_id = $item['item_id'];
    $rc = $this->xnpfiles_item_detail($item_id);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2001',$item_id);
    }
    return 0;
  }
}
