<?php

global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnppaper extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }
  
  /**
   * Initialize 
   */  
  public function init() {
    parent::init();
    $this->set_ng_item_name('Paper');
    $this->add_file_mapping_array('paper_pdf_reprint','files');
    
    #Description migrate to ...
    $this->set_description('outline');
    
    #Duplicate Table
    $this->add_dup_table('xnppaper_author');
    $this->add_dup_table('xnppaper_item_detail');
  }
  
  /**
   *
   * get xnppaper_item_detail
   * 
   * @param int $item_id
   * @return Success:Array includes fields, Fail:FALSE
   */
  protected function get_xnppaper_item_detail($item_id) {
    $wktbl = get_WK_tbl('xnppaper_item_detail');
    $sql = "select * from {$wktbl} where paper_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0];
    }
    return FALSE;
  }

  /**
   *
   * get xnppaper_author
   * 
   * @param int $item_id
   * @return Success:Array includes fields, Fail:FALSE 
   */
  protected function get_xnppaper_author($item_id){
    $wktbl = get_WK_tbl('xnppaper_author');
    $sql = "select * from {$wktbl} where paper_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) > 0){
      return $result_array;
    }
    return FALSE;    
  }

  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */
  function migrate($item) {
    $item_id = $item['item_id'];
    $item_detail = $this->get_xnppaper_item_detail($item_id);
    if($item_detail === FALSE || $item_detail === null){
      return -errmsg(APP_MIGRATE, 'E2101',$item_id);
    }
    
    #pubmedid
    $pubmed_array = $this->get_table_column_by_group('pubmedid');
    $rc = $this->insert_any($pubmed_array,$item_id,$item_detail['pubmed_id']);
    
    #journal,volume,number,page

    #journal
    $journal_array = $this->get_table_column_by_group('jtitle_name');
    if($journal_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2118');
    }
    $rc = $this->insert_any($journal_array,$item_id,$item_detail['journal']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2119',$item_id);
    }
    #Publication year
    $publication_year_array = $this->get_table_column_by_group('publication_year');
    if($publication_year_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2102');
    }
    $rc = $this->insert_any($publication_year_array,$item_id,$item['publication_year']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2103',$item_id);
    }
    
    #volume
    $paper_volume_array = $this->get_table_column_by_group('paper_volume');
    if($paper_volume_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2112');
    }
    $rc = $this->insert_any($paper_volume_array,$item_id,$item_detail['volume']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2113',$item_id);
    }
    
    #number
    $paper_volume_array = $this->get_table_column_by_group('paper_number');
    if($paper_volume_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2114');
    }
    $rc = $this->insert_any($paper_volume_array,$item_id,$item_detail['number']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2115',$item_id);
    }
    
    #page
    $paper_volume_array = $this->get_table_column_by_group('paper_page');
    if($paper_volume_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2116');
    }
    $rc = $this->insert_any($paper_volume_array,$item_id,$item_detail['page']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2117',$item_id);
    }
    
    #abstract
    $abstract_array = $this->get_table_column_by_group('paper_abstract');
    if($abstract_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2106');
    }
    
    $rc = $this->insert_any($abstract_array,$item_id,$item_detail['abstract']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2107',$item_id);
    }
    
    #author and author_id
    $author_array = $this->get_xnppaper_author($item_id);
    if($author_array === FALSE){
      return errmsg(APP_MIGRATE, 'E2108',$item_id);
    }    
    
    $name_array = $this->get_table_column_by_group('authors');
    if($name_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2109');
    }

    foreach ($author_array as $author) {
      $rc = $this->insert_any($name_array,$item_id,$author['author'],$author['author_order']);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E2110');
      }
    }
    return 0;
  }
};

