<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';
require_once XOOPS_ROOT_PATH . '/core/XCube_PageNavigator.class.php';
require_once dirname(dirname(dirname(__FILE__))) . '/class/bean/UserFieldDetailBean.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Transaction.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

class Xoonips_PolicyUserFieldAction extends Xoonips_ActionBase {

	protected function doInit(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_DESC;

		// breadcrumbs
		$breadcrumbs = array(
			array(
			    'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ACCOUNT_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_user_menu.php'
		  	),
			array(
			    'name' => $title,
			),
		);
		// get requsts
		$get_keys = array(
	    	'start' => array(
			    'i',
				false,
				false,
			),
		);
		$get_vals = Xoonips_Utils::xoonipsAdminGetRequests( 'get', $get_keys );

		// page navigation
		$start = ( is_null( $get_vals['start'] ) ) ? 0 : $get_vals['start'];
		$limit = 10;
		$userfieldBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean', $this->dirname, $this->trustDirname);
		$count = $userfieldBean->countUserfields();

		$pageNavi = new XCube_PageNavigator("policy_userfield.php", XCUBE_PAGENAVI_START);
		$pageNavi->setTotalItems($count);
		$pageNavi->setPerpage($limit);
		$pageNavi->fetch();

		$navi_title = sprintf( _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_PAGENAVI_FORMAT,
		$start + 1, ($start + $limit) > $count ? $count : $start + $limit, $count);

		$userfields_objs = $userfieldBean->getUserfieldlist($limit, $start);
		$userfields = array();

		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean', $this->dirname, $this->trustDirname);
		foreach ($userfields_objs as $userfield) {
			$userfieldid = $userfield['user_detail_id'];
			$name = $userfield['name'];
			$xml = $userfield['xml'];
			$editing = '';
			if ($userfield['released'] == 0) {
				$editing = _AM_XOONIPS_LABEL_ITEMTYPE_EDITING;
			} elseif ($userfield['upid'] != '') {
				if ($this->isDiff($userfieldBean, $userfieldid)) {
					$editing = _AM_XOONIPS_LABEL_ITEMTYPE_EDITING;
				} else {
					$detailInfo = $this->getDetailInfoForEdit($userfieldid, $disabled_arr, true);
					$this->deleteDetailAll($detailInfo['b_user_detail_id']);
				}
			}

			// check number of group
			$disdel = true;
			$groups = $groupBean->getGroupByDetailId($userfieldid);
			if ( count($groups) > 0 ) {
				$disdel = false;
			}

			// check preselect
			if ($userfield['preselect'] == 1) {
				$disdel = false;
			}

			$userfields[] = array(
			    'userfieldid' => $userfieldid,
			    'name' => $name,
			    'xml' => $xml,
				'editing' => $editing,
				'disdel' => $disdel
			);
		}

		// token ticket
		$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_userfield') );

		// get common viewdata
		$viewData = array();

		$viewData['token_ticket'] = $token_ticket;
		$viewData['navi_title'] = $navi_title;
		$viewData['userfields'] = $userfields;
		$viewData['pageNavi'] = $pageNavi;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;
		$viewData['perpage'] = $limit;
		$viewData['startpage'] = $start;

		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}

	protected function doRegister(&$request, &$response) {

		// get requests
		$changeop = $request->getParameter('changeop');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$view_type = $request->getParameter('view_type');
		$data_type = $request->getParameter('data_type');
		$list = $request->getParameter('list');
		#$list_display = $request->getParameter('list_display');
		#$list_sort_key = $request->getParameter('list_sort_key');
		#$list_width = $request->getParameter('list_width');
		$data_length = $request->getParameter('data_length');
		$data_decimal_places = $request->getParameter('data_decimal_places');
		$default_value = $request->getParameter('default_value');
		$essential = $request->getParameter('essential');
		$detail_display = ($request->getParameter('detail_display') === 0)? 0: 1;
		$registry_user = ($request->getParameter('registry_user') === 0)? 0: 1;
		$edit_user = ($request->getParameter('edit_user') === 0)? 0: 1;
		$target_user = $request->getParameter('target_user');
		$scope_search = $request->getParameter('scope_search');
		$scope_search_arr = $request->getParameter('scope_search_arr');

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_REGIST_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get viewtype info
		$viewtypelist = $this->getViewTypeList($view_type);

		// do view_type change
		if ( $changeop=='vtchange' ) {
			$data_type = '';
			$data_length = '';
			$data_decimal_places = '';
			$list = '';
			$default_value = '';
		}

		// do list change
		if ( $changeop=='listchange') {
			$default_value = '';
		}

		// get list block
		$list_block = $this->getDetailregisterListBlock( $view_type, $list );

		// get default block
		$default_block = $this->getDetailregisterDefaultValutBlock( $view_type, $list, $default_value );

		// get datatype info
		$selected_datatype_name = '';
		$scope_search = '';
		$scope_search_arr = '';
		$datatypelist = $this->getDataTypeList($view_type, $data_type, $selected_datatype_name, $scope_search, $scope_search_arr);

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_userfield_add'));

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['viewtypelist'] = $viewtypelist;
		$viewData['datatypelist'] = $datatypelist;
		$viewData['selected_datatype_name'] = $selected_datatype_name;
		$viewData['name'] = $name;
		$viewData['xml'] = $xml;
		$viewData['data_length'] = $data_length;
		$viewData['data_decimal_places'] = $data_decimal_places;
		$viewData['default_value'] = $default_value;
		$viewData['essential'] = $essential;
		$viewData['detail_display'] = $detail_display;
		$viewData['registry_user'] = $registry_user;
		$viewData['edit_user'] = $edit_user;
		$viewData['target_user'] = $target_user;
		$viewData['scope_search'] = $scope_search;
		$viewData['scope_search_arr'] = $scope_search_arr;
		$viewData['list_block'] = $list_block;
		$viewData['default_block'] = $default_block;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('register_success');
		return true;
	}

	protected function doRegistersave(&$request, &$response) {

		// get requests
		$changeop = $request->getParameter('changeop');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$view_type = $request->getParameter('view_type');
		$data_type = $request->getParameter('data_type');
		$list = $request->getParameter('list');
		$data_length = $request->getParameter('data_length');
		$data_decimal_places = $request->getParameter('data_decimal_places');
		$default_value = $request->getParameter('default_value');
		$essential = $request->getParameter('essential');
		$detail_display = $request->getParameter('detail_display');
		$registry_user = $request->getParameter('registry_user');
		$edit_user = $request->getParameter('edit_user');
		$target_user = $request->getParameter('target_user');
		$scope_search = $request->getParameter('scope_search');
		$scope_search_arr = $request->getParameter('scope_search_arr');
		$mode = $request->getParameter('mode');

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_REGIST_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get viewtype info
		$viewtypelist = $this->getViewTypeList($view_type);

		// do view_type change
		if ( $changeop=='vtchange' ) {
			$data_type = '';
			$data_length = '';
			$data_decimal_places = '';
			$list = '';
			$default_value = '';
		}

		// do list change
		if ( $changeop=='listchange') {
			$default_value = '';
		}

		// get list block
		$list_block = $this->getDetailregisterListBlock($view_type, $list);

		// get default block
		$default_block = $this->getDetailregisterDefaultValutBlock($view_type, $list, $default_value);

		// get datatype info
		$selected_datatype_name = '';
		$scope_search = '';
		$scope_search_arr = '';
		$datatypelist = $this->getDataTypeList($view_type, $data_type, $selected_datatype_name, $scope_search, $scope_search_arr);

		// do check
		$errors = new Xoonips_Errors();
		$inputData = array();
		$inputData['name'] = $name;
		$inputData['xml'] = $xml;
		$inputData['view_type'] = $view_type;
		$inputData['data_type'] = $data_type;
		$inputData['list'] = $list;
		$inputData['length'] = $data_length;
		$inputData['length2'] = $data_decimal_places;
		$inputData['default'] = $default_value;

		if (!$this->doDetailregistersaveInputCheck($inputData, $errors)) {
			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_userfield_add') );
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['viewtypelist'] = $viewtypelist;
			$viewData['datatypelist'] = $datatypelist;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['name'] = $name;
			$viewData['xml'] = $xml;
			$viewData['data_length'] = $data_length;
			$viewData['data_decimal_places'] = $data_decimal_places;
			$viewData['default_value'] = $default_value;
			$viewData['essential'] = $essential;
			$viewData['detail_display'] = $detail_display;
			$viewData['registry_user'] = $registry_user;
			$viewData['edit_user'] = $edit_user;
			$viewData['target_user'] = $target_user;
			$viewData['scope_search'] = $scope_search;
			$viewData['scope_search_arr'] = $scope_search_arr;
			$viewData['list_block'] = $list_block;
			$viewData['default_block'] = $default_block;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('register_success');
			return true;
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_userfield_add') ) ) {
			return false;
		}

		// insert usertype detail
		$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);

		$detail_info = array();
		$detail_info['released'] = 0;
		$detail_info['preselect'] = 0;
		$detail_info['table_name'] = "xoonips_user_extend";
		$detail_info['column_name'] = "value";
		$detail_info['user_type_id'] = 0;
		$detail_info['group_id'] = 0;
		$detail_info['weight'] = 1;
		$detail_info['name'] = $name;
		$detail_info['xml'] = $xml;
		$detail_info['view_type_id'] = $view_type;
		$detail_info['data_type_id'] = $data_type;
		$detail_info['data_length'] = ($data_length=="") ? -1 : $data_length;
		$detail_info['data_decimal_places'] = ($data_decimal_places=="") ? -1 : $data_decimal_places;
		$detail_info['default_value'] = ($default_value=="") ? NULL : $default_value;
		$detail_info['list'] = ($list=="") ? NULL : $list;
		$detail_info['essential'] = empty($essential) ? 0 : $essential;
		$detail_info['detail_display'] = empty($detail_display) ? 0 : $detail_display;
		$detail_info['registry_user'] = empty($registry_user) ? 0 : $registry_user;
		$detail_info['edit_user'] = empty($edit_user) ? 0 : $edit_user;
		$detail_info['target_user'] = empty($target_user) ? 0 : $target_user;
		$detail_info['scope_search'] = empty($scope_search) ? 0 : $scope_search;
		$detail_info['nondisplay'] = 0;
		$detail_info['update_id'] = NULL;

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		$new_detail_id = 0;
		if (!$detailBean->insert( $detail_info, $new_detail_id )){
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php?op=register';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('registersave_success');
			return true;
		}

		if (!$detailBean->updateTableName( $new_detail_id )){
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php?op=register';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('registersave_success');
			return true;
		}

		// release mode
		if ($mode == 1) {
			if (!$detailBean->release($new_detail_id, $new_detail_id)) {
				$transaction->rollback();

				$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php';
				$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_RELEASE_MSG_FAILURE;
				$response->setViewData($viewData);
				$response->setForward('registersave_success');
				return true;
			}
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php';
		if ($mode == 1) $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_RELEASE_MSG_SUCCESS;
		else $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_REGIST_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('registersave_success');
		return true;
	}

	protected function doEdit(&$request, &$response) {

		// get requests
		$base_detailid = $request->getParameter('detailid');
		$detailid = $request->getParameter('detailid');
		$changeop = $request->getParameter('changeop');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$view_type = $request->getParameter('view_type');
		$data_type = $request->getParameter('data_type');
		$list = $request->getParameter('list');
		$data_length = $request->getParameter('data_length');
		$data_decimal_places = $request->getParameter('data_decimal_places');
		$default_value = $request->getParameter('default_value');
		$essential = $request->getParameter('essential');
		$detail_display = $request->getParameter('detail_display');
		$registry_user = $request->getParameter('registry_user');
		$edit_user = $request->getParameter('edit_user');
		$target_user = $request->getParameter('target_user');
		$scope_search = $request->getParameter('scope_search');
		$nondisplay = $request->getParameter('nondisplay');
		$scope_search_arr = $request->getParameter('scope_search_arr');
		$perpage = $request->getParameter('perpage');
		$startpage = $request->getParameter('start');

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_MODIFY_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get base userfield info
		$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean', $this->dirname, $this->trustDirname);
		$baseInfo = $detailBean->getDetailEditInfo($base_detailid);

		// do copy
		if ($baseInfo['a_released'] == 1 && $baseInfo['b_update_id'] == null) {
			// transaction
			$transaction = Xoonips_Transaction::getInstance();
			$transaction->start();

			if ( !$this->doCopyUserfield($detailid , false, $insertId) ) {
				$transaction->rollback();
				die( "copy user field failure!" );
			}

			$detailid = $insertId;

			// success
			$transaction->commit();
		} elseif ($baseInfo['a_released'] == 1) {
			$detailid = $baseInfo['b_user_detail_id'];
		}

		// get detail info
		$disabled_arr = '';
		$detailInfo = $this->getDetailInfoForEdit($detailid, $disabled_arr);

		// get default_value title
		if ($detailInfo['b_list']!='' && $detailInfo['b_default_value']!='') {
			$valueSetBean = Xoonips_BeanFactory::getBean('UserFieldValueSetBean', $this->dirname, $this->trustDirname);
			$detailInfo['b_default_value'] = $valueSetBean->getUserTypeValueTitle($detailInfo['b_list'], $detailInfo['b_default_value']);
		}

		// initialization
		if ( $changeop=='' ) {
			$name = $detailInfo['a_name'];
			$xml = $detailInfo['a_xml'];
			$view_type = $detailInfo['a_view_type'];
			$data_type = $detailInfo['a_data_type'];
			$list = $detailInfo['a_list'];
			$data_length = $detailInfo['a_data_length'];
			$data_decimal_places = $detailInfo['a_data_decimal_places'];
			$default_value = $detailInfo['a_default_value'];
			$essential = $detailInfo['a_essential'];
			$detail_display = $detailInfo['a_detail_display'];
			$registry_user = $detailInfo['a_registry_user'];
			$edit_user = $detailInfo['a_edit_user'];
			$target_user = $detailInfo['a_target_user'];
			$scope_search = $detailInfo['a_scope_search'];
			$nondisplay = $detailInfo['a_nondisplay'];
		}

		// get viewtype info
		$viewtypelist = $this->getViewTypeList($view_type);

		// do view_type change
		if ( $changeop=='vtchange' ) {
			$data_type = '';
			$data_length = '';
			$data_decimal_places = '';
			$list = '';
			$default_value = '';
		}

		// do list change
		if ( $changeop=='listchange') {
			$default_value = '';
		}

		// get list block
		$list_block = $this->getDetaileditListBlock( $view_type, $list, $disabled_arr );

		// get default block
		$default_block = $this->getDetaileditDefaultValutBlock( $view_type, $list, $default_value, $disabled_arr );

		// get datatype info
		$selected_datatype_name = '';
		$scope_search = '';
		$scope_search_arr = '';
		$datatypelist = $this->getDataTypeList($view_type, $data_type, $selected_datatype_name, $scope_search, $scope_search_arr);

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_userfield_edit'));

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['base_detailid'] = $base_detailid;
		$viewData['detailid'] = $detailid;
		$viewData['detailInfo'] = $detailInfo;
		$viewData['viewtypelist'] = $viewtypelist;
		$viewData['datatypelist'] = $datatypelist;
		$viewData['selected_datatype_name'] = $selected_datatype_name;
		$viewData['name'] = $name;
		$viewData['xml'] = $xml;
		$viewData['view_type'] = $view_type;
		$viewData['data_type'] = $data_type;
		$viewData['data_length'] = $data_length;
		$viewData['data_decimal_places'] = $data_decimal_places;
		$viewData['default_value'] = $default_value;
		$viewData['essential'] = $essential;
		$viewData['detail_display'] =  $detail_display;
		$viewData['registry_user'] = $registry_user;
		$viewData['edit_user'] = $edit_user;
		$viewData['target_user'] = $target_user;
		$viewData['scope_search'] = $scope_search;
		$viewData['nondisplay'] = $nondisplay;
		$viewData['scope_search_arr'] = $scope_search_arr;
		$viewData['disabled_arr'] = $disabled_arr;
		$viewData['list_block'] = $list_block;
		$viewData['default_block'] = $default_block;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;
		$viewData['perpage'] = $perpage;
		$viewData['startpage'] = $startpage;

		$response->setViewData($viewData);
		$response->setForward('edit_success');
		return true;
	}

	protected function doEditsave(&$request, &$response) {

		// get requests
		$base_detailid = $request->getParameter('base_detailid');
		$detailid = $request->getParameter('detailid');
		$changeop = $request->getParameter('changeop');
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$view_type = $request->getParameter('view_type');
		$data_type = $request->getParameter('data_type');
		$list = $request->getParameter('list');
		$data_length = $request->getParameter('data_length');
		$data_decimal_places = $request->getParameter('data_decimal_places');
		$default_value = $request->getParameter('default_value');
		$essential = $request->getParameter('essential');
		$detail_display = $request->getParameter('detail_display');
		$registry_user = $request->getParameter('registry_user');
		$edit_user = $request->getParameter('edit_user');
		$scope_search = $request->getParameter('scope_search');
		$target_user = $request->getParameter('target_user');
		$nondisplay = $request->getParameter('nondisplay');
		$scope_search_arr = $request->getParameter('scope_search_arr');
		$mode = $request->getParameter('mode');

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_MODIFY_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get detail info
		$disabled_arr = '';
		$detailInfo = $this->getDetailInfoForEdit($detailid, $disabled_arr, true);

		// get default_value title
		if ( $detailInfo['b_list']!='' && $detailInfo['b_default_value']!='') {
			$valueSetBean = Xoonips_BeanFactory::getBean('UserFieldValueSetBean',$this->dirname,$this->trustDirname);
			$detailInfo['b_default_value'] = $valueSetBean->getUserTypeValueTitle($detailInfo['b_list'], $detailInfo['b_default_value']);
		}

		// get viewtype info
		$viewtypelist = $this->getViewTypeList($view_type);

		// do view_type change
		if ($changeop=='vtchange') {
			$data_type = '';
			$data_length = '';
			$data_decimal_places = '';
			$list = '';
			$default_value = '';
		}

		// do list change
		if ($changeop=='listchange') {
			$default_value = '';
		}

		// get list block
		$list_block = $this->getDetaileditListBlock( $view_type, $list, $disabled_arr );

		// get default block
		$default_block = $this->getDetaileditDefaultValutBlock( $view_type, $list, $default_value, $disabled_arr );

		// get datatype info
		$selected_datatype_name = '';
		$scope_search = '';
		$scope_search_arr = '';
		$datatypelist = $this->getDataTypeList($view_type, $data_type, $selected_datatype_name, $scope_search, $scope_search_arr);

		// do check
		$errors = new Xoonips_Errors();
		$inputData = array();
		$inputData['name'] = $name;
		$inputData['xml'] = $xml;
		$inputData['view_type'] = $view_type;
		$inputData['data_type'] = $data_type;
		$inputData['list'] = $list;
		$inputData['length'] = $data_length;
		$inputData['length2'] = $data_decimal_places;
		$inputData['default'] = $default_value;

		if (!$this->doDetaileditsaveInputCheck($detailid, $inputData, $errors, $base_detailid)) {
			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_userfield_edit') );
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['detailid'] = $detailid;
			$viewData['detailInfo'] = $detailInfo;
			$viewData['viewtypelist'] = $viewtypelist;
			$viewData['datatypelist'] = $datatypelist;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['name'] = $name;
			$viewData['xml'] = $xml;
			$viewData['view_type'] = $view_type;
			$viewData['data_type'] = $data_type;
			$viewData['data_length'] = $data_length;
			$viewData['data_decimal_places'] = $data_decimal_places;
			$viewData['default_value'] = $default_value;
			$viewData['essential'] = $essential;
			$viewData['detail_display'] =  $detail_display;
			$viewData['registry_user'] = $registry_user;
			$viewData['edit_user'] = $edit_user;
			$viewData['target_user'] = $target_user;
			$viewData['scope_search'] = $scope_search;
			$viewData['nondisplay'] = $nondisplay;
			$viewData['scope_search_arr'] = $scope_search_arr;
			$viewData['disabled_arr'] = $disabled_arr;
			$viewData['list_block'] = $list_block;
			$viewData['default_block'] = $default_block;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('edit_success');
			return true;
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_userfield_edit') ) ) {
			return false;
		}

		// update usertype detail
		$detail_info = array();
		$detail_info['name'] = $name;
		$detail_info['xml'] = $xml;
		$detail_info['view_type_id'] = $view_type;
		$detail_info['data_type_id'] = $data_type;
		$detail_info['data_length'] = ($data_length=="") ? -1 : $data_length;
		$detail_info['data_decimal_places'] = ($data_decimal_places=="") ? -1 : $data_decimal_places;
		$detail_info['default_value'] = ($default_value=="") ? NULL : $default_value;
		$detail_info['list'] = ($list=="") ? NULL : $list;
		$detail_info['essential'] = empty($essential) ? 0 : $essential;
		$detail_info['detail_display'] = empty($detail_display) ? 0 : $detail_display;
		$detail_info['registry_user'] = empty($registry_user) ? 0 : $registry_user;
		$detail_info['edit_user'] = empty($edit_user) ? 0 : $edit_user;
		$detail_info['target_user'] = empty($target_user) ? 0 : $target_user;
		$detail_info['scope_search'] = empty($scope_search) ? 0 : $scope_search;
		$detail_info['nondisplay'] = empty($nondisplay) ? 0 : $nondisplay;

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);
		if (!$detailBean->update( $detail_info, $detailid )){
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php?op=edit&detailid='.$base_detailid;
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('editsave_success');
			return true;
		}

		// release mode
		if ($mode == 1) {
			if (!$detailBean->release($detailid, $base_detailid)) {
				$transaction->rollback();

				$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php';
				$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_RELEASE_MSG_FAILURE;
				$response->setViewData($viewData);
				$response->setForward('editsave_success');
				return true;
			}
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php';
		if ($mode == 1) $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_RELEASE_MSG_SUCCESS;
		else $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_MODIFY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('editsave_success');
		return true;
	}

	protected function doRelease(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get requests
		$base_detailid = $request->getParameter('base_detailid');
		$detailid = $request->getParameter('detailid');

		// do release
		$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);
		if (!$detailBean->release($detailid, $base_detailid)) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('release_success');
			return true;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_MODIFY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('release_success');
		return true;
	}

	protected function doDelete(&$request, &$response) {

		// get requests
		$detailid = $request->getParameter('detailid');

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_userfield') ) ) {
			return false;
		}

		// do check
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean', $this->dirname, $this->trustDirname);
		$groups = $groupBean->getGroupByDetailId($detailid);
		if ( count($groups) > 0 ) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_DELETE_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('delete_success');
			return true;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// delete all
		if (!$this->deleteDetailAll($detailid)) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('delete_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_DELETE_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('delete_success');

		return true;
	}

	private function setBreadcrumbs($title) {
		$breadcrumbs = array(
			array(
			    'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ACCOUNT_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_user_menu.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfield.php',
			),
			array(
			    'name' => $title,
			),
		);
		return $breadcrumbs;
	}

	// get edit field info
	private function getDetailInfoForEdit($detailid, &$disabled_arr, $ng=false) {
		$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean', $this->dirname, $this->trustDirname);
		if ($ng) {
			$dinfo = $detailBean->getDetailEditInfo($detailid);
		} else {
			$dinfo = $detailBean->getDetailEditInfo($detailid, true);
		}
		$disabled_arr = $dinfo['b_released']==1 ? 'disabled="disabled"' : '';
		$b_view_type_id = $dinfo['a_released']==1 ? $dinfo['a_view_type_id'] : $dinfo['b_view_type_id'];
		$b_data_type_id = $dinfo['a_released']==1 ? $dinfo['a_data_type_id'] : $dinfo['b_data_type_id'];
		$detailInfo = array (
		    'a_name' => $dinfo['a_released']==1 ? $dinfo['b_name'] : $dinfo['a_name'],
			'a_xml' => $dinfo['a_released']==1 ? $dinfo['b_xml'] : $dinfo['a_xml'],
			'a_view_type' => $dinfo['a_released']==1 ? $dinfo['b_view_type_id'] : $dinfo['a_view_type_id'],
			'a_data_type' => $dinfo['a_released']==1 ? $dinfo['b_data_type_id'] : $dinfo['a_data_type_id'],
			'a_data_length' => $dinfo['a_released']==1 ? $dinfo['b_data_length'] : $dinfo['a_data_length'],
			'a_data_decimal_places' => $dinfo['a_released']==1 ? $dinfo['b_data_decimal_places'] : $dinfo['a_data_decimal_places'],
			'a_default_value' => $dinfo['a_released']==1 ? $dinfo['b_default_value'] : $dinfo['a_default_value'],
			'a_list' => $dinfo['a_released']==1 ? $dinfo['b_list'] : $dinfo['a_list'],
			'a_essential' => $dinfo['a_released']==1 ? $dinfo['b_essential'] : $dinfo['a_essential'],
			'a_detail_display' => $dinfo['a_released']==1 ? $dinfo['b_detail_display'] : $dinfo['a_detail_display'],
			'a_registry_user' => $dinfo['a_released']==1 ? $dinfo['b_registry_user'] : $dinfo['a_registry_user'],
			'a_edit_user' => $dinfo['a_released']==1 ? $dinfo['b_edit_user'] : $dinfo['a_edit_user'],
			'a_target_user' => $dinfo['a_released']==1 ? $dinfo['b_target_user'] : $dinfo['a_target_user'],
			'a_scope_search' => $dinfo['a_released']==1 ? $dinfo['b_scope_search'] : $dinfo['a_scope_search'],
			'a_nondisplay' => $dinfo['a_released']==1 ? $dinfo['b_nondisplay'] : $dinfo['a_nondisplay'],
		    'a_weight' => $dinfo['a_released']==1 ? $dinfo['b_weight'] : $dinfo['a_weight'],
		    'b_name' => $dinfo['a_released']==1 ? $dinfo['a_name'] : $dinfo['b_name'],
			'b_xml' => $dinfo['a_released']==1 ? $dinfo['a_xml'] : $dinfo['b_xml'],
			'b_view_type' => $b_view_type_id,
			'b_data_type' => $b_data_type_id,
			'b_view_name' => empty($b_view_type_id) ? "" : Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType($b_view_type_id)->getName(),
			'b_data_name' => empty($b_data_type_id) ? "" : Xoonips_DataTypeFactory::getInstance($this->dirname, $this->trustDirname)->getDataType($b_data_type_id)->getName(),
			'b_data_length' => $dinfo['a_released']==1 ? $dinfo['a_data_length'] : $dinfo['b_data_length'],
			'b_data_decimal_places' => $dinfo['a_released']==1 ? $dinfo['a_data_decimal_places'] : $dinfo['b_data_decimal_places'],
			'b_default_value' => $dinfo['a_released']==1 ? $dinfo['a_default_value'] : $dinfo['b_default_value'],
			'b_list' => $dinfo['a_released']==1 ? $dinfo['a_list'] : $dinfo['b_list'],
			'b_essential' => $dinfo['a_released']==1 ? $dinfo['a_essential'] : $dinfo['b_essential'],
			'b_detail_display' => $dinfo['a_released']==1 ? $dinfo['a_detail_display'] : $dinfo['b_detail_display'],
			'b_registry_user' => $dinfo['a_released']==1 ? $dinfo['a_registry_user'] : $dinfo['b_registry_user'],
			'b_edit_user' => $dinfo['a_released']==1 ? $dinfo['a_edit_user'] : $dinfo['b_edit_user'],
			'b_target_user' => $dinfo['a_released']==1 ? $dinfo['a_target_user'] : $dinfo['b_target_user'],
			'b_scope_search' => $dinfo['a_released']==1 ? $dinfo['a_scope_search'] : $dinfo['b_scope_search'],
			'b_nondisplay' => $dinfo['a_released']==1 ? $dinfo['a_nondisplay'] : $dinfo['b_nondisplay'],
			'b_weight' => $dinfo['a_released']==1 ? $dinfo['a_weight'] : $dinfo['b_weight'],
			'b_user_detail_id' => $dinfo['b_user_detail_id']
		);
		return $detailInfo;
	}

	private function isDiff($detailBean, $detailid) {
		$dinfo = $detailBean->getDetailEditInfo($detailid);
		return ($dinfo['b_name'] != $dinfo['a_name'] || $dinfo['b_xml'] != $dinfo['a_xml']
				|| $dinfo['b_view_type_id'] != $dinfo['a_view_type_id']
				|| $dinfo['b_data_type_id'] != $dinfo['a_data_type_id']
				|| $dinfo['b_data_length'] != $dinfo['a_data_length']
				|| $dinfo['b_data_decimal_places'] != $dinfo['a_data_decimal_places']
				|| $dinfo['b_default_value'] != $dinfo['a_default_value']
				|| $dinfo['b_list'] != $dinfo['a_list']
				|| $dinfo['b_essential'] != $dinfo['a_essential']
				|| $dinfo['b_detail_display'] != $dinfo['a_detail_display']
				|| $dinfo['b_target_user'] != $dinfo['a_target_user']
				|| $dinfo['b_scope_search'] != $dinfo['a_scope_search']
				|| $dinfo['b_nondisplay'] != $dinfo['a_nondisplay']
				|| $dinfo['b_weight'] != $dinfo['a_weight']);
	}

	private function getDataTypeList($view_type, $data_type, &$selected_datatype_name, &$scope_search, &$scope_search_arr) {
		$datatypeBean = Xoonips_BeanFactory::getBean('DataTypeBean', XCUBE_CORE_USER_MODULE_NAME);
		$datatypes = $datatypeBean->selectDatatypesByViewtype($view_type);
		$datatypelist = array(array('datatype_id' => '0', 'name' => '-------------'));
		foreach ($datatypes as $dt) {
			$datatype['datatype_id'] = $dt['data_type_id'];
			$datatype['name'] = $dt['name'];
			$datatype['data_length'] = $dt['data_length'];
			$datatype['data_decimal_places'] = $dt['data_decimal_places'];
			$datatype['selected'] = ($dt['data_type_id'] == $data_type) ? 'selected="selected"' : '';
			if ($datatype['selected'] != '') {
				$selected_datatype_name = $dt['name'];
			}
			$datatypelist[] = $datatype;
		}

		// scope_search contral
		if (intval($data_type) == $datatypeBean->selectByName('char')
				|| intval($data_type) == $datatypeBean->selectByName('varchar')
				|| intval($data_type) == $datatypeBean->selectByName('text')
				|| intval($data_type) == $datatypeBean->selectByName('blob')) {
			$scope_search = '';
			$scope_search_arr = "disabled='disabled'";
		} else {
			$scope_search_arr = '';
		}
		return $datatypelist;
	}

	// create extend table
	private function createUserExtendTable($usertype_id, $isRelease = false){
		$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean', $this->dirname, $this->trustDirname);
		if ($isRelease){
			$newDetails = $detailBean->getNewUserTypeDetail( $usertype_id );
			if (!$detailBean->createExtendTable($newDetails)) return false;
		} else {
			$detailObj = $detailBean->getReleasedDetail( $usertype_id );
			if (!$detailBean->createExtendTable($detailObj)) return false;
		}
		return true;
	}

	private function doDetailregistersaveInputCheck($inputData, &$errors){
		// detail name
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DETAIL_NAME;
		$viewTypeBean = Xoonips_BeanFactory::getBean('ViewTypeBean', $this->dirname, $this->trustDirname);
		$dataTypeBean = Xoonips_BeanFactory::getBean('DataTypeBean', $this->dirname, $this->trustDirname);

		if ($inputData['name']=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			// name double check except preview & file upload
			if ($inputData['view_type'] != $viewTypeBean->selectByName('preview') && $inputData['view_type'] != $viewTypeBean->selectByName('file upload')) {
				$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean', $this->dirname, $this->trustDirname);
				if ($detailBean->existDetailName(0, $inputData['name'], 0)) {
					$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				}

			}
		}

		// detail xml
		$parameters = array();
		$parameters[] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_ID;
		if ($inputData['xml']=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			// xml double check except preview & file upload
			if ($inputData['view_type'] != $viewTypeBean->selectByName('preview') && $inputData['view_type'] != $viewTypeBean->selectByName('file upload')) {
				$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);
				if ($detailBean->existDetailXml(0, $inputData['xml'], 0)) {
					$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				}
			}
		}

		// view_type
		if ($inputData['view_type']=='0') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_VIEW_TYPE;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);
			$viewtypeObj =Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $inputData['view_type'] );
			if ($viewtypeObj->isMulti()==false && $detailBean->existViewtype(0, $inputData['view_type'], 0)){
				$parameters = array();
				$parameters[] = "";
				$errors->addError("_AM_XOONIPS_POLICY_ITEMTYPE_VIEWTYPE_DUPLICATE_MSG", "", $parameters);
			}
		}

		// data_type
		if ($inputData['data_type']=='0') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_TYPE;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// list required when view_type is radio & select
		if (($inputData['view_type'] == $viewTypeBean->selectByName('radio') || $inputData['view_type'] == $viewTypeBean->selectByName('checkbox')) && $inputData['list'] == '') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_SUBTYPES;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// length
		if ($inputData['length'] == '') {
			if ($inputData['data_type'] == $dataTypeBean->selectByName('int')) {
				$inputData['length'] = 11;
			} elseif ($inputData['data_type'] == $dataTypeBean->selectByName('float')) {
				$inputData['length'] = 24;
			} elseif ($inputData['data_type'] == $dataTypeBean->selectByName('double')) {
				$inputData['length'] = 53;
			} elseif ($inputData['data_type'] == $dataTypeBean->selectByName('varchar')) {
				$inputData['length'] = 255;
			} elseif ($inputData['data_type'] != $dataTypeBean->selectByName('char')) {
				$inputData['length'] = -1;
			}
		}
		if ($inputData['length']!='' && !is_numeric($inputData['length'])) {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_LENGTH;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// length2
		if ($inputData['length2'] == '') {
			if ($inputData['data_type'] == $dataTypeBean->selectByName('float') || $inputData['data_type'] == $dataTypeBean->selectByName('double')) {
				$inputData['length2'] = 0;
			} else {
				$inputData['length2'] = -1;
			}
		}
		if ($inputData['length2']!='' && !is_numeric($inputData['length2'])){
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_LENGTH2;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		if (count($errors->getErrors()) > 0) {
			return false;
		}
		else
		{
			// 'value' colmun attribute check
			$user = new User_UserField();
			$user->setLen($inputData['length']);
			$user->setDecimalPlaces($inputData['length2']);
			$user->setDefault($inputData['default']);
			$datatypeObj = Xoonips_DataTypeFactory::getInstance($this->dirname, $this->trustDirname)->getDataType($inputData['data_type']);
			$datatypeObj->valueAttrCheck($user, $errors);
			if (count($errors->getErrors()) > 0) {
				return false;
			}
		}
		return true;
	}

	// get list block view
	private function getDetailregisterListBlock( $view_type, $list ){
		if ( empty($view_type) ) {
			return $this->getListBlockHtml( $view_type );
		}
		$viewTypeManage = Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $view_type );
		return $viewTypeManage->getListBlockView( $list );
	}

	// get default value block view
	private function getDetailregisterDefaultValutBlock( $view_type, $list, $default_value ){
		if ( empty($view_type) ) {
			return $this->getDefaultListBlockHtml( $default_value );
		}
		$viewTypeManage = Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $view_type );
		return $viewTypeManage->getDefalutValueBlockView( $list, $default_value );
	}

	private function doDetaileditsaveInputCheck($detailid, $inputData, &$errors, $base_detailid){
		// detail name
		$viewTypeBean = Xoonips_BeanFactory::getBean('ViewTypeBean', $this->dirname, $this->trustDirname);

		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DETAIL_NAME;
		if ($inputData['name']=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			// name double check except preview & file upload
			if ($inputData['view_type'] != $viewTypeBean->selectByName('preview') && $inputData['view_type'] != $viewTypeBean->selectByName('file upload')) {
				$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);
				if ($detailBean->existDetailName($detailid, $inputData['name'], $base_detailid)) {
					$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				}
			}
		}

		// detail xml
		$parameters = array();
		$parameters[] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_ID;
		if ($inputData['xml']=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			// xml double check except preview & file upload
			if ($inputData['view_type'] != $viewTypeBean->selectByName('preview') && $inputData['view_type'] != $viewTypeBean->selectByName('file upload')) {
				$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);
				if ($detailBean->existDetailXml($detailid, $inputData['xml'], $base_detailid)) {
					$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
				}
			}
		}

		// view_type
		if ($inputData['view_type']=='0') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_VIEW_TYPE;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);
			$viewtypeObj =Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $inputData['view_type'] );
			if ($viewtypeObj->isMulti()==false && $detailBean->existViewtype($detailid, $inputData['view_type'], $base_detailid)){
				$parameters = array();
				$parameters[] = "";
				$errors->addError("_AM_XOONIPS_POLICY_ITEMTYPE_VIEWTYPE_DUPLICATE_MSG", "", $parameters);
			}
		}

		// data_type
		if ($inputData['data_type']=='0') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_TYPE;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// list required when view_type is radio & select
		if (($inputData['view_type'] == $viewTypeBean->selectByName('radio') || $inputData['view_type'] == $viewTypeBean->selectByName('select')) && $inputData['list']=='') {
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_SUBTYPES;
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		}

		// length
		if ($inputData['length']!='' && !is_numeric($inputData['length'])){
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_LENGTH;
			$errors->addError("_AM_XOONIPS_CHECK_INPUT_ERROR_MSG", "", $parameters);
		}

		// length2
		if ($inputData['length2']!='' && !is_numeric($inputData['length2'])){
			$parameters = array();
			$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_DATA_LENGTH2;
			$errors->addError("_AM_XOONIPS_CHECK_INPUT_ERROR_MSG", "", $parameters);
		}

		if (count($errors->getErrors()) > 0) {
			return false;
		}
		else
		{
			// 'value' colmun attribute check
			$user = new User_UserField();
			$user->setLen($inputData['length']);
			$user->setDecimalPlaces($inputData['length2']);
			$user->setDefault($inputData['default']);
			$datatypeObj = Xoonips_DataTypeFactory::getInstance($this->dirname, $this->trustDirname)->getDataType($inputData['data_type']);
			$datatypeObj->valueAttrCheck($user, $errors);
			if (count($errors->getErrors()) > 0) {
				return false;
			}
		}
		return true;
	}

	// get list block view
	private function getDetaileditListBlock( $view_type, $list, $disabled_arr ){
		if ( empty($view_type) ) {
			return $this->getListBlockHtml( $view_type );
		}
		$viewTypeManage = Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $view_type );
		return $viewTypeManage->getListBlockView( $list, $disabled_arr );
	}

	// get default value block view
	private function getDetaileditDefaultValutBlock( $view_type, $list, $default_value, $disabled_arr ){
		if ( empty($view_type) ) {
			return $this->getDefaultListBlockHtml( $default_value );
		}
		$viewTypeManage = Xoonips_ViewTypeFactory::getInstance($this->dirname, $this->trustDirname)->getViewType( $view_type );
		return $viewTypeManage->getDefalutValueBlockView( $list, $default_value, $disabled_arr );
	}

	private function getListBlockHtml( $view_type ){
		$root =& XCube_Root::getSingleton();
		$root->mContext->mModule->setAdminMode(true);
		$controller = $root->getController();
		$render =$controller->mRoot->mContext->mModule->getRenderTarget();
		$render->setTemplateName('policy_usertype.inc.html');
		$render->setAttribute('flg', true);
		$render->setAttribute('value', $view_type);
		$renderSystem =$controller->mRoot->getRenderSystem($controller->mRoot->mContext->mModule->getRenderSystemName());
		$renderSystem->renderMain($render);
		$ret = $render->getResult();
		return $ret;
	}

	private function getDefaultListBlockHtml( $default_value ){
		$root =& XCube_Root::getSingleton();
		$root->mContext->mModule->setAdminMode(true);
		$controller = $root->getController();
		$render =$controller->mRoot->mContext->mModule->getRenderTarget();
		$render->setTemplateName('policy_usertype.inc.html');
		$render->setAttribute('flg', false);
		$render->setAttribute('value', $default_value);
		$renderSystem =$controller->mRoot->getRenderSystem($controller->mRoot->mContext->mModule->getRenderSystemName());
		$renderSystem->renderMain($render);
		$ret = $render->getResult();
		return $ret;
	}

	private function deleteDetailAll($detailid) {

		// delete relation detail
		$relationBean = Xoonips_BeanFactory::getBean('UserFieldDetailComplementLinkBean', $this->dirname, $this->trustDirname);
		if (!$relationBean->deleteByBothDetailId($detailid)) return false;

		// delete detail
		$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean', $this->dirname, $this->trustDirname);
		if (!$detailBean->delete($detailid)) return false;

		return true;
	}

	private function getViewTypeList($view_type) {
		$viewtypeBean = Xoonips_BeanFactory::getBean('ViewTypeBean', XCUBE_CORE_USER_MODULE_NAME);
		$viewtypes = $viewtypeBean->getViewtypeList();
		$viewtypelist = array(array('viewtype_id' => '0', 'name' => '-------------'));
		foreach ($viewtypes as $vt) {
			$viewtype['viewtype_id'] = $vt['view_type_id'];
			$viewtype['name'] = $vt['name'];
			$viewtype['selected'] = ($vt['view_type_id'] == $view_type) ? 'selected="selected"' : '';
			$viewtypelist[] = $viewtype;
		}
		return $viewtypelist;
	}

	private function doCopyUserfield( $userfieldid, $isCopy = false, &$insertId ) {
		$map = array();
		if ($isCopy) {
			$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);
			if (!$detailBean->copyById($userfieldid, $map)) return false;

			$relationBean = Xoonips_BeanFactory::getBean('UserFieldDetailComplementLinkBean',$this->dirname,$this->trustDirname);
			if (!$relationBean->copyById($userfieldid, $map)) return false;
		}
		else
		{
			$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean',$this->dirname,$this->trustDirname);
			if (!$detailBean->copyById($userfieldid, $map, true)) return false;

			$insertId = $map['detail'][$userfieldid];

			$relationBean = Xoonips_BeanFactory::getBean('UserFieldDetailComplementLinkBean',$this->dirname,$this->trustDirname);
			if (!$relationBean->copyById($userfieldid, $map, true)) return false;

		}
		return true;
	}

}

