<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';
require_once XOOPS_ROOT_PATH . '/core/XCube_PageNavigator.class.php';
require_once dirname(dirname(dirname(__FILE__))) . '/class/bean/UserFieldGroupBean.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Transaction.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

class Xoonips_PolicyUserGroupAction extends Xoonips_ActionBase {

	protected function doInit(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_DESC;

		// breadcrumbs
		$breadcrumbs = array(
			array(
			    'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ACCOUNT_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_user_menu.php'
		  	),
			array(
			    'name' => $title,
			),
		);
		// get requsts
		$get_keys = array(
	    	'start' => array(
			    'i',
				false,
				false,
			),
		);
		$get_vals = Xoonips_Utils::xoonipsAdminGetRequests( 'get', $get_keys );

		// page navigation
		$start = ( is_null( $get_vals['start'] ) ) ? 0 : $get_vals['start'];
		$limit = 10;
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean', $this->dirname, $this->trustDirname);
		$count = $groupBean->countUsergroups();

		$pageNavi = new XCube_PageNavigator("policy_userfieldgroup.php", XCUBE_PAGENAVI_START);
		$pageNavi->setTotalItems($count);
		$pageNavi->setPerpage($limit);
		$pageNavi->fetch();

		$navi_title = sprintf( _AM_XOONIPS_POLICY_ACCOUNT_GROUP_PAGENAVI_FORMAT,
		$start + 1, ($start + $limit) > $count ? $count : $start + $limit, $count);

		$usergroups_objs = $groupBean->getUsergrouplist($limit, $start);
		$usergroups = array();

		foreach ($usergroups_objs as $usergroup) {
			$usergroupid = $usergroup['group_id'];
			$name = $usergroup['name'];
			$xml = $usergroup['xml'];
			$editing = '';
			if ($usergroup['released'] == 0) {
				$editing = _AM_XOONIPS_LABEL_ITEMTYPE_EDITING;
			} elseif ($usergroup['upid'] != '') {
				if ($this->isDiff($usergroupid)) {
					$editing = _AM_XOONIPS_LABEL_ITEMTYPE_EDITING;
				} else {
					$groupInfo = $this->getGroupInfoForEdit($usergroupid, true);
					$this->deleteGroupAll($groupInfo['b_group_id']);
				}
			}

			// check preselect
			$disdel = true;
			if ($usergroup['preselect'] == 1) {
				$disdel = false;
			}

			$usergroups[] = array(
			    'usergroupid' => $usergroupid,
			    'name' => $name,
			    'xml' => $xml,
				'editing' => $editing,
				'disdel' => $disdel
			);
		}

		// token ticket
		$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_usergroup') );

		// get common viewdata
		$viewData = array();

		$viewData['token_ticket'] = $token_ticket;
		$viewData['navi_title'] = $navi_title;
		$viewData['usergroups'] = $usergroups;
		$viewData['pageNavi'] = $pageNavi;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;
		$viewData['perpage'] = $limit;
		$viewData['startpage'] = $start;

		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}

	protected function doRegister(&$request, &$response) {

		// get requests
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$occurrence = $request->getParameter('occurrence');

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_REGIST_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get details for select
		$userfields = $this->getDetailsForSelect();

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_usertype_group_register'));

		// get common viewdata
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['name'] = $name;
		$viewData['xml'] = $xml;
		$viewData['occurrence'] = $occurrence;
		$viewData['userfields'] = $userfields;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('register_success');

		return true;
	}

	protected function doRegistersave(&$request, &$response) {

		// get requests
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$occurrence = ($request->getParameter('occurrence') == 0)? 0: 1;
		$mode = $request->getParameter('mode');

		// get fields info
		$userfields = array();
		$userfieldBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean', $this->dirname, $this->trustDirname);
		$count = $userfieldBean->countUserfields();
		$userfields_objs = $userfieldBean->getUserfieldlist($count, 0);

		foreach ($userfields_objs as $userfield) {
			$userfieldid = $userfield['user_detail_id'];
			if ($request->getParameter('checkbox_'.$userfieldid)) {
				$userfields[] = $userfieldid;
			}
		}

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_REGIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_REGIST_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// do check
		$errors = new Xoonips_Errors();
		if (!$this->doGroupregistersaveInputCheck($name, $xml, $errors)) {
			// get details for select
			$userfields = $this->getDetailsForSelect();

			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_usertype_group_register') );
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['name'] = $name;
			$viewData['xml'] = $xml;
			$viewData['occurrence'] = $occurrence;
			$viewData['userfields'] = $userfields;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('register_success');
			return true;
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_usertype_group_register') ) ) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// insert usertype group
		$new_group_id = 0;
		if ( !$this->insertXoonipsUsertypeGroup( $name, $xml, $occurrence, $new_group_id ) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php?op=register';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('registersave_success');
			return true;
		}

		// update link of group and detail
		if ( !$this->updateGroupDetailLink($new_group_id, $userfields) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php?op=register';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_REGIST_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('registersave_success');
			return true;
		}

		// release mode
		if ($mode == 1) {
			// get group detail list
			$details = $this->getFieldInfos($new_group_id);
			if (count($details) == 0) {
				$transaction->rollback();

				$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname."/admin/policy_userfieldgroup.php?op=register&name=$name&xml=$xml&occurrence=$occurrence";
				$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_REGIST_MSG_FAILURE2;
				$response->setViewData($viewData);
				$response->setForward('editsave_success');
				return true;
			}

			$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean', $this->dirname, $this->trustDirname);
			if (!$groupBean->release($new_group_id, $new_group_id)) {
				$transaction->rollback();

				$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
				$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_RELEASE_MSG_FAILURE;
				$response->setViewData($viewData);
				$response->setForward('registersave_success');
				return true;
			}
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
		if ($mode == 1) $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_RELEASE_MSG_SUCCESS;
		else $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_REGIST_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('registersave_success');

		return true;
	}

	protected function doEdit(&$request, &$response) {

		// get requests
		$base_groupid = $request->getParameter('groupid');
		$groupid = $request->getParameter('groupid');
		$perpage = $request->getParameter('perpage');
		$startpage = $request->getParameter('start');

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_MODIFY_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get base usergroup info
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean', $this->dirname, $this->trustDirname);
		$baseInfo = $groupBean->getGroupEditInfo($base_groupid);

		// do copy
		if ($baseInfo['a_released'] == 1 && $baseInfo['b_update_id'] == null) {
			// transaction
			$transaction = Xoonips_Transaction::getInstance();
			$transaction->start();

			if ( !$this->doCopyUsergroup($groupid, false, $insertId) ) {
				$transaction->rollback();
				die( "copy user group failure!" );
			}

			$groupid = $insertId;

			// success
			$transaction->commit();
		} elseif ($baseInfo['a_released'] == 1) {
			$groupid = $baseInfo['b_group_id'];
		}

		// get edit group info
		$groupInfo = $this->getGroupInfoForEdit($groupid);

		// get group detail list
		$details = $this->getFieldInfos($base_groupid);

		// check editing detail link
		$detail_editing = 0;
		if (self::isDetailLinkDiff($base_groupid)) {
			$detail_editing = 1;
		}

		// check preselect
		$chk_groups = $groupBean->getUsergroup($base_groupid);
		$select_btn = 1;
		foreach($chk_groups as $chk_group){
			if ($chk_group['preselect'] == 1) {
				$select_btn = 0;
			}
		}

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_usertype_groupedit'));

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['base_groupid'] = $base_groupid;
		$viewData['groupid'] = $groupid;
		$viewData['groupInfo'] = $groupInfo;
		$viewData['detail_editing'] = $detail_editing;
		$viewData['details'] = $details;
		$viewData['select_btn'] = $select_btn;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;
		$viewData['perpage'] = $perpage;
		$viewData['startpage'] = $startpage;

		$response->setViewData($viewData);
		$response->setForward('edit_success');

		return true;
	}

	protected function doEditsave(&$request, &$response) {

		// get requests
		$base_groupid = $request->getParameter('base_groupid');
		$groupid = $request->getParameter('groupid');
		$mode = $request->getParameter('mode');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get edit group info
		$groupInfo = $this->getGroupInfoForEdit($groupid, true);

		// get group detail list
		$details = $this->getFieldInfos($groupid);

		// do update
		$errors = new Xoonips_Errors();
		$name = $request->getParameter('name');
		$xml = $request->getParameter('xml');
		$occurrence = $request->getParameter('occurrence');
		$detail_ids = $request->getParameter('detail_ids');
		$weights = $request->getParameter('weights');

		// do check
		if (!$this->doGroupeditsaveInputCheck($groupid, $name, $xml, $errors, $base_groupid)){
			// get group detail list
			$details = $this->getFieldInfos($base_groupid);

			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_usertype_groupedit') );
			$groupInfo['a_name'] = $name;
			$groupInfo['a_xml'] = $xml;
			$groupInfo['a_occurrence'] = $occurrence;
			$viewData['breadcrumbs'] = $breadcrumbs;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['base_groupid'] = $base_groupid;
			$viewData['groupid'] = $groupid;
			$viewData['groupInfo'] = $groupInfo;
			$viewData['details'] = $details;
			$viewData['title'] = $title;
			$viewData['description'] = $description;
			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('edit_success');
			return true;
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_usertype_groupedit') ) ) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// update group
		if ( !$this->updateXoonipsUsertypeGroup( $groupid, $name, $xml, $occurrence ) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('editsave_success');
			return true;
		}

		// update detail link weight
		if ( !$this->updateXoonipsUsertypeDetailOrder( $base_groupid, $detail_ids, $weights ) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('editsave_success');
			return true;
		}

		// release mode
		if ($mode == 1) {
			// get group detail list
			$details = $this->getFieldInfos($base_groupid);
			if (count($details) == 0) {
				$transaction->rollback();

				$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php?op=edit&groupid='.$base_groupid;
				$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_MSG_FAILURE2;
				$response->setViewData($viewData);
				$response->setForward('editsave_success');
				return true;
			}

			$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean', $this->dirname, $this->trustDirname);
			if (!$groupBean->release($groupid, $base_groupid)) {
				$transaction->rollback();

				$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
				$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_RELEASE_MSG_FAILURE;
				$response->setViewData($viewData);
				$response->setForward('editsave_success');
				return true;
			}
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
		if ($mode == 1) $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_RELEASE_MSG_SUCCESS;
		else $viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('editsave_success');
		return true;
	}

	protected function doSorteditsave(&$request, &$response) {

		// get requests
		$base_groupid = $request->getParameter('base_groupid');
		$groupid = $request->getParameter('groupid');

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get edit group info
		$groupInfo = $this->getGroupInfoForEdit($groupid, true);

		// get group detail list
		$details = $this->getFieldInfos($groupid);

		// do update
		$errors = new Xoonips_Errors();
		$detail_ids = $request->getParameter('detail_ids');
		$weights = $request->getParameter('weights');

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_usertype_groupedit') ) ) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// update detail link weight
		if ( !$this->updateXoonipsUsertypeDetailOrder( $base_groupid, $detail_ids, $weights ) ) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('editsave_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php?op=edit&groupid='.$base_groupid;
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('editsave_success');

		return true;
	}

	protected function doRelease(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_EDIT_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMTYPE_GROUP_MODIFY_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs($title);

		// get requests
		$base_groupid = $request->getParameter('base_groupid');
		$groupid = $request->getParameter('groupid');

		// do release
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean', $this->dirname, $this->trustDirname);
		if (!$groupBean->release($groupid, $base_groupid)) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_MODIFY_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('release_success');

			return true;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ITEMTYPE_DETAIL_MODIFY_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('release_success');

		return true;
	}

	protected function doDelete(&$request, &$response) {

		// get requests
		$groupid = $request->getParameter('groupid');

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_usergroup') ) ) {
			return false;
		}

		// transaction
		$transaction = Xoonips_Transaction::getInstance();
		$transaction->start();

		// delete all
		if (!$this->deleteGroupAll($groupid)) {
			$transaction->rollback();

			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_DELETE_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('delete_success');
			return true;
		}

		// success
		$transaction->commit();

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_DELETE_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('delete_success');

		return true;
	}

	protected function doDetailregister(&$request, &$response) {

		// get requests
		$groupid = $request->getParameter('base_groupid');
		$changeop = $request->getParameter('changeop');

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_SELECT_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_SELECT_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setDetailBreadcrumbs($title, $groupid);

		// get edit group info
		$groupInfo = $this->getGroupInfoForEdit($groupid, true);

		// get group member
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
		$members = $groupBean->getGroupDetails($groupid);

		// get details for select
		$userfields = $this->getDetailsForSelect($members);

		// token ticket
		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_usertype_detailadd'));

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['groupid'] = $groupid;
		$viewData['group_name'] = $groupInfo['a_name'];
		$viewData['userfields'] = $userfields;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('detailregister_success');
		return true;
	}

	protected function doDetailregistersave(&$request, &$response) {

		// get requests
		$groupid = $request->getParameter('groupid');
		$changeop = $request->getParameter('changeop');

		//title
		$title = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_SELECT_TITLE;
		$description = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_SELECT_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setDetailBreadcrumbs($title, $groupid);

		// get fields info
		$userfields = array();
		$userfieldBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean', $this->dirname, $this->trustDirname);
		$count = $userfieldBean->countUserfields();
		$userfields_objs = $userfieldBean->getUserfieldlist($count, 0);

		foreach ($userfields_objs as $userfield) {
			$userfieldid = $userfield['user_detail_id'];
			if ($request->getParameter('checkbox_'.$userfieldid)) {
				$userfields[] = $userfieldid;
			}
		}

		// check token ticket
		if ( !$this->validateToken( $this->modulePrefix('admin_policy_usertype_detailadd') ) ) {
			return false;
		}

		// update link of group and detail
		if ( !$this->updateGroupDetailLink($groupid, $userfields) ) {
			$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php';
			$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_SELECT_MSG_FAILURE;
			$response->setViewData($viewData);
			$response->setForward('detailregistersave_success');
			return true;
		}

		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname."/admin/policy_userfieldgroup.php?op=edit&groupid=$groupid";
		$viewData['redirect_msg'] = _AM_XOONIPS_POLICY_ACCOUNT_DETAIL_SELECT_MSG_SUCCESS;
		$response->setViewData($viewData);
		$response->setForward('detailregistersave_success');
		return true;
	}

	private function setBreadcrumbs($title) {
		$breadcrumbs = array(
			array(
			    'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ACCOUNT_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_user_menu.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ACCOUNT_GROUP_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php',
			),
			array(
			    'name' => $title,
			),
		);
		return $breadcrumbs;
	}

	private function setDetailBreadcrumbs($title, $groupid) {
		$breadcrumbs = array(
			array(
			    'name' => _AM_XOONIPS_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ITEM_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_user_menu.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ACCOUNT_GROUP_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php',
			),
			array(
			    'name' => _AM_XOONIPS_POLICY_ACCOUNT_GROUP_MODIFY_TITLE,
			    'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_userfieldgroup.php?'.'op=edit&groupid='.$groupid),
			array(
			    'name' => $title,
			),
		);
		return $breadcrumbs;
	}

	// get edit field group info
	private function getGroupInfoForEdit($groupid, $ng=false) {
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean', $this->dirname, $this->trustDirname);
		if ($ng) {
			$info = $groupBean->getGroupEditInfo($groupid);
		} else {
			$info = $groupBean->getGroupEditInfo($groupid, true);
		}
		$groupInfo = array (
		    'a_name' => $info['a_released']==1 ? $info['b_name'] : $info['a_name'],
			'a_xml' => $info['a_released']==1 ? $info['b_xml'] : $info['a_xml'],
		    'a_occurrence' => $info['a_released']==1 ? $info['b_occurrence'] : $info['a_occurrence'],
			'a_weight' => $info['a_released']==1 ? $info['b_weight'] : $info['a_weight'],
			'b_name' => $info['a_released']==1 ? $info['a_name'] : $info['b_name'],
		    'b_xml' => $info['a_released']==1 ? $info['a_xml'] : $info['b_xml'],
			'b_occurrence' => $info['a_released']==1 ? $info['a_occurrence'] : $info['b_occurrence'],
			'b_weight' => $info['a_released']==1 ? $info['a_weight'] : $info['b_weight'],
			'b_group_id' => $info['b_group_id']
		);
		return $groupInfo;
	}

	private function isDiff($groupid) {
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean', $this->dirname, $this->trustDirname);
		$info = $groupBean->getGroupEditInfo($groupid);
		if ($info['b_name'] != $info['a_name'] || $info['b_xml'] != $info['a_xml']
				|| $info['b_occurrence'] != $info['a_occurrence']
				|| $info['b_weight'] != $info['a_weight']) {
			return true;
		}

		// Diff detail link
		if (self::isDetailLinkDiff($groupid)) return true;

		return false;
	}

	private function isDetailLinkDiff($groupid) {
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
		$detailInfos = $groupBean->getGroupDetails($groupid);
		foreach ($detailInfos as $detail) {
			if ($detail['edit'] != $detail['link_release']
			|| $detail['edit_weight'] != $detail['weight']) {
				return true;
			}
		}
		return false;
	}

	private function doGroupregistersaveInputCheck($name, $xml, &$errors){
		// group name
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_GROUP_NAME;
		if ($name=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
			if ($groupBean->existGroupName(0, $name)) {
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
			}
		}

		// group xml
		$parameters = array();
		$parameters[] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_ID;
		if ($xml=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
			if ($groupBean->existGroupXml(0, $xml)) {
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
			}
		}

		if (count($errors->getErrors()) > 0) {
			return false;
		}
		return true;
	}

	private function deleteGroupAll($groupid) {

		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);

		// delete detail link
		if ( !$groupBean->deleteLink( $groupid ) ) return false;

		// delete group
		if ( !$groupBean->delete( $groupid ) ) return false;

		return true;
	}

	private function doCopyUsergroup( $groupid, $isCopy = false, &$insertId) {
		$map = array();
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
		if ($isCopy) {
			if (!$groupBean->copyById($groupid, $map)) return false;
		}
		else
		{
			if (!$groupBean->copyById($groupid, $map, true)) return false;

			$insertId = $map['group'][$groupid];
		}
		return true;
	}

	// insert usertype group
	private function insertXoonipsUsertypeGroup( $name, $xml, $occurrence, &$new_group_id ) {
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);

		$group_info = array();
		$group_info['preselect'] = 0;
		$group_info['released'] = 0;
		$group_info['name'] = $name;
		$group_info['xml'] = $xml;
		$group_info['weight'] = $groupBean->getMaxGroupWeight() + 1;
		$group_info['occurrence'] = $occurrence=='' ? 0 : $occurrence;
		$group_info['update_id'] = NULL;
		$new_group_id = 0;
		return $groupBean->insert($group_info, $new_group_id);
	}

	private function getFieldInfos($groupid) {
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
		$detailInfos = $groupBean->getGroupDetails($groupid);
		$details = array();
		foreach ($detailInfos as $detail) {
			if ($detail['edit'] == 1) {
				$details[] = array(
					'detail_id' => $detail['user_detail_id'],
				    'name' => $detail['name'],
				    'xml' => $detail['xml'],
					'weight' => $detail['edit_weight']
				);
			}
		}
		return $details;
	}

	private function doGroupeditsaveInputCheck($group_id, $name, $xml, &$errors, $base_groupid){
		// group name
		$parameters = array();
		$parameters[] = _AM_XOONIPS_LABEL_ITEMTYPE_GROUP_NAME;
		if ($name=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
			if ($groupBean->existGroupName($group_id, $name, $base_groupid)) {
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
			}
		}

		// group xml
		$parameters = array();
		$parameters[] = _AM_XOONIPS_POLICY_ACCOUNT_GROUP_ID;
		if ($xml=='') {
			$errors->addError("_AM_XOONIPS_ERROR_REQUIRED", "", $parameters);
		} else {
			$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
			if ($groupBean->existGroupXml($group_id, $xml, $base_groupid)) {
				$errors->addError("_AM_XOONIPS_ERROR_DUPLICATE_MSG", "", $parameters);
			}
		}

		if (count($errors->getErrors()) > 0) {
			return false;
		}
		return true;
	}

	// update group
	private function updateXoonipsUsertypeGroup( $groupid, $name, $xml, $occurrence ) {
		$group_info = array();
		$group_info['name'] = $name;
		$group_info['xml'] = $xml;
		$group_info['occurrence'] = $occurrence=='' ? 0 : $occurrence;

		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
		return $groupBean->update($group_info, $groupid);
	}

	// update detail link weight
	private function updateXoonipsUsertypeDetailOrder( $groupid, $dids, $orders ) {

		if ($dids == '') return true;
		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);

		//update display order
		foreach ( $dids as $key =>$id) {
			if($orders[$key]!= $key+1){
				if (!$groupBean->updateWeightForLink($groupid, $id, $key+1)) return false;
			}
		}
		return true;
	}

	// update link of group and detail
	private function updateGroupDetailLink($groupid, $dids) {

		$groupBean = Xoonips_BeanFactory::getBean('UserFieldGroupBean',$this->dirname,$this->trustDirname);
		$detailInfos = $groupBean->getGroupDetails($groupid);

		// update set 0 at all cloumn of edit
		foreach ($detailInfos as $detail) {
			$groupBean->updateLinkEdit($groupid, $detail['user_detail_id'], 0);
		}

		foreach ($dids as $id) {
			$insert_chk = true;
			foreach ($detailInfos as $detail) {
				if ($detail['user_detail_id'] == $id) {
					$insert_chk = false;
					break;
				}
			}
			if ($insert_chk) {
				$info = array('group_id'=>$groupid,
				'user_detail_id'=>$id,
				'weight'=>255,
				'edit'=>1,
				'edit_weight'=>255,
				'released'=>0);
				$groupBean->insertLink($info, $insertId);
			} else {
				$groupBean->updateLinkEdit($groupid, $id, 1);
			}
		}

		return true;
	}

	// get details for select
	private function getDetailsForSelect($members=array()) {
		$userfields = array();

		$detailBean = Xoonips_BeanFactory::getBean('UserFieldDetailBean', $this->dirname, $this->trustDirname);
		$count = $detailBean->countUserfields();
		$userfields_objs = $detailBean->getUserfieldlist($count, 0);

		foreach ($userfields_objs as $userfield) {
			if ($userfield['released'] == 0) {
				continue;
			}
			$userfieldid = $userfield['user_detail_id'];
			$name = $userfield['name'];
			$xml = $userfield['xml'];
			$preselect = $userfield['preselect'];
			$select = 0;
			foreach ($members as $member) {
				if ($member['user_detail_id'] == $userfieldid
				&& $member['edit'] == 1){
					$select = 1;
				}
			}

			$userfields[] = array(
			    'userfieldid' => $userfieldid,
			    'name' => $name,
			    'xml' => $xml,
				'select' => $select,
				'preselect' => $preselect
			);
		}

		return $userfields;
	}

}

