<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Errors.class.php';
require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';

class Xoonips_SystemItemFieldValueSetSubAction extends Xoonips_ActionBase {
	protected function doInit(&$request, &$response) {
		$select_name = $request->getParameter2('select_name');
		$title_id_db = $request->getParameter2('title_id_db');
		$canIdEdit = $request->getParameter('canIdEdit');
		$mode = $request->getParameter('mode');
		$title_id = $request->getParameter2('title_id');
		$title = $request->getParameter2('title');
		if (_CHARSET != 'UTF-8') {
			$title_id_db = mb_convert_encoding($title_id_db, _CHARSET, 'utf-8');
			$title_id = mb_convert_encoding($title_id, _CHARSET, 'utf-8');
			$title = mb_convert_encoding($title, _CHARSET, 'utf-8');
		}

		if (is_null($title_id_db)) {
			$title_id_db = $title_id;
		}

		// mode 2:edit 4:delete
		if ($mode == 2 || $mode == 4) {
			$itemFieldValueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);
			$itemFieldValueSet = $itemFieldValueSetBean->getInfo($title_id, $select_name);	
			$title = $itemFieldValueSet['title'];
			if (is_null($canIdEdit) && $mode == 2) {
				if ($itemFieldValueSetBean->checkUsedTitleId($select_name, $title_id) > 0) {
					$canIdEdit = false;
				}
			}	
		}

		if (is_null($canIdEdit)) {
			if ($mode == 4) {
				$canIdEdit = false;
			} else {
				$canIdEdit = true;
			}
		}

		$this->setCommonData($select_name, $title_id_db, $canIdEdit, $mode, $title_id, $title, $viewData);
		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}

	protected function doUpdate(&$request, &$response) {
		if (!$this->validateToken($this->modulePrefix('admin_system_item_field_value_set'))) {
			$response->setSystemError('Ticket error');
			return false;
		}

		$itemFieldValueSetBean = Xoonips_BeanFactory::getBean('ItemFieldValueSetBean', $this->dirname, $this->trustDirname);

		//get parameter
		$mode = $request->getParameter('mode');
		$select_name = $request->getParameter2('select_name');
		$title_id_db = $request->getParameter2('title_id_db');
		$canIdEdit = $request->getParameter('canIdEdit');
		$title_id = $request->getParameter2('title_id');
		$title = $request->getParameter2('title');
		if (_CHARSET != 'UTF-8') {
			$select_name = mb_convert_encoding($select_name, _CHARSET, 'utf-8');
			$title_id_db = mb_convert_encoding($title_id_db, _CHARSET, 'utf-8');
			$title_id = mb_convert_encoding($title_id, _CHARSET, 'utf-8');
			$title = mb_convert_encoding($title, _CHARSET, 'utf-8');
		}

		$viewData = array();
		$viewData['dirname'] = $this->dirname;
	    $viewData['callbackvalue'] = $mode;
		$itemFieldValueSet = array();
		// if mode is not delete, input check
		if ($mode != 4) {
			$xoonipsErrors = new Xoonips_Errors();
			if ($title == '') {
				$parameters[] = _AM_XOONIPS_ITEM_FIELD_VALUE_NAME;
				$xoonipsErrors->addError('_AM_XOONIPS_ERROR_REQUIRED', 'title', $parameters);
			}
			if (strlen($title) > 255) {
				$parameters[] = _AM_XOONIPS_ITEM_FIELD_VALUE_NAME;
				$parameters[] = 255;
				$xoonipsErrors->addError('_AM_XOONIPS_ERROR_MAXLENGTH', 'title', $parameters);
			}
			if ($title_id == '') {
				$parameters[] = _AM_XOONIPS_ITEM_FIELD_VALUE_ID;
				$xoonipsErrors->addError('_AM_XOONIPS_ERROR_REQUIRED', 'title_id', $parameters);
			}
			if (strlen($title_id) > 30) {
				$parameters[] = _AM_XOONIPS_ITEM_FIELD_VALUE_ID;
				$parameters[] = 255;
				$xoonipsErrors->addError('_AM_XOONIPS_ERROR_MAXLENGTH', 'title_id', $parameters);
			}
			if ($xoonipsErrors->hasError()) {
				$viewData['errors'] = $xoonipsErrors->getView($this->dirname);
				$this->setCommonData($select_name, $title_id_db, $canIdEdit, $mode, $title_id, $title, $viewData);
				$response->setViewData($viewData);
				$response->setForward('input_error');
				return true;
			}
		}

		//new mode
		if ($mode == 1) {
			if ($select_name == '') {
				$response->setSystemError(_AM_XOONIPS_ITEM_FILED_LIST_NAME_REQUIRED);
				return false;
			}
			$itemFieldValueSet = $itemFieldValueSetBean->getValue($select_name);
			if (!$itemFieldValueSet) {
				$itemFieldValueSet['select_name'] = $select_name;
				$itemFieldValueSet['title_id'] = $title_id;
				$itemFieldValueSet['title'] = $title;
				$itemFieldValueSet['weight'] = 1;
				$result = $itemFieldValueSetBean->insertValue($itemFieldValueSet);
				if (!$result) {
					$response->setSystemError(_AM_XOONIPS_ERROR_DBUPDATE_FAILED);
					return false;
				}
			} else {
				if ($itemFieldValueSetBean->checkTitle($select_name, $title)) {
					$parameters[] = null;
					$xoonipsErrors->addError('_AM_XOONIPS_ITEM_FIELD_VALUE_TITLE_EXIT', 'title', $parameters);
				}
				if ($itemFieldValueSetBean->checkTitleId($select_name, $title_id)) {
					$parameters[] = null;
					$xoonipsErrors->addError('_AM_XOONIPS_ITEM_FIELD_VALUE_TITLE_ID_EXIT', 'title_id', $parameters);
				}
				if ($xoonipsErrors->hasError()) {
					$viewData['errors'] = $xoonipsErrors->getView($this->dirname);
					$this->setCommonData($select_name, $title_id_db, $canIdEdit, $mode, $title_id, $title, $viewData);
					$response->setViewData($viewData);
					$response->setForward('input_error');
					return true;
				}
				$response->setSystemError(_AM_XOONIPS_ITEM_TYPE_VALUE_SET_NAME_EXIT);
				return false;
			}
		//edit mode
		} elseif ($mode == 2) {
			$itemFieldValueSet = $itemFieldValueSetBean->getInfo($title_id_db, $select_name);			
			if ($itemFieldValueSet['title'] != $title) {
				if ($itemFieldValueSetBean->checkTitle($select_name, $title)) {
					$parameters[] = null;
					$xoonipsErrors->addError('_AM_XOONIPS_ITEM_FIELD_VALUE_TITLE_EXIT', 'title', $parameters);
				}
			}
			if ($itemFieldValueSet['title_id'] != $title_id) {
				if ($itemFieldValueSetBean->checkTitle($select_name, $title_id)) {
					$parameters[] = null;
					$xoonipsErrors->addError('_AM_XOONIPS_ITEM_FIELD_VALUE_TITLE_ID_EXIT', 'title_id', $parameters);
				}
			}
			if ($xoonipsErrors->hasError()) {
				$viewData['errors'] = $xoonipsErrors->getView($this->dirname);
				$this->setCommonData($select_name, $title_id_db, $canIdEdit, $mode, $title_id, $title, $viewData);
				$response->setViewData($viewData);
				$response->setForward('input_error');
				return true;
			}
			$itemFieldValueSet['select_name'] = $select_name;
			$itemFieldValueSet['title_id_db'] = $itemFieldValueSet['title_id'];
			$itemFieldValueSet['title'] = $title;
			$itemFieldValueSet['title_id'] = $title_id;
			$result = $itemFieldValueSetBean->updateValue($itemFieldValueSet);
			if (!$result) {
				$response->setSystemError(_AM_XOONIPS_ERROR_DBUPDATE_FAILED);
				return false;
			}
		// add mode
		} elseif ($mode == 3) {
			if ($itemFieldValueSetBean->checkTitle($select_name, $title)) {
				$parameters[] = null;
				$xoonipsErrors->addError('_AM_XOONIPS_ITEM_FIELD_VALUE_TITLE_EXIT', 'title', $parameters);
			}
			if ($itemFieldValueSetBean->checkTitle($select_name, $title_id)) {
				$parameters[] = null;
				$xoonipsErrors->addError('_AM_XOONIPS_ITEM_FIELD_VALUE_TITLE_ID_EXIT', 'title_id', $parameters);
			}
			if ($xoonipsErrors->hasError()) {
				$viewData['errors'] = $xoonipsErrors->getView($this->dirname);
				$this->setCommonData($select_name, $title_id_db, $canIdEdit, $mode, $title_id, $title, $viewData);
				$response->setViewData($viewData);
				$response->setForward('input_error');
				return true;
			}
			$weight = $itemFieldValueSetBean->getMax($select_name, 'weight');
			$itemFieldValueSet['select_name'] = $select_name;
			$itemFieldValueSet['title_id'] = $title_id;
			$itemFieldValueSet['title'] = $title;
			$itemFieldValueSet['weight'] = $weight + 1;
			$result = $itemFieldValueSetBean->insertValue($itemFieldValueSet);
			if (!$result) {
				$response->setSystemError(_AM_XOONIPS_ERROR_DBUPDATE_FAILED);
				return false;
			}
		// delete mode
		} elseif ($mode == 4) {
			$viewData['callbackid'] = $title_id;
			$viewData['callbackvalue'] = $mode;
		}
		$response->setViewData($viewData);
		$response->setForward('update_success');
		return true;
	}

	private function setCommonData($select_name, $title_id_db, $canIdEdit, $mode, $title_id, $title, &$viewData) {
		$token_ticket = $this->createToken($this->modulePrefix('admin_system_item_field_value_set'));
		$viewData['token_ticket'] = $token_ticket;
		$viewData['select_name'] = $select_name;
		$viewData['title_id_db'] = $title_id_db;
		$viewData['mode'] = $mode;
		$viewData['canIdEdit'] = $canIdEdit;
		$viewData['title_id'] = $title_id;
		$viewData['title'] = $title;
		$viewData['dirname'] = $this->dirname;
	}
}

