<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
/**
 * @brief operate xoonips_item_type_sort table
 *
 */
class Xoonips_ItemTypeSortBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function Xoonips_ItemTypeSortBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('item_type_sort', true);
	}

	/**
	 * select item sort
	 *
	 * @param
	 * @return array
	 */
	public function select($sort_id = null) {
		$ret = array();
		$sql = 'SELECT * FROM ' . $this->table;
		if (!is_null($sort_id)) {
			$sql .= ' WHERE sort_id = ' . $sort_id;
		}
		$sql .= ' ORDER BY sort_id';
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * select item sort
	 *
	 * @param
	 * @return array
	 */
	public function selectByTitle($title) {
		$ret = array();
		$sql = 'SELECT * FROM ' . $this->table . ' WHERE title = ' . Xoonips_Utils::convertSQLStr($title);
		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * insert
	 *
	 * @param  string $title:title
	 * @return int
	 */
	public function insert($title, &$insertId) {
		$sql = 'INSERT INTO ' . $this->table . ' (title) VALUES (' . Xoonips_Utils::convertSQLStr($title) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$insertId = $this->getInsertId();
		return true;
	}

	/**
	 * update
	 *
	 * @param  int $sort_id:sort_id
	 * @param  string $title:title
	 * @return  bool true:success,false:failed
	 */
	public function update($sort_id, $title) {
		$ret = true;
		$sql = 'UPDATE ' . $this->table . ' SET title=' . Xoonips_Utils::convertSQLStr($title) . ' WHERE sort_id = ' . $sort_id;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return $ret;
	}

	/**
	 * delete by id
	 *
	 * @param  int $sort_id:sort_id
	 * @return  bool true:success,false:failed
	 */
	public function delete($sort_id) {

		$sql = "DELETE FROM $this->table WHERE sort_id=$sort_id";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	public function getDetailList($sort_id) {
		$ret = array();
		$sort_detail = $this->prefix($this->modulePrefix('item_type_sort_detail'));
		$item_type = $this->prefix($this->modulePrefix('item_type'));
		$item_field_group = $this->prefix($this->modulePrefix('item_field_group'));
		$item_field_detail = $this->prefix($this->modulePrefix('item_field_detail'));
		$sql = "SELECT it.item_type_id, it.name AS item_type_name, itd.item_field_detail_id,
				itd.name AS item_type_detail_name, itg.name AS item_type_group_name,
	    		isd.item_field_detail_id AS selected_item_field_detail_id
			FROM  ".$item_type. " it
	    	   INNER JOIN ".$item_field_group."  itg  ON itg.item_type_id = it.item_type_id
	    	   INNER JOIN ".$item_field_detail." itd  ON itd.item_type_id = it.item_type_id AND itd.group_id = itg.group_id
	    	   LEFT  JOIN ".$sort_detail." isd ON isd.item_type_id = it.item_type_id
	    	       AND isd.item_field_detail_id = itd.item_field_detail_id AND isd.sort_id = '".$sort_id."'
			WHERE it.released = 1
			ORDER BY it.weight, it.item_type_id, itg.weight, itg.group_id, itd.weight, itd.item_field_detail_id";

		$result = $this->execute($sql);
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[$row['item_type_id']][] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}
}

