<?php

require_once(dirname(dirname(__FILE__)) . '/class/mail_pop.php');
require_once(dirname(dirname(__FILE__)) . '/class/mail_parse.php');

function spicky_batch_mail_post() {
	global $mydirname;
	global $xoopsDB;
	global $xoopsModuleConfig;

	if ($xoopsModuleConfig['use_mail_post'] == 0) {
		return;
	}
	
	$host = $xoopsModuleConfig['mail_post_host'];
	$port = $xoopsModuleConfig['mail_post_port'];
	$user = $xoopsModuleConfig['mail_post_address'];
	$pass = $xoopsModuleConfig['mail_post_password'];

	$pop =& spicky_lib_mail_pop::getInstance();
	$pop->set_host($host);
	$pop->set_port($port);
	$pop->set_user($user);
	$pop->set_pass($pass);

	$pop->recv_mails();
	$mails = $pop->get_mails();

	foreach ($mails as $raw_mail) {
	  spicky_batch_mail_post_parse($raw_mail);
	}
}

function spicky_batch_mail_post_parse($raw_mail) {
	global $mydirname;
	global $xoopsDB;
	global $xoopsModuleConfig;

	$parse =& spicky_lib_mail_parse::getInstance();

	$parse->parse_mail($raw_mail);
	$result = $parse->get_result();
	
	if ($result == false) {
	  return;
	}
	
	foreach ($result['attaches'] as $atta) {
	  if (preg_match('/image/', $atta['type'])) {
		spicky_batch_mail_post_insert($atta);
	  }
	}
}

function spicky_batch_mail_post_insert($atta) {
	global $mydirname;
	global $xoopsDB;
	global $xoopsModuleConfig;

	$user_id = 0;

	$width = 320;
	$height= 320;

	$type_dummy = 2;
	$ext_dummy = 'jpg';

	$code = spicky_get_randam_code();
	$tmp_image_id = spicky_insert_image_tmp('',  $code, $width, $height, $type_dummy, $user_id, SPICKY_UPLOAD_TYPE_MAIL_POST, '');

	$dest_dir = spicky_mkdir_p_number($tmp_image_id, 1);
	$dest_file = $dest_dir . '/' . $tmp_image_id . '_' . $code . '.' . $ext_dummy;

	$fp = fopen($dest_file, 'wb');
	//fwrite($fp, $atta['binary']);
	fwrite($fp, $atta['content']);
	fclose($fp);

	$type = spicky_is_image_file($dest_file);

	if ($type == 0) {
		// no image file
		return;
	}

	if ($type != $type_dummy) {
		$new_file = $dest_dir . '/' . $tmp_image_id . '_' . $code . '.' . $GLOBALS['spicky_image_ext'][$type];
		copy($dest_file, $new_file);
		spicky_update_image_tmp($tmp_image_id, $type);
	}

	$size = getimagesize($dest_file);
	$width = $size[0];
	$height = $size[1];

	spicky_upload_image_resize_regular($type, $dest_file);
	$image_id = spicky_insert_image('', '', $code, $width, $height, $type, $user_id, '', @$status, SPICKY_UPLOAD_TYPE_EXT, '');
	spicky_move_tmp_to_image($tmp_image_id, $image_id, $code, $type);
	spicky_update_image_tmp_master_id($tmp_image_id, $image_id);

	$image['id'] = $image_id;
	$image['code'] = $code;
	$image['type'] = $type;

	$filename = XOOPS_ROOT_PATH . spicky_make_image_path($mydirname, $image, 0);

	$exif_str = '';
	$model = '';
	if (function_exists('exif_read_data') && $image['type'] == SPICKY_JPG_FILE) {
	  $exif = exif_read_data($filename, 0, true);
	  if ($exif) {
	    foreach ($exif as $key => $section) {
	      foreach ($section as $name => $val) {
		if ($key == 'IFD0' && $name == 'Model') {
		  $model = $val;
		}
		$exif_str .= "$key.$name: $val\n";
	      }
	    }
	  }
	}

	spicky_update_image($image_id, '', '', 
			    1, 1, 1, $user_id, '', @$status, $exif_str, $model);

	if ($xoopsModuleConfig['auto_model_tag'] && $model != '' && 0 < $xoopsModuleConfig['num_of_tag']) {
	  $tag_name = trim($model);
	  $tag_id = spicky_add_tag_to_image($image_id, $tag_name, $user_id, 1);
	  spicky_countup_tag($tag_name, 1);
	}

	spicky_image_tag_set($image_id);
}

