#!/usr/bin/php
<?php

$xoopsOption['nocommon'] = 1;
require '../../../mainfile.php' ;

define('_CHARSET', 'EUC-JP');

if (@$argv[1] != '') {
  $mydirname = $argv[1];
} else {
  $mydirname = 'spicky';
}

ini_set( 'mbstring.http_output','EUC-JP');
ini_set( 'mbstring.internal_encoding','EUC-JP'); 

require_once(XOOPS_ROOT_PATH . '/class/logger.php');
require_once(XOOPS_ROOT_PATH . '/class/database/mysqldatabase.php');
require_once(XOOPS_ROOT_PATH . '/class/module.textsanitizer.php');
require_once(XOOPS_ROOT_PATH . '/class/xoopsobject.php');
require_once(XOOPS_ROOT_PATH . '/class/criteria.php');
require_once(XOOPS_ROOT_PATH . '/include/functions.php');
require_once(XOOPS_ROOT_PATH . '/kernel/config.php');
require_once(dirname(__FILE__) . '/constants.php');
require_once(dirname(__FILE__) . '/include/groupperm_function.php');
require_once(dirname(__FILE__) . '/include/misc.php');
require_once(dirname(__FILE__) . '/include/db.php');

$logger = new XoopsLogger();

$xoopsDB = new XoopsMySQLDatabaseSafe();
$xoopsDB->setLogger($logger);
$xoopsDB->connect(true);
$xoopsDB->setPrefix(XOOPS_DB_PREFIX);

$mytrustdirname = basename( dirname( __FILE__ ) ) ;
$mytrustdirpath = dirname( __FILE__ ) ;

$module_handler =& xoops_gethandler('module');
$config_handler =& xoops_gethandler('config');

$xoopsModule =& $module_handler->getByDirname($mydirname);
$xoopsModuleConfig =& $config_handler->getConfigsByCat(0, $xoopsModule->getVar('mid'));

require_once('batch/batch_time_limit.php');
require_once('batch/batch_mail_post.php');
require_once('batch/batch_tag_reflesh.php');

spicky_batch_time_limit();
spicky_batch_auto_delete();
spicky_batch_mail_post();
spicky_batch_tag_reflesh();

