<?php

function b_spicky_rank_access_monthly_show($options) {

	global $xoopsDB;
	
	$block = array();

	$mydirname = $options[0] ;
	$limit = $options[1] ;
	$size = $options[2];
	
	require_once(XOOPS_TRUST_PATH . '/modules/spicky/include/misc.php');
	
	spicky_main_css($mydirname);
	
	$offset = 0;
	$limit = intval($options[1]) ? $options[1] : 3;
	
    $t = time();
    $tm = localtime($t);
    $year = $tm[5] + 1900;
    $month = $tm[4] + 1;
    $day = $tm[3];
    $week = intval($tm[7] / 7);

    $sql = "SELECT i.id as id, i.title as title, i.desc as `desc`, i.reg_user as reg_user, i.reg_time as reg_time, i.code as code, i.width as width, i.height as height, i.type as type, i.bookmark as bookmark, a.count as `view`, i.paint_from_id as paint_from_id, i.public_level as public_level, i.pasteok as pasteok, i.limit_level as limit_level ";
    $sql .= ' FROM ';
    $sql .= $xoopsDB->prefix($mydirname . '_image') . ' AS i, ';
    $sql .= $xoopsDB->prefix($mydirname . '_access_count_monthly') . ' AS a ';
    $sql .= ' WHERE i.id = a.image_id AND ';
    $sql .= ' a.year = ' . intval($year) . ' AND ';
    $sql .= ' a.month = ' . intval($month) . ' AND ';
    $sql .= ' i.status = 1 ';
    $sql .= ' ORDER BY a.count DESC, i.reg_time DESC ';
    $sql .= ' LIMIT 0, ' . intval($limit);

    $result = $xoopsDB->query($sql);
    
    $list = array();
    
    $i = 1;
    while ($row=$xoopsDB->fetchArray($result)) {
    	$list[$i++] = $row;
    }

    $block['image_list'] = $list;
    $block['size_of_thumb'] = $size;
    $block['mydirname'] = $mydirname;

    $this_template = 'db:' . $mydirname . '_block_rank_access_monthly.html';
    
    require_once XOOPS_ROOT_PATH.'/class/template.php' ;
    $tpl =& new XoopsTpl() ;
    $tpl->assign( 'block' , $block ) ;
    $ret['content'] = $tpl->fetch( $this_template ) ;

    return $ret ;
}

function b_spicky_rank_access_monthly_edit( $options )
{
	// options
	$mytrustdirname = basename(dirname(dirname(__FILE__))) ;
	$mydirname = empty( $options[0] ) ? $mytrustdirname : $options[0] ;

	if( preg_match( '/[^0-9a-zA-Z_-]/' , $mydirname ) ) die( 'Invalid mydirname' ) ;

	require_once XOOPS_ROOT_PATH.'/class/template.php' ;
	$tpl =& new XoopsTpl() ;
	$tpl->assign( array(
		'mydirname' => $mydirname ,
		'limit' => $options[1],
		'size' => $options[2],
	) ) ;
	return $tpl->fetch( 'db:'.$mydirname.'_block_rank_access_daily_edit.html' ) ;
}


